/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOArrayDataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXEnterpriseObject;
import er.extensions.eof.ERXReplicableInterface;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXStringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.TimeZone;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXUtilities {
    public static final Logger log = Logger.getLogger(ERXUtilities.class);
    private static NSDictionary<String, EOEntity> _entityNameEntityCache;
    private static NSTimestampFormatter _gregorianDateFormatterForJavaDate;
    public static final NSTimestamp DISTANT_FUTURE;
    public static final NSTimestamp DISTANT_PAST;

    public static void addObjectToObjectOnBothSidesOfRelationshipWithKey(EOEnterpriseObject addedObject, EOEnterpriseObject referenceObject, String key) {
        ERXEOControlUtilities.addObjectToObjectOnBothSidesOfRelationshipWithKey(addedObject, referenceObject, key);
    }

    public static EOEnterpriseObject createEO(String entityName, EOEditingContext editingContext) {
        return ERXUtilities.createEO(entityName, editingContext, null);
    }

    public static EOEnterpriseObject createEO(String entityName, EOEditingContext editingContext, NSDictionary objectInfo) {
        return ERXEOControlUtilities.createAndInsertObject(editingContext, entityName, objectInfo);
    }

    public static EOEnterpriseObject createEOLinkedToEO(String entityName, EOEditingContext editingContext, String relationshipName, EOEnterpriseObject eo) {
        return ERXEOControlUtilities.createAndAddObjectToRelationship(editingContext, eo, relationshipName, entityName, null);
    }

    public static EOEnterpriseObject createEOLinkedToEO(String entityName, EOEditingContext editingContext, String relationshipName, EOEnterpriseObject eo, NSDictionary objectInfo) {
        return ERXEOControlUtilities.createAndAddObjectToRelationship(editingContext, eo, relationshipName, entityName, objectInfo);
    }

    public static EOEnterpriseObject localInstanceOfObject(EOEditingContext ec, EOEnterpriseObject eo) {
        return ERXEOControlUtilities.localInstanceOfObject(ec, eo);
    }

    public static NSArray localInstancesOfObjects(EOEditingContext ec, NSArray eos) {
        return ERXEOControlUtilities.localInstancesOfObjects(ec, eos);
    }

    public static EOEnterpriseObject sharedObjectWithFetchSpec(String fetchSpec, String entityName) {
        return ERXEOControlUtilities.sharedObjectWithFetchSpec(entityName, fetchSpec);
    }

    public static EOEnterpriseObject sharedObjectWithPrimaryKey(Object pk, String entityName) {
        return ERXEOControlUtilities.sharedObjectWithPrimaryKey(entityName, pk);
    }

    public static NSDictionary primaryKeyDictionaryForEntity(EOEditingContext ec, String entityName) {
        return ERXEOAccessUtilities.primaryKeyDictionaryForEntity(ec, entityName);
    }

    public static NSArray deletedObjectsPKeys(EOEditingContext ec) {
        NSMutableArray<Object> result = new NSMutableArray<Object>();
        Enumeration e = ec.deletedObjects().objectEnumerator();
        while (e.hasMoreElements()) {
            EOEnterpriseObject eo = (EOEnterpriseObject)e.nextElement();
            if (eo instanceof ERXEnterpriseObject) {
                result.addObject(((ERXEnterpriseObject)eo).primaryKeyInTransaction());
                continue;
            }
            result.addObject(EOUtilities.primaryKeyForObject((EOEditingContext)ec, (EOEnterpriseObject)eo));
        }
        return result;
    }

    public static void makeEditableSharedEntityNamed(String entityName) {
        ERXEOAccessUtilities.makeEditableSharedEntityNamed(entityName);
    }

    public static EOArrayDataSource dataSourceForArray(NSArray array) {
        return ERXEOControlUtilities.dataSourceForArray(array);
    }

    public static EORelationship relationshipWithObjectAndKeyPath(EOEnterpriseObject object, String keyPath) {
        EOEnterpriseObject lastEO = ERXUtilities.relationshipObjectWithObjectAndKeyPath(object, keyPath);
        EORelationship relationship = null;
        if (lastEO != null) {
            EOEntity entity = ERXEOAccessUtilities.entityNamed(object.editingContext(), lastEO.entityName());
            String lastKey = ERXStringUtilities.lastPropertyKeyInKeyPath(keyPath);
            relationship = entity.relationshipNamed(lastKey);
        }
        return relationship;
    }

    public static NSDictionary relationshipEntityWithEntityAndKeyPath(EOEntity srcentity, String keyPath) {
        String key;
        EORelationship rel;
        if (keyPath.indexOf(".") == -1) {
            NSDictionary<Object, Object> d = new NSDictionary<Object, Object>(new Object[]{srcentity, keyPath}, new Object[]{"entity", "keyPath"});
            return d;
        }
        while (keyPath.indexOf(".") != -1 && (rel = srcentity.relationshipNamed(key = ERXStringUtilities.firstPropertyKeyInKeyPath(keyPath))) != null) {
            srcentity = rel.destinationEntity();
            keyPath = ERXStringUtilities.keyPathWithoutFirstProperty(keyPath);
        }
        NSDictionary<Object, Object> d = new NSDictionary<Object, Object>(new Object[]{srcentity, keyPath}, new Object[]{"entity", "keyPath"});
        return d;
    }

    public static EOEnterpriseObject relationshipObjectWithObjectAndKeyPath(EOEnterpriseObject object, String keyPath) {
        if (object == null) {
            return null;
        }
        EOEnterpriseObject lastEO = object;
        if (keyPath.indexOf(".") != -1) {
            String partialKeyPath = ERXStringUtilities.keyPathWithoutLastProperty(keyPath);
            Object rawLastEO = object.valueForKeyPath(partialKeyPath);
            lastEO = rawLastEO instanceof EOEnterpriseObject ? (EOEnterpriseObject)rawLastEO : null;
        }
        return lastEO;
    }

    public static void deleteObjects(EOEditingContext ec, NSArray objects) {
        if (ec == null) {
            throw new RuntimeException("Attempting to delete objects with a null editing context!");
        }
        if (objects != null && objects.count() > 0) {
            Enumeration e = objects.objectEnumerator();
            while (e.hasMoreElements()) {
                ec.deleteObject((EOEnterpriseObject)e.nextElement());
            }
        }
    }

    public static NSArray allFrameworkNames() {
        NSMutableArray<String> frameworkNames = new NSMutableArray<String>();
        Enumeration e = NSBundle.frameworkBundles().objectEnumerator();
        while (e.hasMoreElements()) {
            NSBundle bundle = (NSBundle)e.nextElement();
            if (bundle.name() != null) {
                frameworkNames.addObject(bundle.name());
                continue;
            }
            log.warn((Object)("Null framework name for bundle: " + bundle));
        }
        return frameworkNames;
    }

    public static NSArray intersectingElements(NSArray array1, NSArray array2) {
        NSArray intersection = null;
        if (array1 != null && array2 != null && array1.count() > 0 && array2.count() > 0) {
            NSMutableSet set1 = new NSMutableSet();
            NSMutableSet set2 = new NSMutableSet();
            set1.addObjectsFromArray(array1);
            set2.addObjectsFromArray(array2);
            intersection = set1.setByIntersectingSet(set2).allObjects();
        }
        return intersection != null ? intersection : NSArray.EmptyArray;
    }

    public static NSArray entitiesForModelGroup(EOModelGroup group) {
        return ERXArrayUtilities.flatten((NSArray)group.models().valueForKey("entities"));
    }

    public static EOEntity caseInsensitiveEntityNamed(String entityName) {
        EOEntity entity = null;
        if (entityName != null) {
            if (_entityNameEntityCache == null) {
                NSMutableDictionary<String, EOEntity> entityNameDict = new NSMutableDictionary<String, EOEntity>();
                Enumeration e = ERXUtilities.entitiesForModelGroup(ERXEOAccessUtilities.modelGroup(null)).objectEnumerator();
                while (e.hasMoreElements()) {
                    EOEntity anEntity = (EOEntity)e.nextElement();
                    entityNameDict.setObjectForKey(anEntity, anEntity.name().toLowerCase());
                }
                _entityNameEntityCache = entityNameDict;
            }
            entity = _entityNameEntityCache.objectForKey(entityName.toLowerCase());
        }
        return entity;
    }

    public static NSArray allSubEntitiesForEntity(EOEntity entity, boolean includeAbstracts) {
        NSMutableArray<EOEntity> entities = new NSMutableArray<EOEntity>();
        if (entity != null) {
            Enumeration e = entity.subEntities().objectEnumerator();
            while (e.hasMoreElements()) {
                EOEntity anEntity = (EOEntity)e.nextElement();
                if (includeAbstracts && anEntity.isAbstractEntity() || !anEntity.isAbstractEntity()) {
                    entities.addObject(anEntity);
                }
                if (anEntity.subEntities() == null || anEntity.subEntities().count() <= 0) continue;
                entities.addObjectsFromArray(ERXUtilities.allSubEntitiesForEntity(anEntity, includeAbstracts));
            }
        }
        return entities;
    }

    public static EOEntity rootParentEntityForEntity(EOEntity entity) {
        EOEntity root;
        for (root = entity; root != null && root.parentEntity() != null; root = root.parentEntity()) {
        }
        return root;
    }

    public static NSTimestampFormatter gregorianDateFormatterForJavaDate() {
        if (_gregorianDateFormatterForJavaDate == null) {
            _gregorianDateFormatterForJavaDate = new NSTimestampFormatter("%a %b %d %H:%M:%S %Z %Y");
        }
        return _gregorianDateFormatterForJavaDate;
    }

    public static String stackTrace() {
        String result = null;
        try {
            throw new Throwable();
        }
        catch (Throwable t) {
            result = ERXUtilities.stackTrace(t);
            String separator = System.getProperties().getProperty("line.separator");
            int offset = result.indexOf(separator);
            result = result.substring(offset + 1);
            offset = result.indexOf(separator);
            while (result.substring(0, offset).indexOf("ERXUtilities.java") >= 0) {
                result = result.substring(offset + 1);
                offset = result.indexOf(separator);
            }
            return separator + result;
        }
    }

    public static String stackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        PrintStream printStream = new PrintStream(baos);
        t.printStackTrace(printStream);
        return baos.toString();
    }

    public static NSTimestamp distantFuture() {
        return DISTANT_FUTURE;
    }

    public static NSTimestamp distantPast() {
        return DISTANT_PAST;
    }

    public static String escapeApostrophe(String aString) {
        NSArray<String> parts = NSArray.componentsSeparatedByString(aString, "'");
        return parts.componentsJoinedByString("");
    }

    public static NSSet setFromArray(NSArray array) {
        return ERXArrayUtilities.setFromArray(array);
    }

    public static NSSelector sortSelectorWithKey(String key) {
        return ERXArrayUtilities.sortSelectorWithKey(key);
    }

    public static void replicateDataFromEOToEO(EOEnterpriseObject r1, EOEnterpriseObject r2, NSArray attributeNames) {
        Enumeration e = attributeNames.objectEnumerator();
        while (e.hasMoreElements()) {
            String attributeName = (String)e.nextElement();
            r2.takeValueForKey(r1.valueForKey(attributeName), attributeName);
        }
    }

    public static void replicateRelationshipFromEOToEO(EOEnterpriseObject r1, EOEnterpriseObject r2, String relationshipName) {
        Enumeration e = ((NSArray)r1.valueForKey(relationshipName)).objectEnumerator();
        while (e.hasMoreElements()) {
            ERXReplicableInterface replicableTarget = (ERXReplicableInterface)e.nextElement();
            r2.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)replicableTarget.replicate(r2.editingContext()), relationshipName);
        }
    }

    public static void deplicateRelationshipFromEO(EOEnterpriseObject r1, String relationshipName) {
        Enumeration e = ((NSArray)r1.valueForKey(relationshipName)).objectEnumerator();
        while (e.hasMoreElements()) {
            ERXReplicableInterface replicableTarget = (ERXReplicableInterface)e.nextElement();
            r1.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)((EOEnterpriseObject)replicableTarget), relationshipName);
            replicableTarget.deplicate();
        }
    }

    public static <T> T deepClone(T obj, boolean onlyCollections) {
        Object clone;
        if (obj instanceof NSArray) {
            clone = ERXArrayUtilities.deepClone((NSArray)obj, onlyCollections);
        } else if (obj instanceof NSSet) {
            clone = ERXArrayUtilities.deepClone((NSSet)obj, onlyCollections);
        } else if (obj instanceof NSDictionary) {
            clone = ERXDictionaryUtilities.deepClone((NSDictionary)obj, onlyCollections);
        } else if (!onlyCollections && obj instanceof Cloneable) {
            try {
                Method m = obj.getClass().getMethod("clone", ERXConstant.EmptyClassArray);
                clone = m.invoke(obj, ERXConstant.EmptyObjectArray);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to clone " + obj + ".", e);
            }
        } else {
            clone = obj;
        }
        return (T)clone;
    }

    static {
        DISTANT_FUTURE = new NSTimestamp(2999, 1, 1, 1, 1, 1, TimeZone.getDefault());
        DISTANT_PAST = new NSTimestamp(1000, 1, 1, 1, 1, 1, TimeZone.getDefault());
    }

    public static interface BooleanCallback {
        public boolean invoke(Object var1);
    }

    public static interface Callback {
        public Object invoke(Object var1);
    }

    public static interface Operation {
        public Object value();
    }

    public static interface BooleanOperation {
        public boolean value();
    }
}

