/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.logging;

import er.extensions.foundation.ERXExceptionUtilities;
import er.extensions.foundation.ERXThreadStorage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class ERXConsoleAppender
extends ConsoleAppender {
    private static final String LAST_THROWABLE_KEY = "er.extensions.logging.ERXConsoleAppender.lastThrowable";

    public ERXConsoleAppender() {
    }

    public ERXConsoleAppender(Layout layout) {
        super(layout);
    }

    public ERXConsoleAppender(Layout layout, String target) {
        super(layout, target);
    }

    protected void subAppend(LoggingEvent event) {
        ThrowableInformation throwableInfo;
        this.qw.write(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (throwableInfo = event.getThrowableInformation()) != null) {
            Throwable throwable = throwableInfo.getThrowable();
            Throwable lastThrowable = (Throwable)ERXThreadStorage.valueForKey(LAST_THROWABLE_KEY);
            if (throwable != null && lastThrowable != throwable) {
                StringWriter exceptionStringWriter = new StringWriter();
                ERXExceptionUtilities.printStackTrace(throwable, new PrintWriter((Writer)exceptionStringWriter, true));
                String exceptionStr = exceptionStringWriter.toString();
                if (exceptionStr.length() > 0) {
                    for (String line : exceptionStr.split("[\r\n]+")) {
                        this.qw.write(line);
                        this.qw.write(Layout.LINE_SEP);
                    }
                }
                ERXThreadStorage.takeValueForKey(throwable, LAST_THROWABLE_KEY);
            }
        }
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }
}

