/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.qualifiers;

import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSRange;
import er.extensions.eof.ERXKey;
import er.extensions.qualifiers.ERXAndQualifier;
import er.extensions.qualifiers.ERXKeyComparisonQualifier;
import er.extensions.qualifiers.ERXKeyValueQualifier;
import er.extensions.qualifiers.ERXNotQualifier;
import er.extensions.qualifiers.ERXOrQualifier;
import er.extensions.qualifiers.ERXQualifierTraversal;

public class ERXPrefixQualifierTraversal
extends ERXQualifierTraversal {
    private String _prefix;
    private NSMutableArray<EOQualifier> _qualifiers;

    protected ERXPrefixQualifierTraversal(ERXKey prefix) {
        this._prefix = prefix.key() + ".";
    }

    public static synchronized EOQualifier prefixQualifierWithKey(EOQualifierEvaluation qualifier, ERXKey prefix) {
        ERXPrefixQualifierTraversal prefixTraversal = new ERXPrefixQualifierTraversal(prefix);
        prefixTraversal.traverse(qualifier, true);
        EOQualifier prefixedQualifier = (EOQualifier)prefixTraversal._qualifiers.lastObject();
        return prefixedQualifier;
    }

    protected boolean traverseUnknownQualifier(EOQualifierEvaluation q) {
        throw new UnsupportedOperationException("Unknown qualifier type '" + q.getClass().getName() + "'.");
    }

    protected boolean traverseNotQualifier(EONotQualifier q) {
        ERXNotQualifier nq = new ERXNotQualifier((EOQualifier)this._qualifiers.lastObject());
        this._qualifiers.removeLastObject();
        this._qualifiers.addObject((EOQualifier)nq);
        return true;
    }

    protected boolean traverseOrQualifier(EOOrQualifier q) {
        NSRange range = new NSRange(this._qualifiers.count() - q.qualifiers().count(), q.qualifiers().count());
        ERXOrQualifier oq = new ERXOrQualifier(this._qualifiers.subarrayWithRange(range));
        this._qualifiers.removeObjectsInRange(range);
        this._qualifiers.addObject((EOQualifier)oq);
        return true;
    }

    protected boolean traverseAndQualifier(EOAndQualifier q) {
        NSRange range = new NSRange(this._qualifiers.count() - q.qualifiers().count(), q.qualifiers().count());
        ERXAndQualifier aq = new ERXAndQualifier(this._qualifiers.subarrayWithRange(range));
        this._qualifiers.removeObjectsInRange(range);
        this._qualifiers.addObject((EOQualifier)aq);
        return true;
    }

    protected boolean traverseKeyValueQualifier(EOKeyValueQualifier q) {
        ERXKeyValueQualifier kvq = new ERXKeyValueQualifier(this._prefix + q.key(), q.selector(), q.value());
        this._qualifiers.addObject((EOQualifier)kvq);
        return true;
    }

    protected boolean traverseKeyComparisonQualifier(EOKeyComparisonQualifier q) {
        ERXKeyComparisonQualifier kcq = new ERXKeyComparisonQualifier(this._prefix + q.leftKey(), q.selector(), this._prefix + q.rightKey());
        this._qualifiers.addObject((EOQualifier)kcq);
        return true;
    }

    public synchronized void traverse(EOQualifierEvaluation q, boolean postOrder) {
        if (!postOrder) {
            throw new IllegalArgumentException("ERXPrefixQualifierTraversal requires a postOrder traversal.");
        }
        this._qualifiers = new NSMutableArray();
        super.traverse(q, postOrder);
    }
}

