/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.woextensions;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import er.extensions.components.ERXStatelessComponent;
import java.util.Enumeration;

public class WOSortOrder
extends ERXStatelessComponent {
    private String _key;
    private String _displayKey;
    WODisplayGroup _displayGroup;

    public WOSortOrder(WOContext aContext) {
        super(aContext);
    }

    public void reset() {
        this._invalidateCaches();
    }

    public WODisplayGroup displayGroup() {
        if (null == this._displayGroup) {
            this._displayGroup = (WODisplayGroup)this.valueForBinding("displayGroup");
        }
        return this._displayGroup;
    }

    public String key() {
        if (null == this._key) {
            this._key = (String)this.valueForBinding("key");
        }
        return this._key;
    }

    public String displayKey() {
        if (null == this._displayKey) {
            this._displayKey = (String)this.valueForBinding("displayKey");
        }
        return this._displayKey;
    }

    private EOSortOrdering _primarySortOrdering() {
        NSArray nsarray = this.displayGroup().sortOrderings();
        if (nsarray != null && nsarray.count() > 0) {
            EOSortOrdering eosortordering = (EOSortOrdering)nsarray.objectAtIndex(0);
            return eosortordering;
        }
        return null;
    }

    private boolean _isCurrentKeyPrimary() {
        EOSortOrdering eosortordering = this._primarySortOrdering();
        return eosortordering != null && eosortordering.key().equals(this.key());
    }

    private NSSelector _primaryKeySortOrderingSelector() {
        EOSortOrdering eosortordering = this._primarySortOrdering();
        NSSelector nsselector = null;
        if (eosortordering != null) {
            nsselector = eosortordering.selector();
        }
        return nsselector;
    }

    public String imageName() {
        String s = "Unsorted.gif";
        if (this._isCurrentKeyPrimary()) {
            NSSelector nsselector = this._primaryKeySortOrderingSelector();
            if (nsselector.equals((Object)EOSortOrdering.CompareAscending) || nsselector.equals((Object)EOSortOrdering.CompareCaseInsensitiveAscending)) {
                s = "Ascending.gif";
            } else if (nsselector.equals((Object)EOSortOrdering.CompareDescending) || nsselector.equals((Object)EOSortOrdering.CompareCaseInsensitiveDescending)) {
                s = "Descending.gif";
            }
        }
        return s;
    }

    private void _removeSortOrderingWithKey(String s) {
        int i = 0;
        WODisplayGroup wodisplaygroup = this.displayGroup();
        NSArray nsarray = wodisplaygroup.sortOrderings();
        if (nsarray != null) {
            NSMutableArray nsmutablearray = new NSMutableArray(nsarray);
            Enumeration enumeration = nsmutablearray.objectEnumerator();
            while (enumeration.hasMoreElements()) {
                EOSortOrdering eosortordering = (EOSortOrdering)enumeration.nextElement();
                if (s.equals(eosortordering.key())) {
                    nsmutablearray.removeObjectAtIndex(i);
                    break;
                }
                ++i;
            }
            wodisplaygroup.setSortOrderings(nsmutablearray);
        }
    }

    private void _makePrimarySortOrderingWithSelector(NSSelector nsselector) {
        String s = this.key();
        WODisplayGroup wodisplaygroup = this.displayGroup();
        NSArray nsarray = wodisplaygroup.sortOrderings();
        NSMutableArray<Object> nsmutablearray = nsarray != null ? new NSMutableArray(nsarray) : new NSMutableArray<EOSortOrdering>();
        EOSortOrdering eosortordering = EOSortOrdering.sortOrderingWithKey((String)s, (NSSelector)nsselector);
        nsmutablearray.insertObjectAtIndex(eosortordering, 0);
        if (nsmutablearray.count() > 3) {
            nsmutablearray.removeLastObject();
        }
        wodisplaygroup.setSortOrderings(nsmutablearray);
    }

    public String helpString() {
        return "Push to toggle sorting order according to " + this.displayKey();
    }

    public WOComponent toggleClicked() {
        NSSelector desc;
        String s = this.key();
        boolean caseInsensitive = this.caseInsensitive();
        NSSelector asc = caseInsensitive ? EOSortOrdering.CompareCaseInsensitiveAscending : EOSortOrdering.CompareAscending;
        NSSelector nSSelector = desc = caseInsensitive ? EOSortOrdering.CompareCaseInsensitiveDescending : EOSortOrdering.CompareDescending;
        if (this._isCurrentKeyPrimary()) {
            NSSelector nsselector = this._primaryKeySortOrderingSelector();
            if (nsselector.equals((Object)EOSortOrdering.CompareAscending) || nsselector.equals((Object)EOSortOrdering.CompareCaseInsensitiveAscending)) {
                this._removeSortOrderingWithKey(s);
                this._makePrimarySortOrderingWithSelector(desc);
            } else if (nsselector.equals((Object)EOSortOrdering.CompareDescending) || nsselector.equals((Object)EOSortOrdering.CompareCaseInsensitiveDescending)) {
                this._removeSortOrderingWithKey(s);
                this._makePrimarySortOrderingWithSelector(asc);
            } else {
                this._removeSortOrderingWithKey(s);
                this._makePrimarySortOrderingWithSelector(asc);
            }
        } else {
            this._removeSortOrderingWithKey(s);
            this._makePrimarySortOrderingWithSelector(asc);
        }
        this.displayGroup().updateDisplayedObjects();
        return null;
    }

    public boolean caseInsensitive() {
        return this.booleanValueForBinding("caseInsensitive");
    }

    private void _invalidateCaches() {
        this._key = null;
        this._displayKey = null;
        this._displayGroup = null;
    }
}

