/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.directtoweb;

import com.webobjects.appserver.WOComponent;
import com.webobjects.directtoweb.Assignment;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.directtoweb.D2WPage;
import com.webobjects.directtoweb.EditPageInterface;
import com.webobjects.directtoweb.ListPageInterface;
import com.webobjects.directtoweb.NextPageDelegate;
import com.webobjects.directtoweb.QueryPageInterface;
import com.webobjects.directtoweb.SelectPageInterface;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import er.directtoweb.interfaces.ERDPickPageInterface;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERD2WUtilities {
    private static Logger log = Logger.getLogger(ERD2WUtilities.class);

    public static void finalizeContext(D2WContext context) {
        if (context != null) {
            context.pageFinalized();
        }
    }

    public static void resetContextCache(D2WContext context) {
        if (context != null) {
            context._localValues.clear();
        }
    }

    public static boolean assignmentsAreEqual(Assignment a1, Assignment a2) {
        boolean areEqual = false;
        if (a1.getClass().equals(a2.getClass()) && a1.keyPath() != null && a2.keyPath() != null && a1.value() != null && a2.value() != null) {
            areEqual = a1.keyPath().equals(a2.keyPath()) && a1.value().equals(a2.value());
        }
        return areEqual;
    }

    public static Object contextValueForKeyNoInferenceNoException(D2WContext c, String keyPath) {
        Object result = null;
        int i = keyPath.indexOf(".");
        if (i == -1) {
            result = c.valueForKeyNoInference(keyPath);
        } else {
            String first = keyPath.substring(0, i);
            String second = keyPath.substring(i + 1);
            result = c.valueForKeyNoInference(first);
            if (result != null) {
                try {
                    if (second.indexOf(".") == -1) {
                        result = NSKeyValueCoding.Utility.valueForKey((Object)result, (String)second);
                    } else {
                        String part;
                        NSArray parts = NSArray.componentsSeparatedByString((String)second, (String)".");
                        for (int j = 0; j < parts.count() && (result = NSKeyValueCoding.Utility.valueForKey((Object)result, (String)(part = (String)parts.objectAtIndex(j)))) != null; ++j) {
                        }
                    }
                }
                catch (NSKeyValueCoding.UnknownKeyException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("keyPath " + keyPath + " is not available for context with entity: " + c.entity().name() + "; task: " + c.task()));
                    }
                    return null;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WOComponent nextPageInPage(D2WPage parent) {
        WOComponent result = parent.context().page();
        WOComponent old = parent.context().component();
        try {
            parent.context()._setCurrentComponent((WOComponent)parent);
            if (parent.nextPageDelegate() != null) {
                NextPageDelegate delegate = parent.nextPageDelegate();
                result = delegate.nextPage((WOComponent)parent);
            } else {
                result = parent.nextPage();
            }
        }
        finally {
            parent.context()._setCurrentComponent(old);
        }
        return result;
    }

    public static WOComponent enclosingPageOfClass(WOComponent sender, Class c) {
        for (WOComponent p = sender.parent(); p != null; p = p.parent()) {
            if (!c.isAssignableFrom(p.getClass())) continue;
            return p;
        }
        return null;
    }

    public static <T> T enclosingComponentOfClass(WOComponent sender, Class<T> c) {
        for (WOComponent p = sender; p != null; p = p.parent()) {
            if (!c.isAssignableFrom(p.getClass())) continue;
            return (T)p;
        }
        return null;
    }

    public static D2WPage topLevelD2WPage(WOComponent sender) {
        WOComponent last = null;
        for (WOComponent p = sender.parent(); p != null; p = p.parent()) {
            if (!(p instanceof D2WPage)) continue;
            last = p;
        }
        return (D2WPage)last;
    }

    public static ListPageInterface parentListPage(WOComponent sender) {
        return (ListPageInterface)ERD2WUtilities.enclosingPageOfClass(sender, ListPageInterface.class);
    }

    public static EditPageInterface parentEditPage(WOComponent sender) {
        return (EditPageInterface)ERD2WUtilities.enclosingPageOfClass(sender, EditPageInterface.class);
    }

    public static SelectPageInterface parentSelectPage(WOComponent sender) {
        return (SelectPageInterface)ERD2WUtilities.enclosingPageOfClass(sender, SelectPageInterface.class);
    }

    public static QueryPageInterface parentQueryPage(WOComponent sender) {
        return (QueryPageInterface)ERD2WUtilities.enclosingPageOfClass(sender, QueryPageInterface.class);
    }

    public static ERDPickPageInterface parentPickPage(WOComponent sender) {
        return (ERDPickPageInterface)ERD2WUtilities.enclosingPageOfClass(sender, ERDPickPageInterface.class);
    }

    public D2WPage parentD2WPage(WOComponent sender) {
        return (D2WPage)ERD2WUtilities.enclosingPageOfClass(sender, D2WPage.class);
    }
}

