/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb;

import com.webobjects.directtoweb.Assignment;
import com.webobjects.directtoweb.BooleanAssignment;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.directtoweb.ERD2WContext;
import com.webobjects.directtoweb.Rule;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import er.extensions.foundation.ERXDictionaryUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERD2WContextDictionary {
    private static final Logger log = Logger.getLogger(ERD2WContextDictionary.class);
    protected D2WContext _context;
    protected String _pageConfiguration;
    protected NSMutableArray _pageLevelKeys;
    protected NSMutableArray _componentLevelKeys;
    protected NSMutableDictionary _dictionary;
    protected NSMutableDictionary _allKeys;

    public ERD2WContextDictionary(String pageConfigurationName, NSArray pageKeys, NSArray componentKeys) {
        this._pageConfiguration = pageConfigurationName;
        this._context = ERD2WContext.newContext();
        this._context.setDynamicPage(this._pageConfiguration);
        this._context.setTask(this._context.task());
        this._context.setEntity(this._context.entity());
        this._pageLevelKeys = pageKeys == null ? new NSMutableArray(new Object[]{"pageWrapperName", "displayPropertyKeys", "pageName"}) : pageKeys.mutableClone();
        NSMutableArray keys = new NSMutableArray(new Object[]{"componentName", "customComponentName", "displayNameForProperty", "propertyKey"});
        this._componentLevelKeys = new NSMutableArray();
        if (componentKeys != null) {
            this._componentLevelKeys = componentKeys.mutableClone();
        }
        Enumeration e = keys.objectEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this._componentLevelKeys.containsObject((Object)key)) continue;
            this._componentLevelKeys.addObject((Object)key);
        }
        if ("edit".equals(this._context.task())) {
            this._componentLevelKeys.addObject((Object)"isMandatory");
        }
        if ("list".equals(this._context.task())) {
            this._componentLevelKeys.addObject((Object)"propertyIsSortable");
            this._componentLevelKeys.addObject((Object)"sortKeyForList");
        }
        this._allKeys = new NSMutableDictionary();
        Configuration config = new Configuration();
        this._allKeys.setObjectForKey((Object)config.components(), (Object)"components");
        this._allKeys.setObjectForKey((Object)config.editors(), (Object)"editors");
    }

    public ERD2WContextDictionary(String pageConfiguration, NSDictionary dictionary) {
        this._pageConfiguration = pageConfiguration;
        this._dictionary = dictionary.mutableClone();
    }

    protected void addPageLevelValues() {
        Object o;
        String key;
        Enumeration e;
        Enumeration e2 = this._pageLevelKeys.objectEnumerator();
        while (e2.hasMoreElements()) {
            String key2 = (String)e2.nextElement();
            Object o2 = this._context.valueForKey(key2);
            if (o2 == null) continue;
            this._dictionary.takeValueForKey(o2, key2);
        }
        String path = "components." + this._context.valueForKey("pageName") + ".editors";
        NSArray keys = (NSArray)this._allKeys.valueForKeyPath(path);
        if (keys != null) {
            e = keys.objectEnumerator();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                o = this._context.valueForKey(key);
                if (o == null) continue;
                this._dictionary.takeValueForKeyPath(o, key);
            }
        }
        if ((keys = (NSArray)this._allKeys.valueForKeyPath(path = "components." + this._context.valueForKey("pageName") + ".supports")) != null) {
            e = keys.objectEnumerator();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                o = this._context.valueForKey(key);
                if (o == null) continue;
                this._dictionary.takeValueForKeyPath(o, key);
            }
        }
    }

    protected NSDictionary componentLevelValuesForKey(String propertyKey) {
        Object o;
        String key;
        Enumeration e;
        this._context.setPropertyKey(propertyKey);
        NSMutableDictionary dictionary = new NSMutableDictionary();
        Enumeration e2 = this._componentLevelKeys.objectEnumerator();
        while (e2.hasMoreElements()) {
            String key2 = (String)e2.nextElement();
            Object o2 = this._context.valueForKey(key2);
            if (o2 == null) continue;
            dictionary.setObjectForKey(o2, (Object)key2);
        }
        String path = "components." + dictionary.objectForKey((Object)"componentName") + ".editors";
        NSArray keys = (NSArray)this._allKeys.valueForKeyPath(path);
        if (keys != null) {
            e = keys.objectEnumerator();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                o = this._context.valueForKey(key);
                if (o == null) continue;
                dictionary.setObjectForKey(o, (Object)key);
            }
        }
        if ((keys = (NSArray)this._allKeys.valueForKeyPath(path = "components." + dictionary.objectForKey((Object)"componentName") + ".supports")) != null) {
            e = keys.objectEnumerator();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                o = this._context.valueForKey(key);
                if (o == null) continue;
                dictionary.setObjectForKey(o, (Object)key);
            }
        }
        this._context.setPropertyKey(null);
        return dictionary;
    }

    public NSDictionary dictionary() {
        if (this._dictionary == null) {
            this._dictionary = new NSMutableDictionary();
            this.addPageLevelValues();
            NSArray displayPropertyKeys = (NSArray)this._context.valueForKey("displayPropertyKeys");
            if (displayPropertyKeys != null && displayPropertyKeys.count() > 0) {
                NSMutableDictionary componentLevelKeys = new NSMutableDictionary();
                this.addPropertyKeys(componentLevelKeys, displayPropertyKeys);
                this._dictionary.setObjectForKey((Object)componentLevelKeys, (Object)"componentLevelKeys");
            }
        }
        return this._dictionary;
    }

    protected void addPropertyKeys(NSMutableDictionary componentLevelKeys, NSArray array) {
        Enumeration e = array.objectEnumerator();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof NSArray) {
                this.addPropertyKeys(componentLevelKeys, (NSArray)o);
                continue;
            }
            String key = (String)o;
            componentLevelKeys.setObjectForKey((Object)this.componentLevelValuesForKey(key), (Object)key);
        }
    }

    public NSArray rulesForLevel(int level) {
        NSMutableArray arr = new NSMutableArray();
        Enumeration e = this.dictionary().keyEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if ("componentLevelKeys".equals(key)) continue;
            Object value = this.dictionary().valueForKey(key);
            EOQualifier q = EOQualifier.qualifierWithQualifierFormat((String)("pageConfiguration = '" + this._pageConfiguration + "'"), null);
            Assignment a = this.createAssigment(key, value);
            arr.addObject((Object)new Rule(level, q, a));
        }
        NSArray keys = (NSArray)this._dictionary.valueForKey("displayPropertyKeys");
        if (keys != null && keys.count() > 0) {
            this.addRulesForPropertyKeys(level, arr, keys);
        }
        return arr;
    }

    private Assignment createAssigment(String key, Object value) {
        Object a = "true".equals(value) || "false".equals(value) ? new BooleanAssignment(key, value) : new Assignment(key, value);
        return a;
    }

    protected void addRulesForPropertyKeys(int level, NSMutableArray rules, NSArray keys) {
        Enumeration e = keys.objectEnumerator();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof NSArray) {
                this.addRulesForPropertyKeys(level, rules, keys);
                continue;
            }
            String propertyKey = (String)o;
            NSDictionary values = (NSDictionary)this.dictionary().valueForKeyPath("componentLevelKeys." + propertyKey);
            EOQualifier q = EOQualifier.qualifierWithQualifierFormat((String)("pageConfiguration = '" + this._pageConfiguration + "' and propertyKey = '" + propertyKey + "'"), null);
            Enumeration e1 = values.keyEnumerator();
            while (e1.hasMoreElements()) {
                String key = (String)e1.nextElement();
                Object value = values.objectForKey((Object)key);
                Assignment a = this.createAssigment(key, value);
                rules.addObject((Object)new Rule(level, q, a));
            }
        }
    }

    public D2WContext context() {
        return this._context;
    }

    public String dictionaryString() {
        return NSPropertyListSerialization.stringFromPropertyList((Object)this.dictionary());
    }

    public String toString() {
        return this.context() + ": " + this.dictionaryString();
    }

    public static class Configuration {
        private NSMutableDictionary components = new NSMutableDictionary();
        private NSMutableDictionary editors = new NSMutableDictionary();

        public Configuration() {
            NSMutableArray bundles = NSBundle.frameworkBundles().mutableClone();
            bundles.addObject((Object)NSBundle.mainBundle());
            Enumeration e = bundles.objectEnumerator();
            while (e.hasMoreElements()) {
                NSDictionary dict;
                NSBundle bundle = (NSBundle)e.nextElement();
                String path = bundle.resourcePathForLocalizedResourceNamed("d2wclientConfiguration.plist", null);
                if (path == null || (dict = ERXDictionaryUtilities.dictionaryFromPropertyList((String)"d2wclientConfiguration", (NSBundle)bundle)) == null) continue;
                if (dict.objectForKey((Object)"components") != null) {
                    this.components.addEntriesFromDictionary((NSDictionary)dict.objectForKey((Object)"components"));
                }
                if (dict.objectForKey((Object)"editors") == null) continue;
                this.editors.addEntriesFromDictionary((NSDictionary)dict.objectForKey((Object)"editors"));
            }
        }

        public NSMutableDictionary components() {
            return this.components;
        }

        public NSMutableDictionary editors() {
            return this.editors;
        }
    }
}

