/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb;

import com.webobjects.appserver.WOApplication;
import com.webobjects.directtoweb.Assignment;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.directtoweb.D2WFastModel;
import com.webobjects.directtoweb.D2WModel;
import com.webobjects.directtoweb.DefaultAssignment;
import com.webobjects.directtoweb.ERD2WUtilities;
import com.webobjects.directtoweb.Rule;
import com.webobjects.directtoweb.Services;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSet;
import er.directtoweb.ERD2WRule;
import er.directtoweb.assignments.ERDComputingAssignmentInterface;
import er.directtoweb.assignments.ERDLocalizableAssignmentInterface;
import er.directtoweb.assignments.delayed.ERDDelayedAssignment;
import er.directtoweb.qualifiers.ERDQualifierTraversal;
import er.directtoweb.qualifiers.ERDQualifierTraversalCallback;
import er.extensions.ERXExtensions;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXMappingObjectStream;
import er.extensions.foundation.ERXMultiKey;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSelectorUtilities;
import er.extensions.localization.ERXLocalizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERD2WModel
extends D2WModel {
    public static final Logger log = Logger.getLogger(ERD2WModel.class);
    public static final Logger ruleDecodeLog = Logger.getLogger((String)"er.directtoweb.rules.decode");
    public static final Logger ruleTraceEnabledLog = Logger.getLogger((String)"er.directtoweb.rules.ERD2WTraceRuleFiringEnabled");
    public static final String WillSortRules = "WillSortRules";
    public static final String ModelWillReset = "ModelWillReset";
    private static final Object NULL_VALUE = "<NULL>";
    private Hashtable _cache = new Hashtable(10000);
    private Hashtable _systemCache = new Hashtable(10000);
    private Hashtable _significantKeysPerKey = new Hashtable(500);
    private static D2WModel _defaultModel;
    static NSMutableArray BACKSTOP_KEYS;
    private static final EOSortOrdering _prioritySortOrdering;
    private static final EOSortOrdering _descriptionSortOrdering;
    protected Hashtable _filePathRuleTraceCache;
    private static final NSSet _addKeyToVectorDefaultKeysToTakeLiterally;
    protected File _currentFile;
    protected Hashtable _uniqueAssignments = new Hashtable();
    protected int uniquedQualifiers = 0;
    protected int totalQualifiers = 0;
    private boolean _hasAddedExtraModelFiles = false;
    protected Hashtable _uniqueAndQualifiers = new Hashtable();
    protected Hashtable _uniqueOrQualifiers = new Hashtable();
    protected Hashtable _uniqueNotQualifiers = new Hashtable();
    protected Hashtable _uniqueKeyValueQualifiers = new Hashtable();
    protected static final String ENTITY_PREFIX = "::ENTITY::";
    protected static final String RELATIONSHIP_PREFIX = "::RELATIONSHIP::";
    protected static final String ATTRIBUTE_PREFIX = "::ATTRIBUTE::";

    public static ERD2WModel erDefaultModel() {
        if (!(D2WModel.defaultModel() instanceof ERD2WModel)) {
            D2WModel.setDefaultModel((D2WModel)_defaultModel);
            log.warn((Object)"erDefaultModel had wrong class, fixing to ERD2WModel");
        }
        return (ERD2WModel)D2WModel.defaultModel();
    }

    private static NSArray ruleSortOrderingKeyArray() {
        NSMutableArray result = new NSMutableArray();
        result.addObject((Object)_prioritySortOrdering);
        result.addObject((Object)_descriptionSortOrdering);
        return result;
    }

    protected ERD2WModel(NSArray rules) {
        super(rules);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, ERXSelectorUtilities.notificationSelector((String)"applicationDidFinishLaunching"), "ApplicationDidFinishLaunchingNotification", null);
    }

    protected ERD2WModel(File file) {
        super(file);
    }

    public ERD2WModel(URL url) {
        super(url);
    }

    protected ERD2WModel(EOKeyValueUnarchiver unarchiver) {
        super(unarchiver);
    }

    public void clearD2WRuleCache() {
        this.invalidateCaches();
        this.sortRules();
    }

    public NSArray availableTasks() {
        return new NSArray(this.taskVector().toArray());
    }

    public NSArray availablePageConfigurations() {
        return new NSArray(this.dynamicPages().toArray());
    }

    protected void sortRules() {
        if (D2WModel.defaultModel() == this) {
            log.debug((Object)"posting WillSortRules.");
            NSNotificationCenter.defaultCenter().postNotification(WillSortRules, (Object)this);
            log.debug((Object)"posted WillSortRules.");
        }
        this.setDirty(false);
        super.sortRules();
        log.debug((Object)"called super sortRules.");
        if (this.rules() != null && this.rules().count() > 0) {
            this.prepareDataStructures();
        }
    }

    public void applicationWillDispatchRequest(NSNotification n) {
        this.checkRules();
    }

    public void applicationDidFinishLaunching(NSNotification n) {
        if (!WOApplication.application().isCachingEnabled()) {
            NSNotificationCenter.defaultCenter().addObserver((Object)this, ERXSelectorUtilities.notificationSelector((String)"applicationWillDispatchRequest"), "ApplicationWillDispatchRequestNotification", null);
            NSNotificationCenter.defaultCenter().addObserver((Object)this, ERXSelectorUtilities.notificationSelector((String)"clearD2WRuleCache"), "clearD2WRuleCache", null);
        }
    }

    public void clearD2WRuleCache(NSNotification n) {
        this.clearD2WRuleCache();
    }

    public NSArray rules() {
        return super.rules();
    }

    public void addRule(Rule rule) {
        super.addRule(rule);
    }

    public void removeRule(Rule rule) {
        super.removeRule(rule);
    }

    protected String descriptionForRuleSet(NSArray set) {
        StringBuffer buffer = new StringBuffer();
        Enumeration e = set.objectEnumerator();
        while (e.hasMoreElements()) {
            buffer.append("\t" + this.descriptionForRule((Rule)e.nextElement()) + "\n");
        }
        return buffer.toString();
    }

    protected String descriptionForRule(Rule r) {
        String suffix = null;
        if (this._filePathRuleTraceCache != null && (suffix = (String)this._filePathRuleTraceCache.get(r)) == null) {
            suffix = "Dynamic";
        }
        return r.toString() + (suffix != null ? " From: " + suffix : "");
    }

    public void addRules(NSArray rules) {
        super.addRules(rules);
        if (!WOApplication.application().isCachingEnabled() && this.currentFile() != null) {
            String filePath;
            String path = this.currentFile().getAbsolutePath();
            NSArray components = NSArray.componentsSeparatedByString((String)path, (String)"/");
            int count = components.count();
            String string = filePath = count > 2 ? (String)components.objectAtIndex(count - 3) + "/" + (String)components.objectAtIndex(count - 2) : path;
            if (this._filePathRuleTraceCache == null) {
                this._filePathRuleTraceCache = new Hashtable();
            }
            Enumeration e = rules.objectEnumerator();
            while (e.hasMoreElements()) {
                this._filePathRuleTraceCache.put(e.nextElement(), filePath);
            }
        }
    }

    protected Object fireSystemRuleForKeyPathInContext(String keyPath, D2WContext context) {
        return this.fireRuleForKeyPathInContext(this._systemCache, keyPath, context);
    }

    protected Object fireRuleForKeyPathInContext(String keyPath, D2WContext context) {
        return this.fireRuleForKeyPathInContext(this._cache, keyPath, context);
    }

    protected boolean _shouldUseCacheForFiringRuleForKeyPathInContext(String keyPath, D2WContext context) {
        return true;
    }

    private Object fireRuleForKeyPathInContext(Map cache, String keyPath, D2WContext context) {
        Object result;
        Object[] significantKeys;
        boolean useCache = this._shouldUseCacheForFiringRuleForKeyPathInContext(keyPath, context);
        if (!useCache && ruleTraceEnabledLog.isDebugEnabled()) {
            ruleTraceEnabledLog.debug((Object)("CACHE DISABLED for keyPath: " + keyPath));
        }
        if ((significantKeys = (String[])this._significantKeysPerKey.get(keyPath)) == null) {
            return null;
        }
        short s = (short)significantKeys.length;
        Object[] lhsKeys = new Object[(short)(s + 1)];
        for (short i = 0; i < s; i = (short)(i + 1)) {
            lhsKeys[i] = ERD2WUtilities.contextValueForKeyNoInferenceNoException(context, significantKeys[i]);
        }
        lhsKeys[s] = keyPath;
        ERXMultiKey k = new ERXMultiKey(lhsKeys);
        Object object = result = useCache ? (Object)cache.get(k) : null;
        if (result == null) {
            boolean resetTraceRuleFiring = false;
            Logger ruleFireLog = null;
            if (ruleTraceEnabledLog.isDebugEnabled()) {
                Logger ruleCandidatesLog = Logger.getLogger((String)("er.directtoweb.rules." + keyPath + ".candidates"));
                ruleFireLog = Logger.getLogger((String)("er.directtoweb.rules." + keyPath + ".fire"));
                if (ruleFireLog.isDebugEnabled() && !NSLog.debugLoggingAllowedForGroups((long)0x200000L)) {
                    NSLog.allowDebugLoggingForGroups((long)0x200000L);
                    resetTraceRuleFiring = true;
                }
                if (ruleCandidatesLog.isDebugEnabled()) {
                    ruleFireLog.debug((Object)("CANDIDATES for keyPath: " + keyPath + "\n" + this.descriptionForRuleSet(this.canidateRuleSetForRHSInContext(keyPath, context))));
                }
            }
            try {
                result = cache == this._systemCache ? super.fireSystemRuleForKeyPathInContext(keyPath, context) : super.fireRuleForKeyPathInContext(keyPath, context);
            }
            catch (StackOverflowError ex) {
                log.error((Object)("Problem with this key: " + keyPath + " depends: " + new NSArray(significantKeys) + " values: " + k + " context: " + context + " values: " + context._localValues() + " map: " + cache));
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
            }
            if (useCache) {
                cache.put(k, result == null ? NULL_VALUE : result);
            }
            if (ruleTraceEnabledLog.isDebugEnabled() && ruleFireLog.isDebugEnabled()) {
                ruleFireLog.debug((Object)("FIRE: " + keyPath + " for propertyKey: " + context.propertyKey() + " depends on: " + new NSArray(significantKeys) + " = " + k + " value: " + (result == null ? "<NULL>" : (result instanceof EOEntity ? ((EOEntity)result).name() : result))));
            }
            if (resetTraceRuleFiring) {
                NSLog.refuseDebugLoggingForGroups((long)0x200000L);
            }
        } else {
            Logger ruleLog;
            if (ruleTraceEnabledLog.isDebugEnabled() && (ruleLog = Logger.getLogger((String)("er.directtoweb.rules." + keyPath + ".cache"))).isDebugEnabled()) {
                ruleLog.debug((Object)("CACHE: " + keyPath + " for propertyKey: " + context.propertyKey() + " depends on: " + new NSArray(significantKeys) + " = " + k + " value: " + (result == NULL_VALUE ? "<NULL>" : (result instanceof EOEntity ? ((EOEntity)result).name() : result))));
            }
            if (result == NULL_VALUE) {
                result = null;
            }
        }
        if (result != null && result instanceof ERDDelayedAssignment) {
            result = ((ERDDelayedAssignment)((Object)result)).fireNow(context);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCache(String fileName) {
        fileName = fileName == null ? "dmp.cache" : fileName;
        ERD2WModel eRD2WModel = this;
        synchronized (eRD2WModel) {
            try {
                ERXFileUtilities.writeInputStreamToFile((InputStream)new ByteArrayInputStream(this.cacheToBytes(this._cache)), (File)new File(fileName));
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreCache(String fileName) {
        fileName = fileName == null ? "dmp.cache" : fileName;
        ERD2WModel eRD2WModel = this;
        synchronized (eRD2WModel) {
            try {
                this._cache = this.cacheFromBytes(ERXFileUtilities.bytesFromFile((File)new File(fileName)));
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
        }
    }

    public NSArray canidateRuleSetForRHSInContext(String rhs, D2WContext context) {
        NSMutableSet canidateSet = new NSMutableSet();
        Enumeration e = this.rules().objectEnumerator();
        while (e.hasMoreElements()) {
            Rule r = (Rule)e.nextElement();
            if (!r.rhsKeyPath().equals(rhs) || !r.canFireInContext(context)) continue;
            canidateSet.addObject((Object)r);
        }
        return canidateSet.count() == 0 ? canidateSet.allObjects() : EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)canidateSet.allObjects(), (NSArray)ERD2WModel.ruleSortOrderingKeyArray());
    }

    protected NSSet _addKeyToVectorKeysToTakeLiterally() {
        return _addKeyToVectorDefaultKeysToTakeLiterally;
    }

    protected void _addKeyToVector(String key, Vector vector) {
        if (key.indexOf(".") != -1) {
            NSArray a = NSArray.componentsSeparatedByString((String)key, (String)".");
            String firstAtom = (String)a.objectAtIndex(0);
            if (!this._addKeyToVectorKeysToTakeLiterally().containsObject((Object)firstAtom)) {
                key = firstAtom;
            }
        }
        if (!vector.contains(key)) {
            vector.addElement(key);
        }
    }

    public void prepareDataStructures() {
        Vector keys;
        String k;
        log.debug((Object)"prepareDataStructures");
        boolean localizationEnabled = ERXLocalizer.isLocalizationEnabled();
        Hashtable<String, Object> dependendKeysPerKey = new Hashtable<String, Object>();
        Hashtable delayedDependendKeysPerKey = new Hashtable();
        _LhsKeysCallback c = new _LhsKeysCallback();
        Vector<String> v = new Vector<String>();
        v.addElement("propertyKey");
        dependendKeysPerKey.put("propertyIsKeyPath", v.clone());
        v.addElement("entity");
        dependendKeysPerKey.put("relationship", v.clone());
        dependendKeysPerKey.put("attribute", v.clone());
        dependendKeysPerKey.put("propertyType", v.clone());
        dependendKeysPerKey.put("propertyKeyPortionInModel", v.clone());
        Enumeration e = this.rules().objectEnumerator();
        while (e.hasMoreElements()) {
            Rule r = (Rule)e.nextElement();
            String rhsKey = r.rhs().keyPath();
            Vector dependendantKeys = (Vector)dependendKeysPerKey.get(rhsKey);
            if (dependendantKeys == null) {
                dependendantKeys = new Vector();
                dependendKeysPerKey.put(rhsKey, dependendantKeys);
            }
            ERDQualifierTraversal.traverseQualifier((EOQualifierEvaluation)r.lhs(), c);
            Enumeration e2 = c.keys.objectEnumerator();
            while (e2.hasMoreElements()) {
                k = (String)e2.nextElement();
                this._addKeyToVector(k, dependendantKeys);
            }
            if (r.rhs() instanceof ERDComputingAssignmentInterface) {
                NSArray extraKeys;
                Vector recipientForNewKeys = dependendantKeys;
                if (r.rhs() instanceof ERDDelayedAssignment && (recipientForNewKeys = (Vector)delayedDependendKeysPerKey.get(rhsKey)) == null) {
                    recipientForNewKeys = new Vector();
                    delayedDependendKeysPerKey.put(rhsKey, recipientForNewKeys);
                }
                if ((extraKeys = ((ERDComputingAssignmentInterface)r.rhs()).dependentKeys(rhsKey)) != null) {
                    Enumeration e6 = extraKeys.objectEnumerator();
                    while (e6.hasMoreElements()) {
                        String k2 = (String)e6.nextElement();
                        this._addKeyToVector(k2, recipientForNewKeys);
                    }
                }
            } else if (r.rhs() instanceof DefaultAssignment) {
                this._addKeyToVector("task", dependendantKeys);
                this._addKeyToVector("entity", dependendantKeys);
                this._addKeyToVector("propertyKey", dependendantKeys);
            }
            if (localizationEnabled && r.rhs() instanceof ERDLocalizableAssignmentInterface) {
                this._addKeyToVector("session.language", dependendantKeys);
            }
            c.keys = new NSMutableArray();
        }
        log.debug((Object)"reducing graph");
        boolean touched = true;
        while (touched) {
            touched = false;
            Enumeration e3 = dependendKeysPerKey.keys();
            while (e3.hasMoreElements()) {
                String rk = (String)e3.nextElement();
                keys = (Vector)dependendKeysPerKey.get(rk);
                Enumeration e4 = keys.elements();
                while (e4.hasMoreElements()) {
                    String s;
                    Enumeration e5;
                    k = (String)e4.nextElement();
                    if (BACKSTOP_KEYS.containsObject((Object)k)) continue;
                    Vector newKeys = (Vector)dependendKeysPerKey.get(k);
                    Vector keyFromDelayedAssignment = (Vector)delayedDependendKeysPerKey.get(k);
                    if (newKeys == null && keyFromDelayedAssignment == null) continue;
                    keys.removeElement(k);
                    touched = true;
                    if (newKeys != null) {
                        e5 = newKeys.elements();
                        while (e5.hasMoreElements()) {
                            s = (String)e5.nextElement();
                            this._addKeyToVector(s, keys);
                        }
                    }
                    if (keyFromDelayedAssignment == null) continue;
                    e5 = keyFromDelayedAssignment.elements();
                    while (e5.hasMoreElements()) {
                        s = (String)e5.nextElement();
                        this._addKeyToVector(s, keys);
                    }
                }
            }
        }
        Enumeration e7 = dependendKeysPerKey.keys();
        while (e7.hasMoreElements()) {
            String key = (String)e7.nextElement();
            keys = (Vector)dependendKeysPerKey.get(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rhs key " + key + " <-- " + keys));
            }
            String[] a = new String[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                a[i] = (String)keys.elementAt(i);
            }
            if (this._significantKeysPerKey == null) continue;
            this._significantKeysPerKey.put(key, a);
        }
    }

    protected void invalidateCaches() {
        log.debug((Object)"Invalidating cache");
        if (this._cache != null) {
            this._cache.clear();
        }
        if (this._systemCache != null) {
            this._systemCache.clear();
        }
        if (this._significantKeysPerKey != null) {
            this._significantKeysPerKey.clear();
        }
        super.invalidateCaches();
    }

    public void resetModel() {
        log.info((Object)"Resetting Model");
        if (this._filePathRuleTraceCache != null) {
            this._filePathRuleTraceCache.clear();
        }
        NSNotificationCenter.defaultCenter().postNotification(ModelWillReset, (Object)this);
        this.setRules(new NSArray());
        this.initializeClientConfiguration();
        this.loadRules();
    }

    protected void setCurrentFile(File currentFile) {
        this._currentFile = currentFile;
    }

    protected File currentFile() {
        return this._currentFile;
    }

    protected static NSDictionary dictionaryFromPathUrl(URL url) {
        NSDictionary model = null;
        try {
            log.debug((Object)("Loading url: " + url));
            if (url != null) {
                model = Services.dictionaryFromPathURL((URL)url);
                NSArray rules = (NSArray)model.objectForKey((Object)"rules");
                Enumeration e = rules.objectEnumerator();
                boolean patchRules = ERXProperties.booleanForKeyWithDefault((String)"er.directtoweb.ERXD2WModel.patchRules", (boolean)true);
                while (e.hasMoreElements()) {
                    NSMutableDictionary dict = (NSMutableDictionary)e.nextElement();
                    if (!patchRules || !Rule.class.getName().equals(dict.objectForKey((Object)"class"))) continue;
                    dict.setObjectForKey((Object)ERD2WRule.class.getName(), (Object)"class");
                }
            }
        }
        catch (Throwable throwable) {
            NSLog.err.appendln((Object)("****** DirectToWeb: Problem reading file " + url + " reason:" + throwable));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)40L)) {
                NSLog.err.appendln((Object)"STACKTRACE:");
                NSLog.err.appendln(throwable);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)throwable);
        }
        return model;
    }

    protected void mergePathURL(URL modelURL) {
        if (modelURL != null) {
            File modelFile = new File(modelURL.getFile());
            log.debug((Object)("Merging rule file \"" + modelFile.getPath() + "\""));
            this.setCurrentFile(modelFile);
            NSDictionary dic = ERD2WModel.dictionaryFromPathUrl(modelURL);
            if (dic != null) {
                if (ruleDecodeLog.isDebugEnabled()) {
                    ruleDecodeLog.debug((Object)("Got dictionary for file: " + modelFile + "\n\n"));
                    Enumeration e = ((NSArray)dic.objectForKey((Object)"rules")).objectEnumerator();
                    while (e.hasMoreElements()) {
                        NSDictionary aRule = (NSDictionary)e.nextElement();
                        NSMutableDictionary aRuleDictionary = new NSMutableDictionary((Object)aRule, (Object)"rule");
                        EOKeyValueUnarchiver archiver = new EOKeyValueUnarchiver((NSDictionary)aRuleDictionary);
                        try {
                            this.addRule((Rule)archiver.decodeObjectForKey("rule"));
                        }
                        catch (Exception ex) {
                            ruleDecodeLog.error((Object)("Bad rule: " + aRule), (Throwable)ex);
                            ruleDecodeLog.error((Object)("Decoded rule: " + archiver.decodeObjectForKey("rule")));
                        }
                    }
                } else {
                    NSArray rules = (NSArray)new EOKeyValueUnarchiver(dic).decodeObjectForKey("rules");
                    if (rules != null) {
                        ERD2WModel model = new ERD2WModel(rules);
                        this.addRules(model.rules());
                    }
                }
            }
            this.setDirty(false);
        }
        this.setCurrentFile(null);
    }

    protected void mergeFile(File modelFile) {
        this.mergePathURL(ERXFileUtilities.URLFromFile((File)modelFile));
    }

    protected void uniqueRuleAssignments(NSArray rules) {
        if (rules != null && rules.count() > 0) {
            int uniquedRules = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting Assignment uniquing for " + rules.count() + " rules"));
            }
            for (int c = 0; c < rules.count() - 1; ++c) {
                Rule r = (Rule)rules.objectAtIndex(c);
                if (r != null && r.rhs() != null) {
                    Vector v = (Vector)this._uniqueAssignments.get(r.rhs().keyPath());
                    if (v != null) {
                        Assignment unique = this.assignmentContainedInVector(r.rhs(), v);
                        if (unique == null) {
                            v.addElement(r.rhs());
                            continue;
                        }
                        if (unique == r.rhs()) continue;
                        r.setRhs(unique);
                        ++uniquedRules;
                        continue;
                    }
                    Vector<Assignment> m = new Vector<Assignment>();
                    m.addElement(r.rhs());
                    this._uniqueAssignments.put(r.rhs().keyPath(), m);
                    continue;
                }
                log.warn((Object)("Rule is null: " + r + " or rhs: " + (r != null ? r.rhs() : null)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished Assignment uniquing, got rid of " + uniquedRules + " duplicate assignment(s)"));
            }
        }
    }

    protected Assignment assignmentContainedInVector(Assignment a1, Vector v) {
        Assignment containedAssignment = null;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Assignment a2 = (Assignment)e.nextElement();
            if (!ERD2WUtilities.assignmentsAreEqual(a1, a2)) continue;
            containedAssignment = a2;
            break;
        }
        return containedAssignment;
    }

    protected void uniqueQualifiers(NSArray rules) {
        if (rules != null && rules.count() > 0) {
            this.uniquedQualifiers = 0;
            this.totalQualifiers = 0;
            int replacedQualifiers = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting Qualifier uniquing for " + rules.count() + " rules"));
            }
            for (int c = 0; c < rules.count() - 1; ++c) {
                Rule r;
                if (c % 100 == 0) {
                    log.debug((Object)("Out of : " + c + " rules, qualifiers: " + this.totalQualifiers + " duplicates: " + this.uniquedQualifiers + " replaced: " + replacedQualifiers));
                }
                if ((r = (Rule)rules.objectAtIndex(c)) == null || r.lhs() == null) continue;
                EOQualifier q = r.lhs();
                try {
                    EOQualifier cache = this.qualifierInCache(q);
                    if (cache == null || cache == q) continue;
                    r.setLhs(cache);
                    ++replacedQualifiers;
                    continue;
                }
                catch (NullPointerException npe) {
                    log.warn((Object)("Caught NPE for rule: " + r));
                }
            }
            this.flushUniqueCache();
            if (this.uniquedQualifiers > 0) {
                ERXExtensions.forceGC((int)0);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished Qualifier uniquing, for: " + this.totalQualifiers + " got rid of " + this.uniquedQualifiers + " duplicate qualifiers, replaced: " + replacedQualifiers));
            }
        }
    }

    public Vector modelFilesInBundles() {
        Vector modelFiles = super.modelFilesInBundles();
        if (!this._hasAddedExtraModelFiles) {
            NSArray<URL> additionalModelURLs = this.additionalModelURLs();
            for (URL url : additionalModelURLs) {
                modelFiles.add(url.getFile());
            }
            this._hasAddedExtraModelFiles = true;
        }
        return modelFiles;
    }

    public Vector modelFilesPathURLsInBundles() {
        Vector modelFilePaths = super.modelFilesPathURLsInBundles();
        if (!this._hasAddedExtraModelFiles) {
            NSArray<URL> additionalModelURLs = this.additionalModelURLs();
            modelFilePaths.addAll(additionalModelURLs);
            this._hasAddedExtraModelFiles = true;
        }
        return modelFilePaths;
    }

    private NSArray<URL> additionalModelURLs() {
        NSMutableArray result = new NSMutableArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding additional rule files");
        }
        NSArray<String> modelNames = this.additionalModelNames();
        NSMutableArray bundles = NSBundle.frameworkBundles().mutableClone();
        bundles.addObject((Object)NSBundle.mainBundle());
        if (modelNames.count() > 0 && bundles.count() > 0) {
            for (NSBundle bundle : bundles) {
                String name = bundle.name();
                if (name == null) continue;
                for (String modelName : modelNames) {
                    URL path = bundle.pathURLForResourcePath(modelName);
                    if (path == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding file '" + path + "' from framework '" + name + "'"));
                    }
                    result.addObject((Object)path);
                }
            }
        }
        return result;
    }

    private NSArray<String> additionalModelNames() {
        NSArray modelNames = ERXProperties.arrayForKeyWithDefault((String)"er.directtoweb.ERD2WModel.additionalModelNames", (NSArray)NSArray.EmptyArray);
        NSMutableArray result = new NSMutableArray();
        result.addObjectsFromArray(modelNames);
        String extraModelFilePath = System.getProperty("ERExtraD2WModelFile");
        if (extraModelFilePath != null) {
            result.addObject((Object)extraModelFilePath);
        }
        return result;
    }

    protected EOQualifier qualifierContainedInEnumeration(EOQualifierEvaluation q1, Enumeration e) {
        EOQualifier containedQualifier = null;
        while (e.hasMoreElements()) {
            EOQualifierEvaluation q2 = (EOQualifierEvaluation)e.nextElement();
            if (!q1.equals(q2)) continue;
            containedQualifier = (EOQualifier)q2;
            break;
        }
        if (containedQualifier != null && q1 != containedQualifier) {
            ++this.uniquedQualifiers;
        }
        return containedQualifier;
    }

    protected EOQualifier qualifierInCache(EOQualifier q) {
        EOKeyValueQualifier cacheQualifier = null;
        ++this.totalQualifiers;
        if (q != null) {
            if (q instanceof EOKeyValueQualifier) {
                cacheQualifier = this.keyValueQualifierInCache((EOKeyValueQualifier)q);
            } else if (q instanceof EONotQualifier) {
                cacheQualifier = this.notQualifierInCache((EONotQualifier)q);
            } else if (q instanceof EOAndQualifier) {
                cacheQualifier = this.andQualifierInCache((EOAndQualifier)q);
            } else if (q instanceof EOOrQualifier) {
                cacheQualifier = this.orQualifierInCache((EOOrQualifier)q);
            } else {
                log.warn((Object)("Unknown qualifier type: " + q.getClass().getName()));
            }
        } else {
            log.warn((Object)"Asking cache for a null qualifier.");
        }
        return cacheQualifier;
    }

    protected EOAndQualifier andQualifierInCache(EOAndQualifier q) {
        EOAndQualifier cachedQualifier = null;
        String hashEntryName = this.nameForSet(q.allQualifierKeys());
        Vector<EOAndQualifier> v = (Vector<EOAndQualifier>)this._uniqueAndQualifiers.get(hashEntryName);
        if (v != null) {
            EOQualifier cache = this.qualifierContainedInEnumeration((EOQualifierEvaluation)q, v.elements());
            if (cache != null) {
                cachedQualifier = (EOAndQualifier)cache;
            }
        } else {
            v = new Vector<EOAndQualifier>();
            this._uniqueAndQualifiers.put(hashEntryName, v);
        }
        if (cachedQualifier == null) {
            NSMutableArray qualifiers = null;
            for (int c = 0; c < q.qualifiers().count(); ++c) {
                EOQualifier q1 = (EOQualifier)q.qualifiers().objectAtIndex(c);
                EOQualifier cache = this.qualifierInCache(q1);
                if (cache == null) continue;
                if (qualifiers == null) {
                    qualifiers = new NSMutableArray();
                    qualifiers.addObjectsFromArray(q.qualifiers());
                }
                if (cache == q1) {
                    log.warn((Object)("Found sub-qualifier: " + cache + " in cache when parent qualifier is not?!?!"));
                    continue;
                }
                qualifiers.replaceObjectAtIndex((Object)cache, c);
            }
            if (qualifiers != null) {
                cachedQualifier = new EOAndQualifier(qualifiers);
                v.addElement(cachedQualifier);
            } else {
                v.addElement(q);
            }
        }
        return cachedQualifier;
    }

    protected EOOrQualifier orQualifierInCache(EOOrQualifier q) {
        EOOrQualifier cachedQualifier = null;
        String hashEntryName = this.nameForSet(q.allQualifierKeys());
        Vector<EOOrQualifier> v = (Vector<EOOrQualifier>)this._uniqueOrQualifiers.get(hashEntryName);
        if (v != null) {
            EOQualifier cache = this.qualifierContainedInEnumeration((EOQualifierEvaluation)q, v.elements());
            if (cache != null) {
                cachedQualifier = (EOOrQualifier)cache;
            }
        } else {
            v = new Vector<EOOrQualifier>();
            this._uniqueOrQualifiers.put(hashEntryName, v);
        }
        if (cachedQualifier == null) {
            NSMutableArray qualifiers = null;
            for (int c = 0; c < q.qualifiers().count(); ++c) {
                EOQualifier q1 = (EOQualifier)q.qualifiers().objectAtIndex(c);
                EOQualifier cache = this.qualifierInCache(q1);
                if (cache == null) continue;
                if (qualifiers == null) {
                    qualifiers = new NSMutableArray();
                    qualifiers.addObjectsFromArray(q.qualifiers());
                }
                if (cache == q1) {
                    log.warn((Object)("Found sub-qualifier: " + cache + " in cache when parent qualifier is not?!?!"));
                    continue;
                }
                qualifiers.replaceObjectAtIndex((Object)cache, c);
            }
            if (qualifiers != null) {
                cachedQualifier = new EOOrQualifier(qualifiers);
                v.addElement(cachedQualifier);
            } else {
                v.addElement(q);
            }
        }
        return cachedQualifier;
    }

    protected EONotQualifier notQualifierInCache(EONotQualifier q) {
        EOQualifier cache;
        EONotQualifier cachedQualifier = null;
        String hashEntryName = this.nameForSet(q.allQualifierKeys());
        Vector<EONotQualifier> v = (Vector<EONotQualifier>)this._uniqueNotQualifiers.get(hashEntryName);
        if (v != null) {
            cache = this.qualifierContainedInEnumeration((EOQualifierEvaluation)q, v.elements());
            if (cache != null) {
                cachedQualifier = (EONotQualifier)cache;
            }
        } else {
            v = new Vector<EONotQualifier>();
            this._uniqueNotQualifiers.put(hashEntryName, v);
        }
        if (cachedQualifier == null) {
            cache = this.qualifierInCache(q.qualifier());
            if (cache != null) {
                if (cache == q.qualifier()) {
                    log.warn((Object)("Found sub-qualifier in cache: " + cache + " when qualifier not in cache?!?! " + q));
                    v.addElement(q);
                } else {
                    cachedQualifier = new EONotQualifier(cache);
                    v.addElement(cachedQualifier);
                }
            } else {
                v.addElement(q);
            }
        }
        return cachedQualifier;
    }

    protected EOKeyValueQualifier keyValueQualifierInCache(EOKeyValueQualifier q) {
        EOKeyValueQualifier cachedQualifier = null;
        Vector<EOKeyValueQualifier> v = (Vector<EOKeyValueQualifier>)this._uniqueKeyValueQualifiers.get(q.key());
        if (v != null) {
            EOQualifier cache = this.qualifierContainedInEnumeration((EOQualifierEvaluation)q, v.elements());
            if (cache != null) {
                cachedQualifier = (EOKeyValueQualifier)cache;
            }
        } else {
            v = new Vector<EOKeyValueQualifier>();
            this._uniqueKeyValueQualifiers.put(q.key(), v);
        }
        if (cachedQualifier == null) {
            v.addElement(q);
        }
        return cachedQualifier;
    }

    protected void flushUniqueCache() {
        this._uniqueKeyValueQualifiers = new Hashtable();
        this._uniqueNotQualifiers = new Hashtable();
        this._uniqueOrQualifiers = new Hashtable();
        this._uniqueNotQualifiers = new Hashtable();
    }

    public String nameForSet(NSSet set) {
        NSMutableArray stringObjects = new NSMutableArray();
        stringObjects.addObjectsFromArray(set.allObjects());
        ERXArrayUtilities.sortArrayWithKey((NSMutableArray)stringObjects, (String)"description");
        return stringObjects.componentsJoinedByString(".");
    }

    protected Object encodeObject(Object o) {
        if (o instanceof EOEntity) {
            o = ENTITY_PREFIX + ((EOEntity)o).name();
        } else if (o instanceof EORelationship) {
            o = RELATIONSHIP_PREFIX + ((EORelationship)o).name() + ENTITY_PREFIX + ((EORelationship)o).entity().name();
        } else if (o instanceof EOAttribute) {
            o = ATTRIBUTE_PREFIX + ((EOAttribute)o).name() + ENTITY_PREFIX + ((EOAttribute)o).entity().name();
        }
        return o;
    }

    protected Object decodeObject(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            if (s.indexOf(ENTITY_PREFIX) == 0) {
                String entityName = s.substring(ENTITY_PREFIX.length());
                o = EOModelGroup.defaultGroup().entityNamed(entityName);
            } else if (s.indexOf(RELATIONSHIP_PREFIX) == 0) {
                int entityOffset = s.indexOf(ENTITY_PREFIX);
                String entityName = s.substring(entityOffset + ENTITY_PREFIX.length());
                String relationshipName = s.substring(RELATIONSHIP_PREFIX.length(), entityOffset);
                EOEntity entity = EOModelGroup.defaultGroup().entityNamed(entityName);
                o = entity.relationshipNamed(relationshipName);
            } else if (s.indexOf(ATTRIBUTE_PREFIX) == 0) {
                int entityOffset = s.indexOf(ENTITY_PREFIX);
                String entityName = s.substring(entityOffset + ENTITY_PREFIX.length());
                String attributeName = s.substring(ATTRIBUTE_PREFIX.length(), entityOffset);
                EOEntity entity = EOModelGroup.defaultGroup().entityNamed(entityName);
                o = entity.attributeNamed(attributeName);
            }
        }
        return o;
    }

    protected boolean writeEntry(ERXMultiKey key, Object value, ObjectOutputStream out) throws IOException {
        if ((value = this.encodeObject(value)) != null && !(value instanceof Serializable)) {
            return false;
        }
        Object[] keyKeys = key.keys();
        Object[] keys = new Object[keyKeys.length];
        for (int i = 0; i < keys.length; i = (int)((short)(i + 1))) {
            Object o = keyKeys[i];
            if ((o = this.encodeObject(o)) != null && !(o instanceof Serializable)) {
                return false;
            }
            keys[i] = o;
        }
        out.writeObject(keys);
        out.writeObject(value);
        return true;
    }

    protected ERXMultiKey readEntry(Hashtable cache, ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object[] keys = (Object[])in.readObject();
        Object value = this.decodeObject(in.readObject());
        for (int i = 0; i < keys.length; i = (int)((short)(i + 1))) {
            Object o;
            keys[i] = o = this.decodeObject(keys[i]);
        }
        ERXMultiKey key = new ERXMultiKey(keys);
        cache.put(key, value);
        return key;
    }

    protected byte[] cacheToBytes(Hashtable cache) {
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(ostream);
            Enumeration keys = cache.keys();
            while (keys.hasMoreElements()) {
                Object o;
                ERXMultiKey key = (ERXMultiKey)keys.nextElement();
                if (this.writeEntry(key, o = cache.get(key), out)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Wrote: " + key + " -- " + o));
                    continue;
                }
                log.info((Object)("Can't write: " + key + " -- " + o));
            }
            out.flush();
            ostream.close();
            return ostream.toByteArray();
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    protected Hashtable cacheFromBytes(byte[] bytes) {
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
            ERXMappingObjectStream in = new ERXMappingObjectStream((InputStream)istream);
            Hashtable newCache = new Hashtable(10000);
            try {
                while (true) {
                    ERXMultiKey key = this.readEntry(newCache, (ObjectInputStream)in);
                    Object o = newCache.get(key);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Read: " + key + " -- " + o));
                }
            }
            catch (EOFException ex) {
                istream.close();
                return newCache;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public void _diagnoseCache() {
        Hashtable cache = this._cache;
        Set keySet = cache.keySet();
        Iterator keySetIterator = keySet.iterator();
        System.out.println("Cache size is: " + cache.size());
        while (keySetIterator.hasNext()) {
            Object theKey = keySetIterator.next();
            Object theValue = cache.get(theKey);
            System.out.println("\t" + theKey + " -> " + theValue);
        }
    }

    static {
        BACKSTOP_KEYS = new NSMutableArray(new Object[]{"pageConfiguration", "entity", "task"});
        Class<D2WFastModel> c = D2WFastModel.class;
        _defaultModel = new ERD2WModel(NSArray.EmptyArray);
        D2WModel.setDefaultModel((D2WModel)_defaultModel);
        _prioritySortOrdering = new EOSortOrdering("priority", EOSortOrdering.CompareDescending);
        _descriptionSortOrdering = new EOSortOrdering("toString", EOSortOrdering.CompareDescending);
        _addKeyToVectorDefaultKeysToTakeLiterally = new NSSet(new Object[]{"object", "session"});
    }

    static class _LhsKeysCallback
    extends ERDQualifierTraversalCallback {
        public NSMutableArray keys = new NSMutableArray();

        _LhsKeysCallback() {
        }

        public boolean traverseKeyValueQualifier(EOKeyValueQualifier q) {
            if (!this.keys.containsObject((Object)q.key())) {
                this.keys.addObject((Object)q.key());
            }
            return true;
        }

        public boolean traverseKeyComparisonQualifier(EOKeyComparisonQualifier q) {
            if (!this.keys.containsObject((Object)q.leftKey())) {
                this.keys.addObject((Object)q.leftKey());
            }
            if (!this.keys.containsObject((Object)q.rightKey())) {
                this.keys.addObject((Object)q.rightKey());
            }
            return true;
        }
    }
}

