/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.assignments.defaults;

import com.webobjects.directtoweb.D2WContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import er.directtoweb.assignments.ERDAssignment;
import er.directtoweb.assignments.ERDLocalizableAssignmentInterface;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERDDefaultDisplayNameAssignment
extends ERDAssignment
implements ERDLocalizableAssignmentInterface {
    static final Logger log = Logger.getLogger(ERDDefaultDisplayNameAssignment.class);
    protected static final NSDictionary keys = ERXDictionaryUtilities.dictionaryWithObjectsAndKeys((Object[])new Object[]{new NSArray(new Object[]{"pageConfiguration", "task", "entity.name"}), "displayNameForPageConfiguration", new NSArray(new Object[]{"entity", "object.entityName"}), "displayNameForEntity", new NSArray(new Object[]{"sectionKey"}), "displayNameForSectionKey", new NSArray(new Object[]{"tabKey"}), "displayNameForTabKey", new NSArray(new Object[]{"propertyKey"}), "displayNameForProperty", new NSArray(new Object[]{"propertyKey"}), "displayNameForPropertyKeyPath", new NSArray(new Object[]{"smartRelationship.destinationEntity", "destinationEntityName"}), "displayNameForDestinationEntity", new NSArray(new Object[]{"editConfigurationName"}), "displayNameForEditConfiguration", new NSArray(new Object[]{"inspectConfigurationName"}), "displayNameForInspectConfiguration", new NSArray(new Object[]{"createConfigurationName"}), "displayNameForCreateConfiguration", new NSArray(new Object[]{"confirmDeleteConfigurationName"}), "displayNameForConfirmDeleteConfiguration"});

    public NSArray dependentKeys(String keyPath) {
        return (NSArray)keys.valueForKey(keyPath);
    }

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver eokeyvalueunarchiver) {
        return new ERDDefaultDisplayNameAssignment(eokeyvalueunarchiver);
    }

    public ERDDefaultDisplayNameAssignment(EOKeyValueUnarchiver u) {
        super(u);
    }

    public ERDDefaultDisplayNameAssignment(String key, Object value) {
        super(key, value);
    }

    protected Object localizedValueForDisplayNameOfKeyPath(String keyPath, D2WContext c) {
        String realName = (String)c.valueForKeyPath(keyPath);
        String localizerKey = ERXStringUtilities.capitalize((String)keyPath) + "." + realName;
        String result = ERXLocalizer.currentLocalizer().localizedStringForKey(localizerKey);
        if (result == null) {
            result = ERXStringUtilities.displayNameForKey((String)realName);
            result = this.localizedValueForKey(result, localizerKey);
        }
        return result;
    }

    public Object displayNameForProperty(D2WContext c) {
        return this.localizedValueForDisplayNameOfKeyPath("propertyKey", c);
    }

    public Object displayNameForPropertyKeyPath(D2WContext c) {
        String keyPath = (String)c.valueForKey("propertyKey");
        String result = null;
        if (keyPath != null) {
            String localizerKey = "PropertyKey." + keyPath;
            result = ERXLocalizer.currentLocalizer().localizedStringForKey(localizerKey);
            if (result == null) {
                result = "";
                Enumeration parts = NSArray.componentsSeparatedByString((String)keyPath, (String)".").objectEnumerator();
                while (parts.hasMoreElements()) {
                    String key = (String)parts.nextElement();
                    String displayName = ERXStringUtilities.displayNameForKey((String)key);
                    if (displayName != null) {
                        result = result + displayName;
                    }
                    if (!parts.hasMoreElements()) continue;
                    result = result + " ";
                }
                result = this.localizedValueForKey(result, localizerKey);
            }
        }
        return result;
    }

    public Object displayNameForEntity(D2WContext c) {
        return this.localizedValueForDisplayNameOfKeyPath("entity.name", c);
    }

    public Object displayNameForDestinationEntity(D2WContext c) {
        Object result = null;
        EOEntity destinationEntity = (EOEntity)c.valueForKeyPath("smartRelationship.destinationEntity");
        if (destinationEntity != null) {
            EOEntity entity = (EOEntity)c.valueForKey("entity");
            c.takeValueForKey((Object)destinationEntity, "entity");
            result = c.valueForKey("displayNameForEntity");
            c.takeValueForKey((Object)entity, "entity");
        }
        return result;
    }

    public Object displayNameForSectionKey(D2WContext c) {
        return this.localizedValueForDisplayNameOfKeyPath("sectionKey", c);
    }

    public Object displayNameForTabKey(D2WContext c) {
        return this.localizedValueForDisplayNameOfKeyPath("tabKey", c);
    }

    public Object displayNameForPageConfiguration(D2WContext c) {
        String pageConfiguration = (String)c.valueForKey("pageConfiguration");
        if (pageConfiguration == null) {
            return "";
        }
        if (pageConfiguration.indexOf("__") == 0) {
            String taskName = (String)c.valueForKey("task");
            if (taskName == null) {
                taskName = pageConfiguration.substring(2, pageConfiguration.indexOf("__", 3));
            }
            String entityName = (String)c.valueForKeyPath("entity.name");
            log.debug((Object)(pageConfiguration + ": task=" + taskName + ", entity=" + entityName));
            pageConfiguration = taskName.substring(0, 1).toUpperCase() + taskName.substring(1) + (entityName != null ? entityName : "");
        }
        String localizerKey = "Pages." + pageConfiguration;
        String result = ERXLocalizer.currentLocalizer().localizedStringForKey(localizerKey);
        if (result == null) {
            result = ERXStringUtilities.displayNameForKey((String)pageConfiguration);
        }
        result = this.localizedValueForKey(result, localizerKey);
        return result;
    }

    private String localizedValueForKey(String result, String localizerKey) {
        String formerResult = ERXLocalizer.currentLocalizer().localizedStringForKey(result);
        if (formerResult != null) {
            result = formerResult;
            log.info((Object)("Found an old-style entry: " + localizerKey + "->" + formerResult));
        }
        ERXLocalizer.currentLocalizer().takeValueForKey((Object)result, localizerKey);
        return result;
    }

    public Object displayNameForEditConfiguration(D2WContext c) {
        return this.localizedValueForDisplayNameOfKeyPath("editConfigurationName", c);
    }

    public Object displayNameForInspectConfiguration(D2WContext c) {
        return this.localizedValueForDisplayNameOfKeyPath("inspectConfigurationName", c);
    }

    public Object displayNameForCreateConfiguration(D2WContext c) {
        return this.localizedValueForDisplayNameOfKeyPath("createConfigurationName", c);
    }

    public Object displayNameForConfirmDeleteConfiguration(D2WContext c) {
        return this.localizedValueForDisplayNameOfKeyPath("confirmDeleteConfigurationName", c);
    }
}

