/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.assignments.delayed;

import com.webobjects.directtoweb.D2WContext;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import er.directtoweb.assignments.delayed.ERDDelayedAssignment;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;

public class ERDDelayedObjectCreationAssignment
extends ERDDelayedAssignment {
    public static final Logger log = Logger.getLogger(ERDDelayedObjectCreationAssignment.class);

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver eokeyvalueunarchiver) {
        return new ERDDelayedObjectCreationAssignment(eokeyvalueunarchiver);
    }

    public ERDDelayedObjectCreationAssignment(EOKeyValueUnarchiver u) {
        super(u);
    }

    public ERDDelayedObjectCreationAssignment(String key, Object value) {
        super(key, value);
    }

    public Object fireNow(D2WContext context) {
        Object createdObject = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating object for value: " + this.value()));
            }
            if (this.value() instanceof String) {
                Class<?> c = Class.forName((String)this.value());
                createdObject = c.newInstance();
            } else if (this.value() instanceof NSDictionary) {
                String mainClassName = (String)((NSDictionary)this.value()).objectForKey((Object)"className");
                Class<?> mainClass = Class.forName(mainClassName);
                NSArray arguments = (NSArray)((NSDictionary)this.value()).objectForKey((Object)"arguments");
                if (arguments != null && arguments.count() > 0) {
                    Class[] argumentClasses = new Class[arguments.count()];
                    Object[] argumentValues = new Object[arguments.count()];
                    for (int count = 0; count < arguments.count(); ++count) {
                        NSDictionary anArgument = (NSDictionary)arguments.objectAtIndex(count);
                        String argumentClassName = (String)anArgument.objectForKey((Object)"className");
                        String argumentContextKey = (String)anArgument.objectForKey((Object)"contextKey");
                        argumentValues[count] = context.valueForKeyPath(argumentContextKey);
                        argumentClasses[count] = Class.forName(argumentClassName);
                    }
                    Constructor<?> constructor = mainClass.getConstructor(argumentClasses);
                    if (constructor != null) {
                        createdObject = constructor.newInstance(argumentValues);
                    } else {
                        log.warn((Object)("Unable to find constructor on class: " + mainClass.getName() + " for argument classes: " + argumentClasses));
                    }
                } else {
                    createdObject = mainClass.newInstance();
                }
            } else {
                log.warn((Object)("Unsupported value: " + this.value()));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Exception happened when attempting to create object for value: " + this.value() + " exception: " + e));
        }
        return createdObject;
    }
}

