/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.components.misc;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSValidation;
import er.directtoweb.components.ERDCustomEditComponent;
import er.extensions.foundation.ERXSimpleTemplateParser;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;
import er.extensions.validation.ERXValidationException;
import er.extensions.validation.ERXValidationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class ERDEditFile
extends ERDCustomEditComponent {
    static final Logger log = Logger.getLogger(ERDEditFile.class);
    public String fileName;
    public String uploadDirectory;
    public NSData fileContents;
    public NSDictionary extraBindings;
    public boolean shouldRaise = false;
    public boolean didUpload = false;

    public ERDEditFile(WOContext context) {
        super(context);
    }

    private String localizedValueForBinding(String binding) {
        String result = (String)this.valueForBinding(binding);
        if (result == null) {
            result = ERXLocalizer.currentLocalizer().localizedStringForKeyWithDefault("ERDEditFile." + binding);
        }
        return result;
    }

    public String selectMessage() {
        String result = this.localizedValueForBinding("selectMessage");
        return result;
    }

    public String uploadMessage() {
        String result = this.localizedValueForBinding("uploadMessage");
        return result;
    }

    public String selectButton() {
        String result = this.localizedValueForBinding("selectButton");
        return result;
    }

    public String uploadButton() {
        String result = this.localizedValueForBinding("uploadButton");
        return result;
    }

    public String deleteButton() {
        String result = this.localizedValueForBinding("deleteButton");
        return result;
    }

    void extract(InputStream in, String[] files) throws IOException {
        ZipEntry e;
        ZipInputStream zis = new ZipInputStream(in);
        block0: while ((e = zis.getNextEntry()) != null) {
            if (files == null) {
                this.extractFile(zis, e);
                continue;
            }
            String name = e.getName();
            for (int i = 0; i < files.length; ++i) {
                String file = files[i].replace(File.separatorChar, '/');
                if (!name.startsWith(file)) continue;
                this.extractFile(zis, e);
                continue block0;
            }
        }
    }

    void extractFile(ZipInputStream zis, ZipEntry e) throws IOException {
        String name = e.getName();
        File f = new File(this.uploadDirectory() + File.separatorChar + e.getName().replace('/', File.separatorChar));
        if (e.isDirectory()) {
            if (!f.exists() && !f.mkdirs() || !f.isDirectory()) {
                throw new IOException("Can't create " + f.getPath());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing: " + name));
            }
        } else {
            int len;
            File d;
            if (!(f.getParent() == null || ((d = new File(f.getParent())).exists() || d.mkdirs()) && d.isDirectory())) {
                throw new IOException("Can't create " + d.getPath());
            }
            FileOutputStream os = new FileOutputStream(f);
            byte[] b = new byte[512];
            while ((len = zis.read(b, 0, b.length)) != -1) {
                ((OutputStream)os).write(b, 0, len);
            }
            zis.closeEntry();
            ((OutputStream)os).close();
            if (log.isDebugEnabled()) {
                if (e.getMethod() == 8) {
                    log.debug((Object)("Extracted: " + name));
                } else {
                    log.debug((Object)("Inflated: " + name));
                }
            }
        }
    }

    public String uploadDirectory() {
        if (this.uploadDirectory == null) {
            this.uploadDirectory = (String)this.valueForBinding("uploadDirectory");
            if (this.uploadDirectory == null) {
                this.uploadDirectory = "/tmp";
            }
            this.uploadDirectory = ERXSimpleTemplateParser.sharedInstance().parseTemplateWithObject(this.uploadDirectory, null, (Object)this, (Object)this.object());
        }
        return this.uploadDirectory;
    }

    public WOActionResults invokeAction(WORequest worequest, WOContext wocontext) {
        WOActionResults results = super.invokeAction(worequest, wocontext);
        return results;
    }

    public void takeValuesFromRequest(WORequest q, WOContext c) throws NSValidation.ValidationException {
        super.takeValuesFromRequest(q, c);
        this.uploadFile();
        try {
            if (this.key().charAt(0) != '#') {
                this.object().validateTakeValueForKeyPath(this.objectKeyPathValue(), this.key());
            }
        }
        catch (Throwable e) {
            this.validationFailedWithException(e, this.objectKeyPathValue(), this.key());
        }
    }

    public void sleep() {
        if (!this.synchronizesVariablesWithBindings()) {
            this.reset();
        }
        super.sleep();
    }

    public void reset() {
        this.fileName = null;
        this.fileContents = null;
        this.uploadDirectory = null;
        this.extraBindings = null;
        this.shouldRaise = false;
        this.didUpload = false;
    }

    public boolean isStateless() {
        return false;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public String fileName() {
        if (this.fileName == null) {
            this.fileName = (String)this.valueForBinding("fileName");
        }
        if (this.fileName != null) {
            this.fileName = this.fileName.replace('\\', '/');
            this.fileName = this.fileName.replace(':', '/');
            this.fileName = NSPathUtilities.lastPathComponent((String)this.fileName);
        }
        return this.fileName;
    }

    public String realPath() {
        String fileName = this.fileName();
        if (fileName == null || this.fileName().length() == 0) {
            return null;
        }
        File tmpPath = new File(this.uploadDirectory());
        tmpPath.mkdirs();
        String filePath = tmpPath.exists() ? tmpPath.getAbsolutePath() : System.getProperty("user.dir");
        return new String(filePath + File.separator + this.lastPartOfFileName());
    }

    public NSData fileContentz() {
        if (this.fileContents == null) {
            // empty if block
        }
        return this.fileContents;
    }

    public void setFileContentz(NSData data) {
        this.fileContents = data;
    }

    public boolean haveData() {
        return this.fileContentz() != null && this.fileContentz().length() > 0;
    }

    public void setObjectKeyPathValue(Object value) {
        if (this.key().charAt(0) != '#') {
            super.setObjectKeyPathValue(value);
        }
    }

    public Object objectKeyPathValue() {
        if (this.key().charAt(0) != '#') {
            return super.objectKeyPathValue();
        }
        return null;
    }

    public void deleteFile() {
        if (this.fileExists()) {
            File file = new File(this.uploadDirectory() + File.separator + this.objectKeyPathValue());
            file.delete();
            log.debug((Object)("Deleted file from '" + file + "'"));
        } else {
            log.debug((Object)"No File Deleted");
        }
        this.setObjectKeyPathValue(null);
    }

    public boolean shouldUnpack() {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.valueForBinding("shouldUnpack"), (boolean)false);
    }

    public boolean fileExists() {
        if (this.uploadDirectory() != null && this.objectKeyPathValue() != null) {
            return new File(this.uploadDirectory() + File.separator + this.objectKeyPathValue()).exists();
        }
        return false;
    }

    public String lastPartOfFileName() {
        if (this.fileName() != null) {
            return NSPathUtilities.lastPathComponent((String)this.fileName());
        }
        return null;
    }

    public void uploadFile() {
        if (this.didUpload) {
            return;
        }
        if (this.fileContentz() == null || this.fileContentz().length() <= 0) {
            return;
        }
        String outputFilePath = this.realPath();
        if (outputFilePath != null) {
            log.info((Object)("fileName: " + outputFilePath));
            if (new File(outputFilePath).exists()) {
                ERXValidationException ex = ERXValidationFactory.defaultFactory().createException(this.object(), this.key(), (Object)this.fileName(), "fileexists");
                this.validationFailedWithException((Throwable)ex, this.fileName(), this.key());
            } else {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(outputFilePath);
                    this.fileContentz().writeToStream((OutputStream)fileOutputStream);
                    fileOutputStream.close();
                    log.debug((Object)("Wrote file to '" + outputFilePath + "'" + this.shouldUnpack()));
                    if (this.shouldUnpack()) {
                        try {
                            this.extract(new BufferedInputStream(new FileInputStream(outputFilePath)), null);
                        }
                        catch (IOException ex) {
                            log.warn((Object)("Unpacking error: " + ex));
                        }
                    }
                    this.setObjectKeyPathValue(this.lastPartOfFileName());
                    this.didUpload = true;
                }
                catch (IOException e) {
                    log.error((Object)("Error writing file: " + e));
                }
            }
        } else {
            log.debug((Object)"No File Uploaded");
        }
    }

    public WOComponent deleteAction() {
        this.deleteFile();
        return this.context().page();
    }

    public WOComponent uploadAction() {
        this.uploadFile();
        return this.context().page();
    }
}

