/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.delegates;

import com.webobjects.appserver.WOComponent;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.directtoweb.ERDirectToWeb;
import er.directtoweb.delegates.ERDBranchDelegateInterface;
import er.directtoweb.delegates.ERDBranchInterface;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.localization.ERXLocalizer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public abstract class ERDBranchDelegate
implements ERDBranchDelegateInterface {
    public static final Logger log = Logger.getLogger(ERDBranchDelegate.class);
    public static final Class[] WOComponentClassArray = new Class[]{WOComponent.class};
    public static final String BRANCH_CHOICES = "branchChoices";
    public static final String BRANCH_BUTTON_ID = "branchButtonID";
    public static final String BRANCH_NAME = "branchName";
    public static final String BRANCH_LABEL = "branchButtonLabel";
    public static final String BRANCH_PREFIX = "Button";

    public final WOComponent nextPage(WOComponent sender) {
        WOComponent nextPage = null;
        if (sender instanceof ERDBranchInterface) {
            String branchName = ((ERDBranchInterface)sender).branchName();
            if (branchName != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Branching to branch: " + branchName));
                }
                try {
                    Method m = this.getClass().getMethod(branchName, WOComponentClassArray);
                    nextPage = (WOComponent)m.invoke((Object)this, sender);
                }
                catch (InvocationTargetException ite) {
                    log.error((Object)("Invocation exception occurred in ERBranchDelegate: " + ite.getTargetException() + " for branch name: " + branchName), ite.getTargetException());
                    throw new NSForwardException(ite.getTargetException());
                }
                catch (Exception e) {
                    log.error((Object)("Exception occurred in ERBranchDelegate: " + e.toString() + " for branch name: " + branchName));
                    throw new NSForwardException((Throwable)e);
                }
            }
        } else {
            log.warn((Object)"Branch delegate being used with a component that does not implement the ERBranchInterface");
        }
        return nextPage;
    }

    protected NSDictionary branchChoiceDictionary(String method, String label) {
        if (label == null) {
            label = ERXLocalizer.currentLocalizer().localizedDisplayNameForKey(BRANCH_PREFIX, method);
        }
        return ERXDictionaryUtilities.dictionaryWithObjectsAndKeys((Object[])new Object[]{method, BRANCH_NAME, label, BRANCH_LABEL, method + "Action", BRANCH_BUTTON_ID});
    }

    public NSArray branchChoicesForContext(D2WContext context) {
        NSArray choices = (NSArray)context.valueForKey(BRANCH_CHOICES);
        if (choices == null) {
            choices = this.defaultBranchChoices(context);
        } else {
            NSMutableArray translatedChoices = new NSMutableArray();
            for (Object o : choices) {
                String method = null;
                String label = null;
                NSMutableDictionary entry = new NSMutableDictionary();
                if (o instanceof NSDictionary) {
                    entry.addEntriesFromDictionary((NSDictionary)o);
                    method = (String)entry.objectForKey((Object)BRANCH_NAME);
                    label = (String)entry.objectForKey((Object)BRANCH_LABEL);
                } else if (o instanceof String) {
                    method = (String)o;
                    entry.setObjectForKey((Object)method, (Object)BRANCH_NAME);
                }
                if (label == null) {
                    label = ERXLocalizer.currentLocalizer().localizedDisplayNameForKey(BRANCH_PREFIX, method);
                } else if (label.startsWith("Button.")) {
                    String localizerKey = label;
                    String localized = ERXLocalizer.currentLocalizer().localizedStringForKey(label);
                    if (localized == null) {
                        label = ERXLocalizer.currentLocalizer().localizedDisplayNameForKey(BRANCH_PREFIX, method);
                        ERXLocalizer.currentLocalizer().takeValueForKey((Object)label, localizerKey);
                    } else {
                        label = localized;
                    }
                } else {
                    label = ERXLocalizer.currentLocalizer().localizedStringForKeyWithDefault(label);
                }
                entry.setObjectForKey((Object)label, (Object)BRANCH_LABEL);
                entry.setObjectForKey((Object)(method + "Action"), (Object)BRANCH_BUTTON_ID);
                translatedChoices.addObject((Object)entry);
            }
            choices = translatedChoices;
        }
        return choices;
    }

    protected NSArray defaultBranchChoices(D2WContext context) {
        NSArray choices = NSArray.EmptyArray;
        try {
            String task = context.task();
            String pageName = context.dynamicPage();
            NSMutableArray methodChoices = new NSMutableArray();
            Object[] methods = this.getClass().getMethods();
            Enumeration e = new NSArray(methods).objectEnumerator();
            while (e.hasMoreElements()) {
                Method method = (Method)e.nextElement();
                if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != WOComponent.class || method.getName().equals("nextPage") || method.getName().charAt(0) == '_' || (method.getModifiers() & 1) != 1) continue;
                boolean isAllowed = true;
                if (method.isAnnotationPresent(D2WDelegate.class)) {
                    D2WDelegate info = method.getAnnotation(D2WDelegate.class);
                    String scope = info.scope();
                    String availableTasks = info.availableTasks();
                    String availablePages = info.availablePages();
                    if (scope.length() > 0) {
                        if ("object".equals(scope) && context.valueForKey("object") == null) {
                            isAllowed = false;
                        }
                        if (!"object".equals(scope) && context.valueForKey("object") != null) {
                            isAllowed = false;
                        }
                    }
                    if (availableTasks.length() > 0 && !availableTasks.contains(task)) {
                        isAllowed = false;
                    }
                    if (availablePages.length() > 0 && !availablePages.contains(pageName)) {
                        isAllowed = false;
                    }
                }
                if (!isAllowed) continue;
                NSDictionary branch = this.branchChoiceDictionary(method.getName(), null);
                methodChoices.addObject((Object)branch);
            }
            choices = ERXArrayUtilities.sortedArraySortedWithKey((NSArray)methodChoices, (String)BRANCH_LABEL);
        }
        catch (SecurityException e) {
            log.error((Object)("Caught security exception while calculating the branch choices for delegate: " + this + " exception: " + e.getMessage()));
        }
        return choices;
    }

    protected D2WContext d2wContext(WOComponent sender) {
        if (ERDirectToWeb.D2WCONTEXT_SELECTOR.implementedByObject((Object)sender)) {
            return (D2WContext)sender.valueForKey(ERDirectToWeb.D2WCONTEXT_SELECTOR.name());
        }
        throw new IllegalStateException("Can't figure out d2wContext from: " + sender);
    }

    protected EOEnterpriseObject object(WOComponent sender) {
        return this.object(this.d2wContext(sender));
    }

    protected EOEnterpriseObject object(D2WContext context) {
        return (EOEnterpriseObject)context.valueForKey("object");
    }

    protected NSArray choiceByRemovingKeys(NSArray keys, NSArray choices) {
        NSMutableArray result = new NSMutableArray(choices.count());
        Enumeration e = choices.objectEnumerator();
        while (e.hasMoreElements()) {
            NSDictionary choice = (NSDictionary)e.nextElement();
            if (keys.containsObject(choice.objectForKey((Object)BRANCH_NAME))) continue;
            result.addObject((Object)choice);
        }
        return result;
    }

    protected NSArray choiceByLeavingKeys(NSArray keys, NSArray choices) {
        NSMutableArray result = new NSMutableArray(choices.count());
        Enumeration e = choices.objectEnumerator();
        while (e.hasMoreElements()) {
            NSDictionary choice = (NSDictionary)e.nextElement();
            if (!keys.containsObject(choice.objectForKey((Object)BRANCH_NAME))) continue;
            result.addObject((Object)choice);
        }
        return result;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface D2WDelegate {
        public String scope() default "";

        public String availableTasks() default "";

        public String availablePages() default "";
    }
}

