/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.delegates;

import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSValidation;
import er.directtoweb.pages.ERD2WQueryPage;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.validation.ERXValidationFactory;
import java.math.BigDecimal;
import java.util.Enumeration;

public abstract class ERDQueryValidationDelegate {
    protected D2WContext d2wContext;

    public void validateQuery(ERD2WQueryPage sender) {
        this.d2wContext = sender.d2wContext();
        WODisplayGroup displayGroup = sender.displayGroup();
        if (displayGroup.queryMatch().allKeys().count() == 0 && displayGroup.queryMin().allKeys().count() == 0 && displayGroup.queryMax().allKeys().count() == 0 && displayGroup.queryBindings().allKeys().count() == 0 && !ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext.valueForKey("allowsEmptyQuery"), (boolean)true)) {
            throw ERXValidationFactory.defaultFactory().createCustomException(null, "QueryEmpty");
        }
        String cachedPropertyKey = this.d2wContext.propertyKey();
        this.validateQueryValues(sender);
        this.d2wContext.setPropertyKey(cachedPropertyKey);
    }

    public abstract void validateQueryValues(ERD2WQueryPage var1);

    public D2WContext d2wContext() {
        return this.d2wContext;
    }

    protected String propertyKeyFromDisplayGroupKey(String key) {
        String result = key;
        if (result.indexOf(".") > 0) {
            boolean found;
            NSArray propertyKeys = ERXValueUtilities.arrayValueWithDefault((Object)this.d2wContext().valueForKey("displayPropertyKeys"), (NSArray)NSArray.EmptyArray);
            do {
                boolean bl = found = propertyKeys.indexOfObject((Object)result) > 0;
                if (found) continue;
                if (result.indexOf(".") <= 0) break;
                result = ERXStringUtilities.keyPathWithoutLastProperty((String)result);
            } while (!found);
            if (!found) {
                result = key;
            }
        }
        return result;
    }

    public boolean hasValidationDefinitionForKey(String key) {
        return this.d2wContext != null && this.d2wContext.valueForKey(key) != null;
    }

    public void validateStringValueForKey(String value, String key) throws NSValidation.ValidationException {
        int minimumLength = ERXValueUtilities.intValueWithDefault((Object)this.d2wContext().valueForKey("minimumInputLength"), (int)0);
        if (null == value) {
            if (minimumLength > 0) {
                throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueRequired");
            }
        } else {
            int maximumLength = ERXValueUtilities.intValueWithDefault((Object)this.d2wContext().valueForKey("maximumInputLength"), (int)-1);
            if (minimumLength > 0 && value.length() < minimumLength) {
                throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueTooShort");
            }
            if (maximumLength > 0 && value.length() > maximumLength) {
                throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueTooLong");
            }
        }
    }

    public void validateNumericValueForKey(Number value, String key) throws NSValidation.ValidationException {
        if (null == value) {
            if (this.d2wContext.valueForKey("minimumInputValue") != null) {
                throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueRequired");
            }
        } else {
            EOAttribute attribute = this.d2wContext.attribute();
            String valueType = attribute.valueType();
            if ("s".equals(valueType) || "i".equals(valueType) || "l".equals(valueType)) {
                Long maximumValue;
                Long minimumValue;
                long longValue = value.longValue();
                if (this.hasValidationDefinitionForKey("minimumInputValue") && (minimumValue = Long.valueOf(ERXValueUtilities.longValue((Object)this.d2wContext().valueForKey("minimumInputValue")))).compareTo(longValue) > 0) {
                    throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueTooSmall");
                }
                if (this.hasValidationDefinitionForKey("maximumInputValue") && (maximumValue = Long.valueOf(ERXValueUtilities.longValue((Object)this.d2wContext().valueForKey("maximumInputValue")))).compareTo(longValue) < 0) {
                    throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueTooLarge");
                }
            } else if ("f".equals(valueType) || "d".equals(valueType)) {
                Double maximumValue;
                Double minimumValue;
                double doubleValue = value.doubleValue();
                if (this.hasValidationDefinitionForKey("minimumInputValue") && (minimumValue = Double.valueOf(ERXValueUtilities.doubleValue((Object)this.d2wContext().valueForKey("minimumInputValue")))).compareTo(doubleValue) > 0) {
                    throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueTooSmall");
                }
                if (this.hasValidationDefinitionForKey("maximumInputValue") && (maximumValue = Double.valueOf(ERXValueUtilities.doubleValue((Object)this.d2wContext().valueForKey("maximumInputValue")))).compareTo(doubleValue) < 0) {
                    throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueTooLarge");
                }
            } else if ("B".equals(valueType)) {
                BigDecimal maximumValue;
                BigDecimal minimumValue;
                BigDecimal bdValue;
                BigDecimal bigDecimal = bdValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.doubleValue());
                if (this.hasValidationDefinitionForKey("minimumInputValue") && (minimumValue = ERXValueUtilities.bigDecimalValue((Object)this.d2wContext().valueForKey("minimumInputValue"))).compareTo(bdValue) > 0) {
                    throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueTooSmall");
                }
                if (this.hasValidationDefinitionForKey("maximumInputValue") && (maximumValue = ERXValueUtilities.bigDecimalValue((Object)this.d2wContext().valueForKey("maximumInputValue"))).compareTo(bdValue) < 0) {
                    throw ERXValidationFactory.defaultFactory().createCustomException(null, key, (Object)value, "QueryValueTooLarge");
                }
            }
        }
    }

    public static class DefaultQueryValidationDelegate
    extends ERDQueryValidationDelegate {
        private ERD2WQueryPage queryPage;

        public void validateQueryValues(ERD2WQueryPage sender) {
            this.queryPage = sender;
            WODisplayGroup displayGroup = this.queryPage.displayGroup();
            this._validateQueryValues((NSDictionary)displayGroup.queryMatch());
            this._validateQueryValues((NSDictionary)displayGroup.queryMin());
            this._validateQueryValues((NSDictionary)displayGroup.queryMax());
            this._validateQueryValues((NSDictionary)displayGroup.queryBindings());
        }

        private void _validateQueryValues(NSDictionary queryDict) {
            Enumeration keysEnum = queryDict.keyEnumerator();
            while (keysEnum.hasMoreElements()) {
                String key = (String)keysEnum.nextElement();
                Object value = queryDict.objectForKey((Object)key);
                try {
                    this.validateValueForQueryKey(value, key);
                }
                catch (NSValidation.ValidationException ve) {
                    this.queryPage.validationFailedWithException(ve, null, ve.key());
                }
            }
        }

        public void validateValueForQueryKey(Object value, String key) throws NSValidation.ValidationException {
            if (value instanceof NSKeyValueCoding.Null) {
                value = null;
            }
            D2WContext d2wContext = this.d2wContext();
            String propertyKey = this.propertyKeyFromDisplayGroupKey(key);
            this.d2wContext().setPropertyKey(propertyKey);
            if (null == value && !ERXValueUtilities.booleanValueWithDefault((Object)d2wContext.valueForKey("allowsEmptyQueryValue"), (boolean)true)) {
                throw ERXValidationFactory.defaultFactory().createCustomException(null, propertyKey, value, "QueryValueRequired");
            }
            EOAttribute attribute = null;
            if (ERXValueUtilities.booleanValue((Object)d2wContext.valueForKey("isAttribute"))) {
                attribute = d2wContext.attribute();
            } else {
                String keyWhenRelationship;
                EORelationship relationship = d2wContext.relationship();
                if (relationship != null && !(value instanceof EOEnterpriseObject) && (keyWhenRelationship = (String)d2wContext.valueForKey("keyWhenRelationship")) != null) {
                    EOEntity destinationEntity = relationship.destinationEntity();
                    attribute = destinationEntity.attributeNamed(keyWhenRelationship);
                }
            }
            if (attribute != null) {
                String valueClassName = attribute.className();
                if (String.class.getName().equals(valueClassName) && value instanceof String) {
                    this.validateStringValueForKey((String)value, propertyKey);
                } else if (Number.class.getName().equals(valueClassName) || BigDecimal.class.getName().equals(valueClassName)) {
                    this.validateNumericValueForKey((Number)value, propertyKey);
                }
            }
        }
    }

    public static interface ErrorKeys {
        public static final String QueryEmpty = "QueryEmpty";
        public static final String QueryValueRequired = "QueryValueRequired";
        public static final String QueryValueTooShort = "QueryValueTooShort";
        public static final String QueryValueTooLong = "QueryValueTooLong";
        public static final String QueryValueTooSmall = "QueryValueTooSmall";
        public static final String QueryValueTooLarge = "QueryValueTooLarge";
    }

    public static interface ValidationKeys {
        public static final String AllowsEmptyQuery = "allowsEmptyQuery";
        public static final String AllowsEmptyQueryValue = "allowsEmptyQueryValue";
        public static final String MaximumInputLength = "maximumInputLength";
        public static final String MinimumInputLength = "minimumInputLength";
        public static final String MaximumInputValue = "maximumInputValue";
        public static final String MinimumInputValue = "minimumInputValue";
    }
}

