/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.pages;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.directtoweb.ConfirmPageInterface;
import com.webobjects.directtoweb.D2W;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.directtoweb.D2WListPage;
import com.webobjects.directtoweb.EditPageInterface;
import com.webobjects.directtoweb.InspectPageInterface;
import com.webobjects.directtoweb.ListPageInterface;
import com.webobjects.directtoweb.NextPageDelegate;
import com.webobjects.directtoweb.SelectPageInterface;
import com.webobjects.eoaccess.EODatabaseDataSource;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.directtoweb.ERD2WFactory;
import er.directtoweb.delegates.ERDDeletionDelegate;
import er.directtoweb.interfaces.ERDEditObjectDelegate;
import er.directtoweb.interfaces.ERDListPageInterface;
import er.directtoweb.pages.ERD2WPage;
import er.extensions.ERXExtensions;
import er.extensions.appserver.ERXComponentActionRedirector;
import er.extensions.appserver.ERXDisplayGroup;
import er.extensions.appserver.ERXSession;
import er.extensions.batching.ERXBatchingDisplayGroup;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;
import er.extensions.statistics.ERXStats;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERD2WListPage
extends ERD2WPage
implements ERDListPageInterface,
SelectPageInterface,
ERXComponentActionRedirector.Restorable {
    public static final Logger log = Logger.getLogger(ERD2WListPage.class);
    protected boolean _shouldRefetch;
    protected String _sessionID;
    protected WODisplayGroup _displayGroup;
    public boolean _hasToUpdate = false;
    protected boolean _rowFlip = false;
    private boolean _hasBeenInitialized = false;
    private Number _batchSize = null;
    protected Object dataSourceState;
    private String _formTargetJavaScriptUrl;
    public EOEnterpriseObject referenceEO;
    private NSArray _referenceEOs;

    public ERD2WListPage(WOContext c) {
        super(c);
        this._sessionID = c.session().sessionID();
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("editingContextDidSaveChanges", ERXConstant.NotificationClassArray), "EOEditingContextDidSaveChangesNotification", null);
    }

    @Override
    public WODisplayGroup displayGroup() {
        if (this._displayGroup == null) {
            this.createDisplayGroup();
            this._displayGroup.setSelectsFirstObjectAfterFetch(false);
            if (ERD2WFactory.erFactory().defaultListPageDisplayGroupDelegate() != null) {
                this._displayGroup.setDelegate(ERD2WFactory.erFactory().defaultListPageDisplayGroupDelegate());
            }
        }
        return this._displayGroup;
    }

    protected void createDisplayGroup() {
        boolean useBatchingDisplayGroup = this.useBatchingDisplayGroup();
        this._displayGroup = useBatchingDisplayGroup ? new ERXBatchingDisplayGroup() : new ERXDisplayGroup();
    }

    public boolean useBatchingDisplayGroup() {
        return ERXValueUtilities.booleanValue((Object)this.d2wContext().valueForKey("useBatchingDisplayGroup"));
    }

    public String sessionID() {
        return this._sessionID;
    }

    public void editingContextDidSaveChanges(NSNotification notif) {
        if (this.sessionID() == ERXSession.currentSessionID()) {
            this._hasToUpdate = true;
        }
    }

    @Override
    public boolean isEntityReadOnly() {
        boolean flag = super.isEntityReadOnly();
        flag = !ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey("isEntityEditable"), (!flag ? 1 : 0) != 0);
        flag = ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey("readOnly"), (boolean)flag);
        return flag;
    }

    @Override
    public boolean isEntityEditable() {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey("isEntityEditable"), (boolean)false);
    }

    public boolean alwaysRefetchList() {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey("alwaysRefetchList"), (boolean)true);
    }

    public boolean isSelecting() {
        return this.task().equals("select");
    }

    public boolean isListEmpty() {
        return this.listSize() == 0;
    }

    public int listSize() {
        return this.displayGroup().allObjects().count();
    }

    public String alternatingColorForRow() {
        boolean bl = this._rowFlip = !this._rowFlip;
        if (this._rowFlip || !this.alternateRowColor()) {
            return this.backgroundColorForTable();
        }
        return this.backgroundColorForTableDark();
    }

    public String backgroundColorForRow() {
        return !this.isSelecting() || this.selectedObjects().containsObject((Object)this.object()) ? this.alternatingColorForRow() : "#FFFF00";
    }

    public void setBackgroundColorForRow(String value) {
    }

    public EOEnterpriseObject selectedObject() {
        return (EOEnterpriseObject)this.displayGroup().selectedObject();
    }

    public void setSelectedObject(EOEnterpriseObject eo) {
        if (eo != null) {
            this.displayGroup().selectObject((Object)eo);
        } else {
            this.displayGroup().clearSelection();
        }
    }

    public NSArray selectedObjects() {
        return this.displayGroup().selectedObjects();
    }

    public void setSelectedObjects(NSArray eos) {
        if (eos != null) {
            this.displayGroup().setSelectedObjects(eos);
        } else {
            this.displayGroup().clearSelection();
        }
    }

    public WOComponent selectObjectAction() {
        this.setSelectedObject(this.object());
        WOComponent result = this.nextPageFromDelegate();
        return result;
    }

    public WOComponent backAction() {
        WOComponent result = this.nextPageFromDelegate();
        if (result == null && (result = this.nextPage()) == null) {
            result = (WOComponent)D2W.factory().queryPageForEntityNamed(this.entity().name(), this.session());
        }
        return result;
    }

    @Override
    public String urlForCurrentState() {
        return this.context().directActionURLForActionNamed(this.d2wContext().dynamicPage(), null).replaceAll("&amp;", "&");
    }

    protected void setSortOrderingsOnDisplayGroup(NSArray sortOrderings, WODisplayGroup dg) {
        sortOrderings = sortOrderings != null ? sortOrderings : NSArray.EmptyArray;
        dg.setSortOrderings(sortOrderings);
    }

    public static WOComponent printerFriendlyVersion(D2WContext d2wContext, WOSession session, EODataSource dataSource, WODisplayGroup displayGroup) {
        ListPageInterface result = (ListPageInterface)ERD2WFactory.erFactory().printerFriendlyPageForD2WContext(d2wContext, session);
        result.setDataSource(dataSource);
        WODisplayGroup dg = null;
        if (result instanceof D2WListPage) {
            dg = ((D2WListPage)result).displayGroup();
        } else if (result instanceof ERDListPageInterface) {
            dg = ((ERDListPageInterface)result).displayGroup();
        } else {
            try {
                dg = (WODisplayGroup)((WOComponent)result).valueForKey("displayGroup");
            }
            catch (Exception ex) {
                log.warn((Object)("Can't get displayGroup from page of class: " + result.getClass().getName()));
            }
        }
        if (dg != null) {
            dg.setSortOrderings(displayGroup.sortOrderings());
            dg.setNumberOfObjectsPerBatch(displayGroup.allObjects().count());
            dg.updateDisplayedObjects();
        }
        return (WOComponent)result;
    }

    public WOComponent printerFriendlyVersion() {
        return ERD2WListPage.printerFriendlyVersion(this.d2wContext(), this.session(), this.dataSource(), this.displayGroup());
    }

    @Override
    public String descriptionForResponse(WOResponse aResponse, WOContext aContext) {
        String descriptionForResponse = (String)this.d2wContext().valueForKey("pageConfiguration");
        return descriptionForResponse != null ? descriptionForResponse : super.descriptionForResponse(aResponse, aContext);
    }

    public int numberOfObjectsPerBatch() {
        if (this._batchSize == null) {
            if (this.shouldShowBatchNavigation()) {
                int batchSize = ERXValueUtilities.intValueWithDefault((Object)this.d2wContext().valueForKey("defaultBatchSize"), (int)0);
                Object batchSizePref = this.userPreferencesValueForPageConfigurationKey("batchSize");
                if (batchSizePref != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("batchSize User Preference: " + batchSizePref));
                    }
                    batchSize = ERXValueUtilities.intValueWithDefault((Object)batchSizePref, (int)batchSize);
                }
                this._batchSize = ERXConstant.integerForInt((int)batchSize);
            } else {
                this._batchSize = ERXConstant.ZeroInteger;
            }
        }
        return this._batchSize.intValue();
    }

    public boolean userPreferencesCanSpecifySorting() {
        return !"printerFriendly".equals(this.d2wContext().valueForKey("subTask"));
    }

    public boolean checkSortOrderingKeys() {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey("checkSortOrderingKeys"), (boolean)false);
    }

    protected boolean isValidSortKey(NSArray displayPropertyKeys, String sortKey) {
        boolean validSortOrdering = false;
        try {
            if (displayPropertyKeys.containsObject((Object)sortKey) || this.entity().anyAttributeNamed(sortKey) != null || ERXEOAccessUtilities.attributePathForKeyPath((EOEntity)this.entity(), (String)sortKey).count() > 0) {
                validSortOrdering = true;
            }
        }
        catch (IllegalArgumentException e) {
            validSortOrdering = false;
        }
        if (!validSortOrdering) {
            log.warn((Object)("Sort key '" + sortKey + "' is not in display keys, attributes or non-flattened key paths for the entity '" + this.entity().name() + "'."));
            validSortOrdering = false;
        }
        return validSortOrdering;
    }

    public NSArray<EOSortOrdering> sortOrderings() {
        NSArray sortOrderingDefinition;
        NSArray sortOrderings = null;
        if (this.userPreferencesCanSpecifySorting()) {
            sortOrderings = (NSArray)this.userPreferencesValueForPageConfigurationKey("sortOrdering");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found sort Orderings in user prefs " + sortOrderings));
            }
        }
        if (sortOrderings == null && (sortOrderingDefinition = (NSArray)this.d2wContext().valueForKey("defaultSortOrdering")) != null) {
            NSMutableArray validatedSortOrderings = new NSMutableArray();
            NSArray displayPropertyKeys = (NSArray)this.d2wContext().valueForKey("displayPropertyKeys");
            int i = 0;
            while (i < sortOrderingDefinition.count()) {
                String sortKey = (String)sortOrderingDefinition.objectAtIndex(i++);
                String sortSelectorKey = (String)sortOrderingDefinition.objectAtIndex(i++);
                if (this.checkSortOrderingKeys() && !this.isValidSortKey(displayPropertyKeys, sortKey)) continue;
                EOSortOrdering sortOrdering = new EOSortOrdering(sortKey, ERXArrayUtilities.sortSelectorWithKey((String)sortSelectorKey));
                validatedSortOrderings.addObject((Object)sortOrdering);
            }
            sortOrderings = validatedSortOrderings;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found sort Orderings in rules " + sortOrderings));
            }
        }
        return sortOrderings;
    }

    public String defaultSortKey() {
        return null;
    }

    @Override
    public void takeValuesFromRequest(WORequest r, WOContext c) {
        this.setupPhase();
        super.takeValuesFromRequest(r, c);
    }

    protected void _fetchDisplayGroup(WODisplayGroup dg) {
        String statsKey = super.makeStatsKey("DisplayGroup Fetch");
        ERXStats.markStart((String)"SQL", (String)statsKey);
        try {
            dg.fetch();
        }
        catch (NSKeyValueCoding.UnknownKeyException e) {
            if (dg.sortOrderings() != null && dg.sortOrderings().count() > 0) {
                log.error((Object)"Fetching display group failed. Resetting potentially bogus sort orderings and trying again.", (Throwable)e);
                dg.setSortOrderings(null);
                dg.fetch();
            }
            throw e;
        }
        ERXStats.markEnd((String)"SQL", (String)statsKey);
    }

    protected void fetchIfNecessary() {
        if (this._hasToUpdate) {
            this.willUpdate();
            this._fetchDisplayGroup(this.displayGroup());
            this._hasToUpdate = false;
            this.didUpdate();
        }
    }

    @Override
    public WOActionResults invokeAction(WORequest r, WOContext c) {
        this.setupPhase();
        this.fetchIfNecessary();
        return super.invokeAction(r, c);
    }

    @Override
    public void appendToResponse(WOResponse r, WOContext c) {
        this.setupPhase();
        this._rowFlip = true;
        this.fetchIfNecessary();
        if (this.displayGroup() != null && this.displayGroup().currentBatchIndex() > this.displayGroup().batchCount()) {
            this.displayGroup().setCurrentBatchIndex(1);
        }
        super.appendToResponse(r, c);
    }

    @Override
    public void setDataSource(EODataSource eodatasource) {
        EODatabaseDataSource ds = eodatasource instanceof EODatabaseDataSource ? (EODatabaseDataSource)eodatasource : null;
        String newDataSourceState = null;
        if (ds != null) {
            newDataSourceState = ds.fetchSpecification().toString().replaceAll("\\n", "") + ":" + ds.fetchSpecificationForFetch().toString().replaceAll("\\n", "") + " fetchLimit: " + ds.fetchSpecification().fetchLimit() + ", " + ds.fetchSpecificationForFetch().fetchLimit();
        }
        EODataSource old = this.displayGroup().dataSource();
        super.setDataSource(eodatasource);
        this.displayGroup().setDataSource(eodatasource);
        if (ds == null || this.dataSourceState == null || this.dataSourceState != null && !this.dataSourceState.equals(newDataSourceState) || this.alwaysRefetchList()) {
            log.debug((Object)("updating:\n" + this.dataSourceState + " vs\n" + newDataSourceState));
            this.dataSourceState = newDataSourceState;
            this._hasToUpdate = true;
            if (old != null && eodatasource != null && ERXExtensions.safeDifferent((Object)eodatasource.classDescriptionForObjects(), (Object)old.classDescriptionForObjects())) {
                this.setSortOrderingsOnDisplayGroup(this.sortOrderings(), this.displayGroup());
            }
        }
    }

    protected void willUpdate() {
    }

    protected void didUpdate() {
    }

    protected void setupPhase() {
        WODisplayGroup dg = this.displayGroup();
        if (dg != null) {
            EOFetchSpecification fs;
            NSArray<EOSortOrdering> sortOrderings = dg.sortOrderings();
            EODataSource ds = this.dataSource();
            if (!this._hasBeenInitialized) {
                log.debug((Object)"Initializing display group");
                String fetchspecName = (String)this.d2wContext().valueForKey("restrictingFetchSpecification");
                if (fetchspecName != null && ds instanceof EODatabaseDataSource) {
                    EOFetchSpecification fs2 = ((EODatabaseDataSource)ds).entity().fetchSpecificationNamed(fetchspecName);
                    if (fs2 != null) {
                        fs2 = (EOFetchSpecification)fs2.clone();
                    }
                    ((EODatabaseDataSource)ds).setFetchSpecification(fs2);
                }
                if (sortOrderings == null) {
                    sortOrderings = this.sortOrderings();
                    this.setSortOrderingsOnDisplayGroup(sortOrderings, dg);
                }
                dg.setNumberOfObjectsPerBatch(this.numberOfObjectsPerBatch());
                this._fetchDisplayGroup(dg);
                dg.updateDisplayedObjects();
                this._hasBeenInitialized = true;
                this._hasToUpdate = false;
            }
            if (sortOrderings != null && ds instanceof EODatabaseDataSource && !(fs = ((EODatabaseDataSource)ds).fetchSpecification()).sortOrderings().equals((Object)sortOrderings) && (fs.fetchLimit() != 0 || this.useBatchingDisplayGroup())) {
                fs.setSortOrderings(sortOrderings);
                this._hasToUpdate = this._hasToUpdate ? true : this.alwaysRefetchList();
            }
            log.debug((Object)("dg.currentBatchIndex() " + dg.currentBatchIndex()));
            dg.setCurrentBatchIndex(dg.currentBatchIndex());
            if (this.listSize() > 0 && this.displayGroup().selectsFirstObjectAfterFetch()) {
                this.d2wContext().takeValueForKey(dg.allObjects().objectAtIndex(0), "object");
            }
        }
    }

    public boolean isEntityInspectable() {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey("isEntityInspectable"), (boolean)this.isEntityReadOnly());
    }

    public boolean isEntityPrintable() {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey("isEntityPrintable"), (boolean)false);
    }

    public WOComponent deleteObjectAction() {
        ConfirmPageInterface nextPage;
        String confirmDeleteConfigurationName = (String)this.d2wContext().valueForKey("confirmDeleteConfigurationName");
        if (confirmDeleteConfigurationName == null) {
            log.warn((Object)"Using default delete template: ERD2WConfirmPageTemplate, set the 'confirmDeleteConfigurationName' key to something more sensible");
            nextPage = (ConfirmPageInterface)this.pageWithName("ERD2WConfirmPageTemplate");
        } else {
            nextPage = (ConfirmPageInterface)D2W.factory().pageForConfigurationNamed(confirmDeleteConfigurationName, this.session());
        }
        nextPage.setConfirmDelegate((NextPageDelegate)new ERDDeletionDelegate(this.object(), this.dataSource(), this.context().page()));
        nextPage.setCancelDelegate((NextPageDelegate)new ERDDeletionDelegate(null, null, this.context().page()));
        if (nextPage instanceof InspectPageInterface) {
            ((InspectPageInterface)nextPage).setObject(this.object());
        } else {
            String message = ERXLocalizer.currentLocalizer().localizedTemplateStringForKeyWithObject("ERD2WList.confirmDeletionMessage", (Object)this.d2wContext());
            nextPage.setMessage(message);
        }
        return (WOComponent)nextPage;
    }

    public WOComponent editObjectAction() {
        WOComponent result = null;
        ERDEditObjectDelegate editObjectDelegate = null;
        String editConfigurationName = (String)this.d2wContext().valueForKey("editConfigurationName");
        EOEnterpriseObject leo = this.localInstanceOfObject();
        log.debug((Object)("editConfigurationName: " + editConfigurationName));
        editObjectDelegate = this.editObjectDelegateInstance();
        if (editObjectDelegate != null) {
            result = editObjectDelegate.editObject(leo, this.context().page());
        } else {
            EditPageInterface epi = editConfigurationName != null ? (EditPageInterface)D2W.factory().pageForConfigurationNamed(editConfigurationName, this.session()) : D2W.factory().editPageForEntityNamed(this.object().entityName(), this.session());
            epi.setObject(leo);
            epi.setNextPage(this.context().page());
            result = (WOComponent)epi;
        }
        return result;
    }

    public WOComponent inspectObjectAction() {
        String inspectConfigurationName = (String)this.d2wContext().valueForKey("inspectConfigurationName");
        log.debug((Object)("inspectConfigurationName: " + inspectConfigurationName));
        InspectPageInterface ipi = inspectConfigurationName != null ? (InspectPageInterface)D2W.factory().pageForConfigurationNamed(inspectConfigurationName, this.session()) : D2W.factory().inspectPageForEntityNamed(this.object().entityName(), this.session());
        ipi.setObject(this.object());
        ipi.setNextPage(this.context().page());
        return (WOComponent)ipi;
    }

    protected EOEnterpriseObject localInstanceOfObject() {
        Object value = this.d2wContext().valueForKey("useNestedEditingContext");
        boolean createNestedContext = ERXValueUtilities.booleanValue((Object)value);
        return ERXEOControlUtilities.editableInstanceOfObject((EOEnterpriseObject)this.object(), (boolean)createNestedContext);
    }

    @Override
    public boolean showCancel() {
        return this.nextPage() != null;
    }

    public boolean isSelectingNotTopLevel() {
        boolean result = false;
        if (this.isSelecting() && this.context().page() != this) {
            result = true;
        }
        return result;
    }

    public String formTargetJavaScriptUrl() {
        if (this._formTargetJavaScriptUrl == null) {
            this._formTargetJavaScriptUrl = this.application().resourceManager().urlForResourceNamed("formTarget.js", "ERDirectToWeb", null, this.context().request());
        }
        return this._formTargetJavaScriptUrl;
    }

    public String targetString() {
        String result = "";
        NSDictionary targetDictionary = (NSDictionary)this.d2wContext().valueForKey("targetDictionary");
        if (targetDictionary != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(targetDictionary.valueForKey("targetName") != null ? targetDictionary.valueForKey("targetName") : "foobar");
            buffer.append(":width=");
            buffer.append(targetDictionary.valueForKey("width") != null ? targetDictionary.valueForKey("width") : "{window.screen.width/2}");
            buffer.append(", height=");
            buffer.append(targetDictionary.valueForKey("height") != null ? targetDictionary.valueForKey("height") : "{myHeight}");
            buffer.append(",");
            buffer.append(targetDictionary.valueForKey("scrollbars") != null && targetDictionary.valueForKey("scrollbars") == "NO" ? " " : "scrollbars");
            buffer.append(", {(isResizable)?'resizable':''}, status");
            result = buffer.toString();
        } else {
            result = "foobar:width={window.screen.width/2}, height={myHeight}, scrollbars, {(isResizable)?'resizable':''}, status";
        }
        return result;
    }

    public boolean shouldShowSelectAll() {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey("shouldShowSelectAll"), (this.listSize() > 10 ? 1 : 0) != 0);
    }

    public void warmUpForDisplay() {
    }

    public String colorForRow() {
        String result = null;
        if (this.d2wContext().valueForKey("referenceRelationshipForBackgroupColor") != null) {
            String path = (String)this.d2wContext().valueForKey("referenceRelationshipForBackgroupColor") + ".backgroundColor";
            result = (String)this.object().valueForKeyPath(path);
        }
        return result;
    }

    public NSArray referenceEOs() {
        String relationshipName;
        if (this._referenceEOs == null && (relationshipName = (String)this.d2wContext().valueForKey("referenceRelationshipForBackgroupColor")) != null) {
            EOEntity entity = EOModelGroup.defaultGroup().entityNamed(this.entityName());
            EORelationship relationship = entity.relationshipNamed(relationshipName);
            this._referenceEOs = EOUtilities.objectsForEntityNamed((EOEditingContext)EOSharedEditingContext.defaultSharedEditingContext(), (String)relationship.destinationEntity().name());
            this._referenceEOs = ERXArrayUtilities.sortedArraySortedWithKey((NSArray)this._referenceEOs, (String)"ordering", (NSSelector)EOSortOrdering.CompareAscending);
        }
        return this._referenceEOs;
    }

    public boolean shouldShowBatchNavigation() {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey("showBatchNavigation"), (boolean)true);
    }

    private ERDEditObjectDelegate editObjectDelegateInstance() {
        ERDEditObjectDelegate delegate = null;
        String delegateClassName = (String)this.d2wContext().valueForKey("editObjectDelegateClass");
        if (delegateClassName != null) {
            try {
                Class<?> delegateClass = Class.forName(delegateClassName);
                Constructor<?> delegateClassConstructor = delegateClass.getConstructor(WOContext.class);
                delegate = (ERDEditObjectDelegate)delegateClassConstructor.newInstance(this.context());
            }
            catch (LinkageError le) {
                if (le instanceof ExceptionInInitializerError) {
                    log.warn((Object)("Could not initialize edit object delegate class: " + delegateClassName));
                } else {
                    log.warn((Object)("Could not load  delegate class: " + delegateClassName + " due to: " + le.getMessage()));
                }
            }
            catch (ClassNotFoundException cnfe) {
                log.warn((Object)("Could not find class for edit object delegate: " + delegateClassName));
            }
            catch (NoSuchMethodException nsme) {
                log.warn((Object)("Could not find constructor for edit object delegate class: " + delegateClassName));
            }
            catch (SecurityException se) {
                log.warn((Object)("Insufficient privileges to access edit object delegate constructor: " + delegateClassName));
            }
            catch (IllegalAccessException iae) {
                log.warn((Object)("Insufficient access to create edit object delegate instance: " + iae.getMessage()));
            }
            catch (IllegalArgumentException iae) {
                log.warn((Object)("Used an illegal argument when creating edit object delegate instance: " + iae.getMessage()));
            }
            catch (InstantiationException ie) {
                log.warn((Object)("Could not instantiate edit object delegate instance: " + ie.getMessage()));
            }
            catch (InvocationTargetException ite) {
                log.warn((Object)("Exception while invoking edit object delegate constructor: " + ite.getMessage()));
            }
        }
        return delegate;
    }
}

