/*
 * Decompiled with CFR 0.152.
 */
package er.uber.components;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.eocontrol.EOEditingContext;
import er.uber.components.UberComponent;
import er.uber.model.Company;
import junit.framework.Assert;

public class CharacterEncoding
extends UberComponent {
    private String _initialCompanyName = "\u6c49\u8bed/\u6f22\u8a9e";
    private String _initialFormValue;
    private Company _company;
    public String _value = this._initialFormValue = "\u5ba2\u5bb6\u8a71";

    public CharacterEncoding(WOContext context) {
        super(context);
    }

    public Company company() {
        if (this._company == null) {
            EOEditingContext editingContext = this.editingContext();
            this._company = Company.createCompany(editingContext, this._initialCompanyName);
        }
        return this._company;
    }

    public WOActionResults testFormSubmit() {
        Assert.assertEquals((String)(this._value + " should have been " + this._initialFormValue + " after the form submit."), (String)this._initialFormValue, (String)this._value);
        return null;
    }

    public WOActionResults testCompany() {
        EOEditingContext editingContext = this.editingContext();
        Company company = this.company();
        Assert.assertEquals((String)("Company name should have been " + this._initialCompanyName + " before we save to the database."), (String)this._initialCompanyName, (String)company.name());
        editingContext.saveChanges();
        Company reloadCompany = (Company)company.refetchObjectFromDBinEditingContext(this.editingContext());
        Assert.assertEquals((String)("Company name should have been " + this._initialCompanyName + " after saving and refetching from the database."), (String)this._initialCompanyName, (String)reloadCompany.name());
        String newName = "\u5317\u65b9\u8a71 " + System.currentTimeMillis();
        reloadCompany.setName(newName);
        this.editingContext().saveChanges();
        Company updateCompany = (Company)this._company.refetchObjectFromDBinEditingContext(this.editingContext());
        Assert.assertEquals((String)("Company name should have been " + newName + " after updating and refetching from the database."), (String)newName, (String)updateCompany.name());
        Company fetchCompany = Company.fetchCompany(editingContext, Company.NAME_KEY, newName);
        Assert.assertNotNull((String)("There should have been a Company named " + newName + " after updating and refetching from the database."), (Object)((Object)fetchCompany));
        Assert.assertEquals((String)("There should have been a Company named " + newName + " after updating and refetching from the database."), (String)newName, (String)fetchCompany.name());
        updateCompany.delete();
        editingContext.saveChanges();
        this._company = null;
        return null;
    }
}

