/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSReflectionUtilities;
import com.webobjects.foundation._NSThreadsafeMutableSet;
import com.webobjects.foundation._NSUtilities;
import java.lang.reflect.Method;

public interface NSValidation {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSValidation");

    public Object validateValueForKey(Object var1, String var2) throws ValidationException;

    public Object validateTakeValueForKeyPath(Object var1, String var2) throws ValidationException;

    public static class DefaultImplementation {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSValidation$DefaultImplementation");
        private static final _NSThreadsafeMutableSet _validationBindings = new _NSThreadsafeMutableSet(new NSMutableSet(256));

        DefaultImplementation() {
            throw new IllegalStateException("Cannot instantiate an instance of class " + this.getClass().getName());
        }

        public static void _flushCaches() {
            _validationBindings.removeAllObjects();
        }

        public static Object validateValueForKey(Object object, Object value, String key) throws ValidationException {
            return DefaultImplementation._validateValueForKey(object, value, key, null);
        }

        public static Object _validateValueForKey(Object object, Object value, String key, Class valueBaseInterfaceHint) throws ValidationException {
            if (key == null) {
                return value;
            }
            Class<?> objectClass = object.getClass();
            _ValidationBinding validationBinding = (_ValidationBinding)_validationBindings.member(new _ValidationBinding(objectClass, key));
            if (validationBinding == null) {
                Method method = _NSReflectionUtilities._keyManipulationMethodWithPrefix(objectClass, "validate", key, value != null ? value.getClass() : null, valueBaseInterfaceHint);
                validationBinding = method != null ? new _MethodBinding(objectClass, key, method) : new _ValidationBinding(objectClass, key);
                _validationBindings.addObject(validationBinding);
            }
            return validationBinding.validateValueOnObject(value, object);
        }

        public static Object validateTakeValueForKeyPath(Object object, Object value, String keyPath) throws ValidationException {
            if (keyPath == null) {
                throw new IllegalArgumentException("Key path cannot be null");
            }
            int index = keyPath.indexOf(46);
            if (index < 0) {
                value = Utility.validateValueForKey(object, value, keyPath);
                Object currentValue = NSKeyValueCoding.Utility.valueForKey(object, keyPath);
                if (!(currentValue == value || value != null && currentValue != null && value.equals(currentValue))) {
                    NSKeyValueCoding.Utility.takeValueForKey(object, value, keyPath);
                }
                return value;
            }
            String key = keyPath.substring(0, index);
            return (object = NSKeyValueCoding.Utility.valueForKey(object, key)) != null ? Utility.validateTakeValueForKeyPath(object, value, keyPath.substring(index + 1)) : null;
        }
    }

    public static class _MethodBinding
    extends _ValidationBinding {
        protected Method _method;

        public _MethodBinding(Class targetClass, String key, Method method) {
            super(targetClass, key);
            this._method = method;
        }

        public Object validateValueOnObject(Object value, Object object) throws ValidationException {
            return _NSReflectionUtilities._invokeMethodOnObject(object, this._method, new Object[]{value});
        }

        public String toString() {
            return super.toString() + ", method = " + (this._method != null ? this._method.toString() : "<NULL>");
        }
    }

    public static class _ValidationBinding {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSValidation$_ValidationBinding");
        protected Class _targetClass;
        protected String _key;
        private int _hashCode;

        public _ValidationBinding(Class targetClass, String key) {
            this._targetClass = targetClass;
            this._key = key;
            this._hashCode = targetClass != null && this._key != null ? this._targetClass.hashCode() ^ this._key.hashCode() : 0;
        }

        public final Class targetClass() {
            return this._targetClass;
        }

        public final String key() {
            return this._key;
        }

        public final int hashCode() {
            return this._hashCode;
        }

        public final boolean isEqualToValidationBinding(_ValidationBinding otherValidationBinding) {
            if (otherValidationBinding == null) {
                return false;
            }
            if (otherValidationBinding == this) {
                return true;
            }
            return this._targetClass == otherValidationBinding._targetClass && (this._key == otherValidationBinding._key || this._key.equals(otherValidationBinding._key));
        }

        public final boolean equals(Object object) {
            return object instanceof _ValidationBinding ? this.isEqualToValidationBinding((_ValidationBinding)object) : false;
        }

        public Object validateValueOnObject(Object value, Object object) throws ValidationException {
            return value;
        }

        public String toString() {
            return this.getClass().getName() + ": target class = " + (this._targetClass != null ? this._targetClass.getName() : "<NULL>") + ", key = " + (this._key != null ? this._key : "<NULL>");
        }
    }

    public static class Utility {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSValidation$Utility");

        Utility() {
            throw new IllegalStateException("Cannot instantiate an instance of class " + this.getClass().getName());
        }

        public static Object validateValueForKey(Object object, Object value, String key) throws ValidationException {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof NSValidation) {
                return ((NSValidation)object).validateValueForKey(value, key);
            }
            return DefaultImplementation.validateValueForKey(object, value, key);
        }

        public static Object validateTakeValueForKeyPath(Object object, Object value, String keyPath) throws ValidationException {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof NSValidation) {
                return ((NSValidation)object).validateTakeValueForKeyPath(value, keyPath);
            }
            return DefaultImplementation.validateTakeValueForKeyPath(object, value, keyPath);
        }
    }

    public static class ValidationException
    extends RuntimeException {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSValidation$ValidationException");
        public static final String ValidatedObjectUserInfoKey = "NSValidatedObjectUserInfoKey";
        public static final String ValidatedKeyUserInfoKey = "NSValidatedKeyUserInfoKey";
        public static final String AdditionalExceptionsKey = "NSAdditionalExceptionsKey";
        private NSDictionary _userInfo;

        public static ValidationException aggregateExceptionWithExceptions(NSArray aggregateExceptions) {
            int count;
            if (aggregateExceptions != null && (count = aggregateExceptions.count()) > 0) {
                ValidationException exception = (ValidationException)aggregateExceptions.objectAtIndex(0);
                if (count == 1) {
                    return exception;
                }
                NSMutableArray exceptions = new NSMutableArray(count);
                NSArray additionalExceptions = exception.additionalExceptions();
                if (additionalExceptions != null && additionalExceptions.count() > 0) {
                    exceptions.addObjectsFromArray(additionalExceptions);
                }
                for (int i = 1; i < count; ++i) {
                    ValidationException otherException = (ValidationException)aggregateExceptions.objectAtIndex(i);
                    exceptions.addObject(otherException);
                    additionalExceptions = otherException.additionalExceptions();
                    if (additionalExceptions == null || additionalExceptions.count() <= 0) continue;
                    exceptions.addObjectsFromArray(additionalExceptions);
                }
                NSDictionary userInfo = exception.userInfo();
                NSMutableDictionary dictionary = null;
                dictionary = userInfo != null ? (userInfo instanceof NSMutableDictionary ? (NSMutableDictionary)userInfo : new NSMutableDictionary(userInfo)) : new NSMutableDictionary(1);
                dictionary.setObjectForKey(exceptions, AdditionalExceptionsKey);
                exception._userInfo = dictionary;
                return exception;
            }
            return null;
        }

        public ValidationException(String message) {
            this(message, (NSDictionary)null);
        }

        public ValidationException(String message, Object object, String key) {
            super(message);
            NSMutableDictionary dictionary = new NSMutableDictionary(2);
            if (object != null) {
                dictionary.setObjectForKey(object, ValidatedObjectUserInfoKey);
            }
            if (key != null) {
                dictionary.setObjectForKey(key, ValidatedKeyUserInfoKey);
            }
            this._userInfo = dictionary;
        }

        public ValidationException(String message, NSDictionary userInfo) {
            super(message);
            this._userInfo = userInfo != null ? (NSDictionary)userInfo.clone() : NSDictionary.EmptyDictionary;
        }

        public Object object() {
            return this.userInfo().objectForKey(ValidatedObjectUserInfoKey);
        }

        public String key() {
            return (String)this.userInfo().objectForKey(ValidatedKeyUserInfoKey);
        }

        public NSArray additionalExceptions() {
            return (NSArray)this.userInfo().objectForKey(AdditionalExceptionsKey);
        }

        public NSDictionary userInfo() {
            return this._userInfo;
        }

        public ValidationException exceptionAddingEntriesToUserInfo(Object object, String key) {
            return this.exceptionWithObjectAndKey(object, key);
        }

        public ValidationException exceptionWithObjectAndKey(Object object, String key) {
            NSMutableDictionary dictionary;
            NSDictionary userInfo = this.userInfo();
            NSMutableDictionary nSMutableDictionary = dictionary = userInfo != null ? new NSMutableDictionary(userInfo) : new NSMutableDictionary(2);
            if (object != null) {
                dictionary.setObjectForKey(object, ValidatedObjectUserInfoKey);
            }
            if (key != null) {
                dictionary.setObjectForKey(key, ValidatedKeyUserInfoKey);
            }
            this._userInfo = dictionary;
            return this;
        }
    }
}

