/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.io.LittleEndianInputStream;
import org.walluck.oscar.AIMPopup;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.Ad;
import org.walluck.oscar.CapabilityBlock;
import org.walluck.oscar.Chat;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.ODirInfo;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.directim.DirectIMHeader;
import org.walluck.oscar.handlers.filetransfer.FTTLV;
import org.walluck.oscar.handlers.filetransfer.FileHeader;
import org.walluck.oscar.handlers.filetransfer.GetFileEntry;
import org.walluck.oscar.handlers.filetransfer.GetFileList;
import org.walluck.oscar.handlers.icq.ICQColor;
import org.walluck.oscar.handlers.proxy.ProxyPacket;

public class AIMInputStream
extends LittleEndianInputStream {
    private static final Logger LOG = Logger.getLogger((String)AIMInputStream.class.getName());
    private static final byte ASTERISK = 42;

    public AIMInputStream(InputStream is) {
        super(is);
    }

    public FLAP readFLAP() throws IOException {
        byte command = this.readByte();
        if (command != 42) {
            throw new IOException("Invalid start marker " + Integer.toHexString(command));
        }
        byte channel = this.readByte();
        short seqNum = this.readShort();
        short length = this.readShort();
        return new FLAP(command, channel, seqNum, length);
    }

    public SNAC readSNAC() throws IOException {
        short family = this.readShort();
        short subtype = this.readShort();
        short flags = this.readShort();
        int id = this.readInt();
        return new SNAC(family, subtype, flags, id);
    }

    public TLVChain readTLVChain(int length) throws IOException {
        int len;
        if (length == 0) {
            return null;
        }
        TLVChain tlvchain = new TLVChain();
        for (int i = 0; i < length; i += len) {
            short type = this.readShort();
            len = this.readShort();
            i += 4;
            if (type == 19 && length != 2) {
                len = 2;
            }
            byte[] value = this.readBytes(len);
            tlvchain.addTLV(new TLV(type, len, value));
        }
        return tlvchain;
    }

    public TLVChain readTLVChain() throws IOException {
        return this.readTLVChain(this.available());
    }

    public TLVChain readTLVChainByCount(int count) throws IOException {
        TLVChain tlvchain = new TLVChain();
        int i = 0;
        while (i++ < count) {
            short type = this.readShort();
            int length = this.readShort();
            if (type == 19 && length != 2) {
                length = 2;
            }
            byte[] value = this.readBytes(length);
            tlvchain.addTLV(new TLV(type, length, value));
        }
        return tlvchain;
    }

    public FTTLV readFTTLV() throws IOException {
        FTTLV fttlv = new FTTLV();
        fttlv.setSubtype(this.readShort());
        fttlv.setNumFiles(this.readShort());
        fttlv.setTotalSize(this.readInt());
        fttlv.setName(AIMUtil.dirAOLToSys(this.readStringUntilNull(32)));
        if (this.available() >= 2) {
            fttlv.setCharset(this.readShort());
        }
        if (this.available() >= 2) {
            fttlv.setCharSubset(this.readShort());
        }
        return fttlv;
    }

    public int readCaps(int length, boolean isShort) throws IOException {
        int capLength = isShort ? 2 : 16;
        if (length < capLength) {
            return 0;
        }
        int size = length / capLength;
        int flags = 0;
        for (int i = 0; i < size; ++i) {
            byte[] data = this.readBytes(capLength);
            CapabilityBlock cap = CapabilityBlock.getCapabilityBlock(data);
            if (cap != null) {
                flags |= cap.getFlag();
                continue;
            }
            LOG.warn((Object)("Unknown capability string=" + AIMUtil.byteArrayToHexString(data)));
        }
        return flags;
    }

    public int readCaps(int length) throws IOException {
        return this.readCaps(length, false);
    }

    public UserInfo readUserInfo() throws IOException {
        UserInfo info = new UserInfo();
        info.setSN(this.readStringL());
        info.setWarnLevel(this.readShort());
        short tlvCount = this.readShort();
        TLVChain tlvchain = this.readTLVChainByCount(tlvCount);
        Iterator i = tlvchain.iterator();
        while (i.hasNext()) {
            AIMInputStream buffer;
            TLV tlv = (TLV)i.next();
            if (tlv.getType() == 1) {
                info.setFlags(tlv.getValueShort());
                info.setPresent(info.getPresent() | 1);
                continue;
            }
            if (tlv.getType() == 2 || tlv.getType() == 5) {
                info.setMemberSince(tlv.getValueInt());
                info.setPresent(info.getPresent() | 2);
                continue;
            }
            if (tlv.getType() == 3) {
                info.setOnlineSince(tlv.getValueInt());
                info.setPresent(info.getPresent() | 4);
                continue;
            }
            if (tlv.getType() == 4) {
                info.setIdleTime(tlv.getValueShort());
                info.setPresent(info.getPresent() | 8);
                continue;
            }
            if (tlv.getType() == 6) {
                info.getIcqInfo().setStatus(tlv.getValueInt());
                info.setPresent(info.getPresent() | 0x10);
                continue;
            }
            if (tlv.getType() == 10) {
                info.getIcqInfo().setIP(tlv.getValueInt());
                info.setPresent(info.getPresent() | 0x20);
                continue;
            }
            if (tlv.getType() == 12) {
                int x2;
                buffer = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
                info.getIcqInfo().setInternalIP(buffer.readInt());
                info.getIcqInfo().setInternalPort(buffer.readInt());
                info.getIcqInfo().setTCPFlags(buffer.readByte());
                info.getIcqInfo().setTCPVersion(buffer.readShort());
                info.getIcqInfo().setTCPCookie(buffer.readInt());
                int x1 = buffer.readInt();
                if (x1 != 80) {
                    LOG.warn((Object)("X1 mismatch: " + x1 + " != " + 80));
                }
                if ((x2 = buffer.readInt()) != 3) {
                    LOG.warn((Object)("X2 mismatch: " + x2 + " != " + 3));
                }
                info.getIcqInfo().setTimeRecent(buffer.readInt());
                info.getIcqInfo().setTimeNow(buffer.readInt());
                info.getIcqInfo().setTimeNowUsually(buffer.readInt());
                info.getIcqInfo().setUnknown(buffer.readShort());
                info.setPresent(info.getPresent() | 0x40);
                continue;
            }
            if (tlv.getType() == 13) {
                buffer = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
                info.setCapabilities(buffer.readCaps(tlv.getLength()));
                info.setPresent(info.getPresent() | 0x80);
                continue;
            }
            if (tlv.getType() == 14) {
                buffer = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
                info.setCapabilities2(buffer.readCaps(tlv.getLength()));
                info.setPresent(info.getPresent() | 0x400);
                continue;
            }
            if (tlv.getType() == 15 || tlv.getType() == 16) {
                info.setSessionLen(tlv.getValueInt());
                info.setPresent(info.getPresent() | 0x100);
                continue;
            }
            if (tlv.getType() == 27) {
                info.setSecureIM(tlv.getValue());
                info.setPresent(info.getPresent() | 0x800);
                LOG.debug((Object)("SecureIM TLV=" + tlv));
                continue;
            }
            if (tlv.getType() == 29) {
                info.setIconData(tlv);
                info.setPresent(info.getPresent() | 0x1000);
                continue;
            }
            if (tlv.getType() == 25) {
                buffer = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
                info.setCapabilities3(buffer.readCaps(tlv.getLength(), true));
                info.setPresent(info.getPresent() | 0x2000);
                continue;
            }
            if (tlv.getType() == 30) {
                info.setUnknown001E(tlv.getValueInt());
                info.setPresent(info.getPresent() | 0x4000);
                continue;
            }
            LOG.warn((Object)("Unknown TLV=" + tlv));
        }
        return info;
    }

    public ODirInfo readODirInfo() throws IOException {
        ODirInfo info = new ODirInfo();
        TLVChain tlvchain = this.readTLVChainByCount(this.readShort());
        Iterator i = tlvchain.iterator();
        while (i.hasNext()) {
            TLV tlv = (TLV)i.next();
            if (tlv.getType() == 1) {
                info.setFirst(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 3) {
                info.setMiddle(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 2) {
                info.setLast(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 4) {
                info.setMaiden(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 12 || tlv.getType() == 9) {
                info.setNickname(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 8) {
                info.setCity(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 7) {
                info.setState(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 13) {
                info.setZip(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 6 || tlv.getType() == 14) {
                info.setCountry(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 15) {
                info.setLanguage(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 33) {
                info.setStreet(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 35) {
                LOG.warn((Object)("Unknown TLV=" + tlv));
                continue;
            }
            LOG.warn((Object)("Unknown TLV=" + tlv));
        }
        return info;
    }

    public Chat readRoomInfo() throws IOException {
        Chat chat = new Chat();
        chat.setExchange(this.readShort());
        chat.setName(this.readStringL());
        chat.setInstance(this.readShort());
        return chat;
    }

    public Ad readAd() throws IOException {
        Ad ad = new Ad();
        TLVChain tlvchain = this.readTLVChain();
        Iterator i = tlvchain.iterator();
        while (i.hasNext()) {
            TLV tlv = (TLV)i.next();
            if (tlv.getType() == 1) {
                ad.setId(tlv.getValueInt());
                continue;
            }
            if (tlv.getType() == 2) {
                ad.setSpot(tlv.getValueInt());
                continue;
            }
            if (tlv.getType() == 3) {
                ad.setMimeType(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 4) {
                ad.setData(tlv.getValue());
                continue;
            }
            if (tlv.getType() == 5) {
                ad.setURL(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 6) {
                ad.setText(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 7) {
                ad.setExpires(tlv.getValueInt());
                continue;
            }
            if (tlv.getType() == 8) {
                ad.setMaxDisplayCount(tlv.getValueShort());
                continue;
            }
            if (tlv.getType() == 9) {
                ad.setMaxDisplayTime(tlv.getValueShort());
                continue;
            }
            if (tlv.getType() == 10) {
                ad.setIdle(tlv.getValueShort());
                ad.setAnimated(false);
                continue;
            }
            if (tlv.getType() == 11) {
                ad.setIdle(tlv.getValueShort());
                ad.setAnimated(true);
                continue;
            }
            if (tlv.getType() == 14) {
                ad.setWidth(tlv.getValueShort());
                continue;
            }
            if (tlv.getType() == 15) {
                ad.setHeight(tlv.getValueShort());
                continue;
            }
            if (tlv.getType() == 16) {
                ad.setDelay(tlv.getValueShort());
                continue;
            }
            LOG.warn((Object)("Unknown TLV=" + tlv));
        }
        return ad;
    }

    public AIMPopup readPopup() throws IOException {
        AIMPopup popup = new AIMPopup();
        TLVChain tlvchain = this.readTLVChain();
        Iterator i = tlvchain.iterator();
        while (i.hasNext()) {
            TLV tlv = (TLV)i.next();
            if (tlv.getType() == 1) {
                popup.setMsg(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 2) {
                popup.setURL(tlv.getValueString());
                continue;
            }
            if (tlv.getType() == 3) {
                popup.setWidth(tlv.getValueShort());
                continue;
            }
            if (tlv.getType() == 4) {
                popup.setHeight(tlv.getValueShort());
                continue;
            }
            if (tlv.getType() != 5) continue;
            popup.setDelay(tlv.getValueShort());
        }
        return popup;
    }

    public RateClass readRateClass() throws IOException {
        RateClass rc = new RateClass();
        rc.setClassID(this.readShort());
        rc.setWindowSize(this.readInt());
        rc.setClear(this.readInt());
        rc.setAlert(this.readInt());
        rc.setLimit(this.readInt());
        rc.setDisconnect(this.readInt());
        rc.setCurrent(this.readInt());
        rc.setMax(this.readInt());
        return rc;
    }

    public DirectIMHeader readDirectIMHeader() throws IOException {
        DirectIMHeader dh = new DirectIMHeader();
        dh.setMagic(this.readString(4));
        dh.setLength(this.readShort());
        dh.setType(this.readShort());
        dh.setUnknown(this.readShort());
        this.readShort();
        dh.setCookie(this.readBytes(8));
        this.readShort();
        this.readShort();
        this.readShort();
        this.readShort();
        dh.setPayloadLength(this.readInt());
        dh.setCharset(this.readShort());
        dh.setCharSubset(this.readShort());
        this.readShort();
        dh.setFlags(this.readShort());
        this.readShort();
        this.readShort();
        dh.setSN(this.readStringNullPadded(32, "US-ASCII"));
        if (dh.getPayloadLength() > 0) {
            dh.setPayload(this.readBytes(dh.getPayloadLength()));
        }
        return dh;
    }

    public FileHeader readFileHeader() throws IOException {
        FileHeader fh = new FileHeader();
        fh.setMagic(this.readString(4));
        fh.setLength(this.readShort());
        fh.setType(this.readShort());
        fh.setCookie(this.readBytes(8));
        fh.setEncryption(this.readShort());
        fh.setCompression(this.readShort());
        fh.setTotalNumFiles(this.readShort());
        fh.setNumFilesLeft(this.readShort());
        fh.setTotalNumParts(this.readShort());
        fh.setNumPartsLeft(this.readShort());
        fh.setTotalFileSize(this.readInt());
        fh.setFileSize(this.readInt());
        fh.setFileTime(this.readInt());
        fh.setChecksum(this.readInt());
        fh.setResRecvdChecksum(this.readInt());
        fh.setResSize(this.readInt());
        fh.setResTime(this.readInt());
        fh.setResChecksum(this.readInt());
        fh.setNumRecvd(this.readInt());
        fh.setRecvdChecksum(this.readInt());
        fh.setIDString(this.readStringNullPadded(32, "US-ASCII"));
        fh.setFlag(this.readByte());
        fh.setListNameOffset(this.readByte());
        fh.setListSizeOffset(this.readByte());
        fh.setDummyBlock(this.readBytes(69));
        fh.setMacFileInfo(this.readBytes(16));
        fh.setCharset(this.readShort());
        fh.setCharSubset(this.readShort());
        fh.setName(AIMUtil.dirAOLToSys(this.readStringNullPadded(64, AIMUtil.charsetAOLToJava(fh.getCharset()))));
        return fh;
    }

    public ArrayList readGetFileEntries() throws IOException {
        TLVChain tlvchain = this.readTLVChain();
        if (tlvchain == null) {
            return null;
        }
        ArrayList<GetFileEntry> files = new ArrayList<GetFileEntry>(tlvchain.size() / 6);
        GetFileEntry gfe = new GetFileEntry();
        Iterator i = tlvchain.iterator();
        block8: while (i.hasNext()) {
            TLV tlv = (TLV)i.next();
            LOG.debug((Object)("readGetFileEntries: parsing TLV=" + tlv));
            switch (tlv.getType()) {
                case 257: {
                    gfe.setFilename(AIMUtil.dirAOLToSys(tlv.getValueString()));
                    continue block8;
                }
                case 771: {
                    gfe.setFilesize(tlv.getValueInt());
                    continue block8;
                }
                case 1285: {
                    gfe.setUnknown0505(tlv.getValueShort());
                    continue block8;
                }
                case 1028: {
                    gfe.setFilename(tlv.getValueString());
                    continue block8;
                }
                case 2304: {
                    gfe.setFlags(tlv.getValueInt());
                    continue block8;
                }
                case 2313: {
                    files.add(gfe);
                    gfe = new GetFileEntry();
                    continue block8;
                }
            }
            LOG.warn((Object)("Unhandled GetFileEntry TLV=" + tlv));
        }
        LOG.debug((Object)("readGetFileEntries: files=" + files + ", tlvchain length=" + tlvchain.length()));
        LOG.debug((Object)(this.available() + " bytes remaining in buffer"));
        return files;
    }

    public GetFileList readGetFileList() throws IOException {
        GetFileList gfl = new GetFileList();
        gfl.setVersion(this.readString(4));
        gfl.setFiles(this.readGetFileEntries());
        return gfl;
    }

    public ProxyPacket readProxyPacket() throws IOException {
        short length = this.readShort();
        if (length == 0) {
            return null;
        }
        ProxyPacket proxyPacket = new ProxyPacket();
        proxyPacket.setVersion(this.readShort());
        proxyPacket.setType(this.readShort());
        proxyPacket.setUnknown(this.readInt());
        proxyPacket.setFlags(this.readShort());
        if (length - 10 > 0) {
            proxyPacket.setData(this.readBytes(length - 10));
        }
        return proxyPacket;
    }

    public ICQColor readICQColor() throws IOException {
        ICQColor color = new ICQColor();
        color.setRed(this.readByte());
        color.setGreen(this.readByte());
        color.setBlue(this.readByte());
        color.setZero(this.readByte());
        return color;
    }

    public String readIP() throws IOException {
        String s = (this.readByte() & 0xFF) + "." + (this.readByte() & 0xFF) + "." + (this.readByte() & 0xFF) + "." + (this.readByte() & 0xFF);
        return s;
    }

    public int getEmpty() throws IOException {
        return this.available();
    }

    public boolean isEmpty() throws IOException {
        return this.available() <= 0;
    }
}

