/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.handlers.MiscListener;

public class TransmitQueueThread
extends Thread {
    private static final Logger LOG = Logger.getLogger((String)TransmitQueueThread.class.getName());
    private AIMSession sess;
    private AIMConnection conn;
    private volatile Thread thread = this;
    private static final int SLEEP_TIME = 100;

    public TransmitQueueThread(AIMSession sess, AIMConnection conn) {
        this.sess = sess;
        this.conn = conn;
    }

    private void handleOutgoingFrame(AIMFrame frame) {
        SNAC snac = frame.getSNAC();
        if (snac != null) {
            RateClass rc;
            int mode = this.conn.getTransmitQueue().getMode();
            if (mode == 0) {
                if (this.conn.getLastActivity() + this.conn.getForcedLatency() >= System.currentTimeMillis()) {
                    try {
                        TransmitQueueThread.sleep(this.conn.getLastActivity() + this.conn.getForcedLatency() - System.currentTimeMillis());
                    }
                    catch (InterruptedException ie) {
                        LOG.error((Object)"InterruptedException", (Throwable)ie);
                    }
                }
            } else if (mode == 1 && (rc = this.conn.findRate(snac.getFamily(), snac.getSubtype())) != null && rc.getCurrent() > rc.getMax()) {
                try {
                    LOG.debug((Object)("Sleeping " + (rc.getMax() - rc.getCurrent()) + " milliseconds"));
                    TransmitQueueThread.sleep(rc.getMax() - rc.getCurrent());
                }
                catch (InterruptedException ie) {
                    LOG.error((Object)"InterruptedException", (Throwable)ie);
                }
            }
        }
        try {
            this.conn.sendFrame(frame);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        if (snac != null) {
            this.conn.updateRate(snac.getFamily(), snac.getSubtype());
        }
        if (!frame.isHandled()) {
            Iterator i = frame.getConn().getListeners(65535, 65534);
            while (i.hasNext()) {
                ((MiscListener)i.next()).unhandledFrame(this.sess, frame);
            }
        }
    }

    public synchronized void flush() {
        AIMFrame frame;
        this.thread = null;
        while ((frame = (AIMFrame)this.conn.getTransmitQueue().pop()) != null) {
            this.handleOutgoingFrame(frame);
        }
    }

    private void queueInternal() {
        if (this.conn == null || this.conn.getTransmitQueue() == null) {
            return;
        }
        AIMFrame frame = (AIMFrame)this.conn.getTransmitQueue().pop();
        if (frame == null) {
            try {
                TransmitQueueThread.sleep(100L);
            }
            catch (InterruptedException ie) {
                LOG.error((Object)"InterruptedException", (Throwable)ie);
            }
        } else {
            this.handleOutgoingFrame(frame);
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.thread == thisThread && this.conn != null && this.conn.getTransmitQueue() != null) {
            int mode = this.conn.getTransmitQueue().getMode();
            if (mode == 0 || mode == 1) {
                this.queueInternal();
                continue;
            }
            LOG.warn((Object)("Unknown queue mode=" + Integer.toHexString(mode)));
        }
    }
}

