/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.BuddyListListener;
import org.walluck.oscar.handlers.MiscHandler;
import org.walluck.oscar.handlers.SNACHandler;

public class BuddyListHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)BuddyListHandler.class.getName());

    public BuddyListHandler() {
        this.setFamily(3);
        this.setVersion(1);
    }

    public void reqBuddyRights(AIMSession sess, AIMConnection conn) throws IOException {
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 3, 2);
    }

    private void rights(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLVChain tlvchain = buffer.readTLVChain();
        short maxbuddies = 0;
        short maxwatchers = 0;
        TLV tlv = tlvchain.getTLV(1, 1);
        if (tlv != null) {
            maxbuddies = tlv.getValueShort();
        }
        if ((tlv = tlvchain.getTLV(2, 1)) != null) {
            maxwatchers = tlv.getValueShort();
        }
        if ((tlv = tlvchain.getTLV(3, 1)) != null) {
            LOG.warn((Object)("rights: TLV type=" + Integer.toHexString(tlv.getType()) + ", length=" + tlv.getLength() + ", value=" + AIMUtil.byteArrayToHexString(tlv.getValue())));
        }
        Iterator i = frame.getConn().getListeners(3, 3);
        while (i.hasNext()) {
            ((BuddyListListener)i.next()).buddylistRights(sess, frame, maxbuddies, maxwatchers);
        }
    }

    public void addBuddy(AIMSession sess, AIMConnection conn, String sn) throws IOException {
        if (sn == null) {
            throw new NullPointerException();
        }
        if (sn.length() == 0) {
            throw new IllegalArgumentException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(3, 4, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(1 + sn.length());
        buffer.writeStringL(sn);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void setBuddyList(AIMSession sess, AIMConnection conn, String buddyList) throws IOException {
        if (buddyList == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(3, 4, 0, null, false);
        StringTokenizer st = new StringTokenizer(buddyList, "&");
        AIMOutputStream buffer = new AIMOutputStream();
        while (st.hasMoreTokens()) {
            buffer.writeStringL(st.nextToken());
        }
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void removeBuddy(AIMSession sess, AIMConnection conn, String sn) throws IOException {
        if (sn == null) {
            throw new NullPointerException();
        }
        if (sn.length() == 0) {
            throw new IllegalArgumentException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(3, 5, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(sn.length());
        buffer.writeStringL(sn);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void buddyChange(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        UserInfo userinfo = buffer.readUserInfo();
        Iterator i = frame.getConn().getListeners(3, snac.getSubtype());
        while (i.hasNext()) {
            ((BuddyListListener)i.next()).buddyChange(sess, frame, userinfo);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.rights(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 11 || snac.getSubtype() == 12) {
            this.buddyChange(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

