/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.ODirInfo;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.LocateListener;
import org.walluck.oscar.handlers.MiscHandler;
import org.walluck.oscar.handlers.SNACHandler;

public class LocateHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)LocateHandler.class.getName());

    public LocateHandler() {
        this.setFamily(2);
        this.setVersion(1);
    }

    public void reqLocateRights(AIMSession sess, AIMConnection conn) throws IOException {
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 2, 2);
    }

    public void setProfile(AIMSession sess, AIMConnection conn, String profileEncoding, String profile, String awayMsgEncoding, String awayMsg, int caps, byte[] encodedCertificate) throws IOException {
        String enc;
        String defEncoding = "text/aolrtf; charset=\"";
        TLVChain tlvchain = new TLVChain(5);
        if (profile != null && profile.length() > 0) {
            tlvchain.addString(1, defEncoding + profileEncoding + "\"");
            enc = AIMUtil.charsetAOLToJava(profileEncoding);
            tlvchain.addBytes(2, profile.getBytes(enc));
        }
        if (awayMsg != null && awayMsg.length() > 0) {
            tlvchain.addString(3, defEncoding + awayMsgEncoding + "\"");
            enc = AIMUtil.charsetAOLToJava(awayMsgEncoding);
            tlvchain.addBytes(4, awayMsg.getBytes(enc));
        } else {
            tlvchain.addNull(4);
        }
        tlvchain.addCaps(5, caps);
        if (encodedCertificate != null) {
            TLVChain certificateTLV = new TLVChain(2);
            certificateTLV.addShort(4, 1);
            certificateTLV.addBytes(1, encodedCertificate);
            AIMOutputStream tmpbuffer = new AIMOutputStream(21);
            tmpbuffer.writeShort(1026);
            tmpbuffer.writeByte(1);
            byte[] digest = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                digest = md.digest();
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
            }
            tmpbuffer.writeByte(digest.length);
            tmpbuffer.writeBytes(digest);
            certificateTLV.addBytes(5, tmpbuffer.getBytes());
            tmpbuffer = new AIMOutputStream(21);
            tmpbuffer.writeShort(1027);
            tmpbuffer.writeByte(1);
            tmpbuffer.writeByte(digest.length);
            tmpbuffer.writeBytes(digest);
            certificateTLV.addBytes(6, tmpbuffer.getBytes());
            tlvchain.addTLVChain(6, certificateTLV);
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(2, 4, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void getInfo(AIMSession sess, AIMConnection conn, String sn, int info) throws IOException {
        PrivInfoReq privData = new PrivInfoReq();
        if (sess == null || conn == null || sn == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        privData.setSN(sn);
        privData.setInfoType(info);
        SNAC snac = new SNAC(2, 5, 0, privData, true);
        AIMOutputStream buffer = new AIMOutputStream(3 + sn.length());
        buffer.writeShort(info);
        buffer.writeStringL(sn);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void getInfo2(AIMSession sess, AIMConnection conn, String sn, int info) throws IOException {
        PrivInfoReq privData = new PrivInfoReq();
        if (sess == null || conn == null || sn == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        privData.setSN(sn);
        privData.setInfoType(info);
        SNAC snac = new SNAC(2, 21, 0, privData, true);
        AIMOutputStream buffer = new AIMOutputStream(5 + sn.length());
        buffer.writeShort(0);
        buffer.writeShort(info);
        buffer.writeStringL(sn);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void locateRights(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLV tlv;
        TLVChain tlvchain = buffer.readTLVChain();
        short maxsiglen = 0;
        if (tlvchain != null && (tlv = tlvchain.getTLV(1, 1)) != null) {
            maxsiglen = tlv.getValueShort();
        }
        Iterator i = frame.getConn().getListeners(2, 3);
        while (i.hasNext()) {
            ((LocateListener)i.next()).locateRights(sess, frame, maxsiglen);
        }
    }

    private void userInfo(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLV ct;
        TLV tlv;
        PrivInfoReq inforeq;
        SNAC origSNAC = frame.getConn().remSNAC(snac.getId());
        String textEncoding = null;
        String text = null;
        if (origSNAC == null || origSNAC.getData() == null) {
            LOG.error((Object)"No snac stored!");
        }
        if ((inforeq = (PrivInfoReq)origSNAC.getData()).getInfoType() != 1 && inforeq.getInfoType() != 3 && inforeq.getInfoType() != 4) {
            LOG.info((Object)("Unknown infotype in request! (" + Integer.toHexString(inforeq.getInfoType()) + ")"));
            return;
        }
        UserInfo userinfo = buffer.readUserInfo();
        TLVChain tlvchain = buffer.readTLVChain();
        if (tlvchain != null && inforeq.getInfoType() == 1) {
            tlv = tlvchain.getTLV(1, 1);
            if (tlv != null && (textEncoding = tlv.getValueString()) != null) {
                textEncoding = AIMUtil.parseProfileEncoding(textEncoding);
            }
            if ((tlv = tlvchain.getTLV(2, 1)) != null) {
                text = textEncoding != null ? tlv.getValueString(textEncoding) : tlv.getValueString();
            }
        } else if (tlvchain != null && inforeq.getInfoType() == 3) {
            tlv = tlvchain.getTLV(3, 1);
            if (tlv != null && (textEncoding = tlv.getValueString()) != null) {
                textEncoding = AIMUtil.parseProfileEncoding(textEncoding);
            }
            if ((tlv = tlvchain.getTLV(4, 1)) != null) {
                text = textEncoding != null ? tlv.getValueString(textEncoding) : tlv.getValueString();
            }
        } else if (tlvchain != null && inforeq.getInfoType() == 4 && (ct = tlvchain.getTLV(5, 1)) != null) {
            AIMInputStream buffer2 = new AIMInputStream(new ByteArrayInputStream(ct.getValue()));
            userinfo.setCapabilities(buffer2.readCaps(ct.getLength()));
            userinfo.setPresent(128);
        }
        Iterator i = frame.getConn().getListeners(2, 6);
        while (i.hasNext()) {
            ((LocateListener)i.next()).userInfo(sess, frame, userinfo, inforeq.getInfoType(), textEncoding, text);
        }
    }

    public void setDirectoryInfo(AIMSession sess, AIMConnection conn, ODirInfo info, int privacy) throws IOException {
        TLVChain tlvchain = new TLVChain(9);
        tlvchain.addShort(10, privacy);
        if (info.getFirst() != null) {
            tlvchain.addString(1, info.getFirst());
        }
        if (info.getLast() != null) {
            tlvchain.addString(2, info.getLast());
        }
        if (info.getMiddle() != null) {
            tlvchain.addString(3, info.getMiddle());
        }
        if (info.getMaiden() != null) {
            tlvchain.addString(4, info.getMaiden());
        }
        if (info.getState() != null) {
            tlvchain.addString(7, info.getState());
        }
        if (info.getCity() != null) {
            tlvchain.addString(8, info.getCity());
        }
        if (info.getNickname() != null) {
            tlvchain.addString(12, info.getNickname());
        }
        if (info.getZip() != null) {
            tlvchain.addString(13, info.getZip());
        }
        if (info.getStreet() != null) {
            tlvchain.addString(33, info.getStreet());
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(2, 9, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void setUserInterests(AIMSession sess, AIMConnection conn, ArrayList interests, int privacy) throws IOException {
        TLVChain tlvchain = new TLVChain(6);
        tlvchain.addShort(10, privacy);
        int size = interests.size();
        if (size < 0 || size > 5) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < size; ++i) {
            tlvchain.addString(11, (String)interests.get(i));
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(2, 15, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.locateRights(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 6) {
            this.userInfo(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }

    class PrivInfoReq {
        private String sn;
        private int infoType;

        public String getSN() {
            return this.sn;
        }

        public void setSN(String sn) {
            this.sn = sn;
        }

        public int getInfoType() {
            return this.infoType;
        }

        public void setInfoType(int infoType) {
            this.infoType = infoType;
        }
    }
}

