/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.SNACHandler;
import org.walluck.oscar.handlers.TranslateListener;

public class TranslateHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)TranslateHandler.class.getName());

    public TranslateHandler() {
        this.setFamily(12);
        this.setVersion(1);
    }

    public void translateRequest(AIMSession sess, AIMConnection conn, ArrayList urls) throws IOException {
        int size = urls.size();
        TLVChain tlvchain = new TLVChain(size);
        for (int i = 0; i < size; ++i) {
            tlvchain.addString(11, (String)urls.get(i));
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(12, 2, 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void translateReply(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLVChain tlvchain = buffer.readTLVChain();
        ArrayList<String> urls = new ArrayList<String>();
        Iterator i = tlvchain.iterator();
        while (i.hasNext()) {
            TLV tlv = (TLV)i.next();
            if (tlv.getType() != 11) continue;
            urls.add(tlv.getValueString());
        }
        i = frame.getConn().getListeners(12, 3);
        while (i.hasNext()) {
            ((TranslateListener)i.next()).translateReply(sess, frame, urls);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.translateReply(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

