/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.proxy;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.handlers.proxy.ProxyListener;
import org.walluck.oscar.handlers.proxy.ProxyPacket;

public class ProxyTool
extends Thread {
    private static final Logger LOG = Logger.getLogger((String)ProxyTool.class.getName());
    private AIMSession sess;
    private byte[] cookie;
    private String screenname;
    private String host;
    private int port;
    private boolean wantResponse;
    private boolean listener = false;
    private boolean sender = false;
    private Socket socket;
    private ServerSocket ssocket;
    private volatile Thread thread = this;
    private boolean threadSuspended;
    private static final int SOCKET_TIMEOUT = 300000;

    public ProxyTool(AIMSession sess, byte[] cookie, String screenname, String host, int port, boolean wantResponse) {
        this.sess = sess;
        this.cookie = cookie;
        this.screenname = screenname;
        this.host = host;
        this.port = port;
        LOG.debug((Object)("Connecting to/Connection from " + host + ":" + port));
        this.wantResponse = wantResponse;
    }

    public void initSend(String sn, byte[] cookie) throws IOException {
        ProxyPacket proxyPacket = new ProxyPacket();
        proxyPacket.setType(2);
        AIMOutputStream buffer = new AIMOutputStream(1 + sn.length() + cookie.length);
        buffer.writeStringL(sn);
        buffer.writeBytes(cookie);
        proxyPacket.setData(buffer.getBytes());
        this.sendProxyPacket(proxyPacket);
    }

    public void initRecv(String sn, int port, byte[] cookie) throws IOException {
        ProxyPacket proxyPacket = new ProxyPacket();
        proxyPacket.setType(2);
        AIMOutputStream buffer = new AIMOutputStream(1 + sn.length() + 2 + cookie.length);
        buffer.writeStringL(sn);
        buffer.writeShort(port);
        buffer.writeBytes(cookie);
        proxyPacket.setData(buffer.getBytes());
        this.sendProxyPacket(proxyPacket);
    }

    public void setListener(boolean listener) {
        this.listener = listener;
    }

    public boolean isListener() {
        return this.listener;
    }

    public void setSender(boolean sender) {
        this.sender = sender;
    }

    public boolean isSender() {
        return this.sender;
    }

    public void end() {
        this.cleanup();
    }

    private void cleanup() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        this.thread = null;
    }

    private void waitForConnection() {
        Iterator i;
        LOG.debug((Object)("Connecting to " + this.host + ":" + this.port));
        try {
            this.ssocket = new ServerSocket(0);
            this.ssocket.setSoTimeout(300000);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            i = this.sess.getListeners(250, 3);
            while (i.hasNext()) {
                ((ProxyListener)i.next()).proxyDisconnect(this.sess, null);
            }
            this.cleanup();
        }
        try {
            this.socket = this.ssocket.accept();
            this.socket.setSoTimeout(300000);
            Iterator i2 = this.sess.getListeners(250, 4);
            while (i2.hasNext()) {
                ((ProxyListener)i2.next()).proxyEstablished(this.sess);
            }
        }
        catch (InterruptedIOException iioe) {
            LOG.error((Object)"InterruptedIOException", (Throwable)iioe);
            i = this.sess.getListeners(250, 3);
            while (i.hasNext()) {
                ((ProxyListener)i.next()).proxyDisconnect(this.sess, null);
            }
            this.cleanup();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            i = this.sess.getListeners(250, 3);
            while (i.hasNext()) {
                ((ProxyListener)i.next()).proxyDisconnect(this.sess, null);
            }
            this.cleanup();
        }
        LOG.debug((Object)("Connection received from " + this.host + ":" + this.port));
    }

    private void initiateConnection() {
        LOG.debug((Object)("Connecting to " + this.host + ":" + this.port));
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(300000);
            Iterator i = this.sess.getListeners(250, 4);
            while (i.hasNext()) {
                ((ProxyListener)i.next()).proxyEstablished(this.sess);
            }
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)"UnknownHostException", (Throwable)uhe);
            if (!this.sender) {
                this.threadSuspended = true;
            } else {
                Iterator i = this.sess.getListeners(250, 3);
                while (i.hasNext()) {
                    ((ProxyListener)i.next()).proxyDisconnect(this.sess, null);
                }
                this.cleanup();
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            if (!this.sender) {
                this.threadSuspended = true;
            }
            Iterator i = this.sess.getListeners(250, 3);
            while (i.hasNext()) {
                ((ProxyListener)i.next()).proxyDisconnect(this.sess, null);
            }
            this.cleanup();
        }
        LOG.debug((Object)("Connected to " + this.host + ":" + this.port));
    }

    private void initiate(boolean wantResponse) {
    }

    private void parse(AIMInputStream buffer) {
        ProxyPacket proxyPacket = null;
        try {
            LOG.debug((Object)"Got proxyPacket...");
            proxyPacket = buffer.readProxyPacket();
            if (proxyPacket.getType() == 1) {
                Iterator i = this.sess.getListeners(250, 1);
                while (i.hasNext()) {
                    ((ProxyListener)i.next()).proxyError(this.sess, proxyPacket);
                }
            } else if (proxyPacket.getType() == 3) {
                Iterator i = this.sess.getListeners(250, 5);
                while (i.hasNext()) {
                    ((ProxyListener)i.next()).proxyAck(this.sess, proxyPacket);
                }
            } else if (proxyPacket.getType() == 5) {
                Iterator i = this.sess.getListeners(250, 6);
                while (i.hasNext()) {
                    ((ProxyListener)i.next()).proxyReady(this.sess, proxyPacket);
                }
            } else {
                Iterator i = this.sess.getListeners(250, 2);
                while (i.hasNext()) {
                    ((ProxyListener)i.next()).unknownProxyPacket(this.sess, proxyPacket);
                }
            }
        }
        catch (EOFException oefe) {
            Iterator i = this.sess.getListeners(250, 3);
            while (i.hasNext()) {
                ((ProxyListener)i.next()).proxyDisconnect(this.sess, proxyPacket);
            }
            this.cleanup();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            Iterator i = this.sess.getListeners(250, 3);
            while (i.hasNext()) {
                ((ProxyListener)i.next()).proxyDisconnect(this.sess, proxyPacket);
            }
            this.cleanup();
        }
    }

    private void sendProxyPacket(ProxyPacket proxyPacket) throws IOException {
        byte[] data = proxyPacket.getData();
        AIMOutputStream buffer = new AIMOutputStream(10 + data.length);
        buffer.writeProxyPacket(proxyPacket);
        LOG.debug((Object)AIMUtil.hexdump(buffer.getBytes()));
        this.socket.getOutputStream().write(buffer.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thisThread = Thread.currentThread();
        if (this.thread != thisThread) {
            return;
        }
        ProxyTool proxyTool = this;
        synchronized (proxyTool) {
            while (this.threadSuspended && this.thread == thisThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    LOG.error((Object)"InterruptedException", (Throwable)ie);
                    this.thread = null;
                    Iterator i = this.sess.getListeners(250, 3);
                    while (i.hasNext()) {
                        ((ProxyListener)i.next()).proxyDisconnect(this.sess, null);
                    }
                }
            }
        }
        if (this.listener) {
            this.waitForConnection();
        } else {
            this.initiateConnection();
        }
        if (this.sender) {
            this.initiate(this.wantResponse);
        }
        try {
            AIMInputStream buffer = new AIMInputStream(this.socket.getInputStream());
            while (this.thread == thisThread) {
                this.parse(buffer);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }
}

