/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.Redir;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.rendezvous.BuddyIconRendezvous;
import org.walluck.oscar.handlers.IconHandler;
import org.walluck.oscar.handlers.IconListener;
import org.walluck.oscar.handlers.LoginHandler;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.ServiceListener;
import org.walluck.oscar.tools.Tool;

public class IconTool
extends Tool
implements IconListener,
ServiceListener {
    private static final Logger LOG = Logger.getLogger((String)IconTool.class.getName());
    private Hashtable icons = new Hashtable();

    public IconTool() {
        this.setFamily(16);
        this.setId(272);
        this.setVersion(1849);
    }

    public boolean checkIcon(String sn, int iconcsum) {
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + AIMUtil.normalize(sn) + ".gif");
        short oursum = 0;
        try {
            oursum = BuddyIconRendezvous.calculateChecksum(file);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        if (oursum == iconcsum) {
            LOG.debug((Object)"[10] Icon sums equal, no need to save icon");
            return true;
        }
        LOG.debug((Object)"[10] Icon sums differ, no need to save icon");
        return false;
    }

    public boolean checkIcon(String sn, byte[] iconcsum) {
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + AIMUtil.normalize(sn) + ".gif");
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (file.exists()) {
                DataInputStream dis = new DataInputStream(new FileInputStream(file));
                byte[] ourdata = new byte[(int)file.length()];
                dis.readFully(ourdata);
                md.update(ourdata);
                byte[] oursum = md.digest();
                if (Arrays.equals(oursum, iconcsum)) {
                    LOG.debug((Object)"[10] Icon sums equal");
                    return true;
                }
                LOG.debug((Object)"[10] Icon sums differ");
            } else {
                LOG.debug((Object)"[10] Icon file doesn't exist");
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        return false;
    }

    public void writeIcon(String sn, byte[] icon) {
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + AIMUtil.normalize(sn) + ".gif");
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(icon);
            fos.close();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void getIcon(String nsn, byte[] data) {
        LOG.debug((Object)("getIcon(" + nsn + ")"));
        if (this.checkIcon(nsn, data)) {
            LOG.debug((Object)"Icon is the same as on disk");
            return;
        }
        if (this.icons.get(nsn) != null) {
            LOG.debug((Object)"Icon request is already pending.");
            return;
        }
        this.icons.put(nsn, data);
        LOG.debug((Object)"Icon added to request queue!");
    }

    public void getIcons(AIMSession sess) {
        if (this.icons.size() == 0) {
            return;
        }
        AIMConnection conn = AIMConnection.findByGroup(sess, 16);
        if (conn == null) {
            LOG.debug((Object)"[10] Can't request icons now, since no conn available");
            return;
        }
        IconHandler icon = (IconHandler)sess.getHandler(16);
        LOG.debug((Object)"[10] Icon connection done!");
        Iterator i = this.icons.keySet().iterator();
        while (i.hasNext()) {
            String sn = (String)i.next();
            byte[] cookie = (byte[])this.icons.get(sn);
            i.remove();
            if (cookie == null || sn == null) {
                LOG.warn((Object)("icon request error: sn=" + sn + ", cookie=" + AIMUtil.byteArrayToHexString(cookie)));
                break;
            }
            try {
                LOG.debug((Object)("[10] Requesting icon for " + sn + "..."));
                icon.request(sess, sn, cookie);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void parseIcon(AIMSession sess, AIMFrame frame, String sn, byte[] iconcsum, byte[] icon) {
        this.writeIcon(sn, icon);
        this.icons.remove(AIMUtil.normalize(sn));
    }

    public void uploadAck(AIMSession sess, AIMFrame frame, byte[] cksum) {
        LOG.debug((Object)("Got upload ack " + AIMUtil.byteArrayToHexString(cksum)));
    }

    private void registerIconListeners(AIMConnection tstconn) {
        tstconn.registerListener(16, 3, this);
        tstconn.registerListener(16, 5, this);
        tstconn.registerListener(1, 7, this);
        tstconn.registerListener(1, 5, this);
    }

    public void rateResp(AIMSession sess, AIMFrame frame) {
        if (frame.getConn().getType() == 16) {
            AIMConnection tstconn = frame.getConn();
            this.registerIconListeners(tstconn);
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            try {
                service.clientReady(sess, tstconn);
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e);
            }
        }
    }

    public void redirect(AIMSession sess, AIMFrame frame, Redir redir) {
        if (redir.getGroup() == 16) {
            AIMConnection exist = AIMConnection.findByType(sess, 16);
            if (exist != null) {
                exist.close();
            }
            AIMConnection tstconn = new AIMConnection(sess, 16, redir.getIp());
            try {
                this.registerIconListeners(tstconn);
                tstconn.connect();
                LoginHandler login = (LoginHandler)sess.getHandler(23);
                login.sendCookie(sess, tstconn, redir.getCookie());
            }
            catch (IOException ioe) {
                tstconn.close();
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void rateChange(AIMSession sess, AIMFrame frame, int code, RateClass rc) {
    }

    public void serverPause(AIMSession sess, AIMFrame frame) {
    }

    public void serverResume(AIMSession sess, AIMFrame frame) {
    }

    public void selfInfo(AIMSession sess, AIMFrame frame, UserInfo userinfo) {
    }

    public void evilNotify(AIMSession sess, AIMFrame frame, int newEvil, UserInfo userinfo) {
    }

    public void migrate(AIMSession sess, AIMFrame frame, String ip, byte[] cookie) {
    }

    public void motd(AIMSession sess, AIMFrame frame, int id, String msg) {
    }

    public void memRequest(AIMSession sess, AIMFrame frame, int offset, int len, String modname) {
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(1, 7, this);
        bosconn.registerListener(1, 5, this);
    }
}

