/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.LocateHandler;
import org.walluck.oscar.handlers.LocateListener;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.secureim.SecureIM;
import org.walluck.oscar.tools.BuddyListTool;
import org.walluck.oscar.tools.Tool;
import org.walluck.oscar.tools.ToolData;

public class LocateTool
extends Tool
implements LocateListener {
    private static final Logger LOG = Logger.getLogger((String)LocateTool.class.getName());

    public LocateTool() {
        this.setFamily(2);
        this.setId(272);
        this.setVersion(1849);
    }

    public void setInfo(String encoding, String text) throws IOException {
        LocateHandler loc = (LocateHandler)this.getSession().getHandler(2);
        ToolData td = this.getToolData();
        if (this.getSession().isICQ()) {
            loc.setProfile(this.getSession(), td.getBosconn(), null, null, null, null, td.getICQCaps(), null);
            return;
        }
        loc.setProfile(this.getSession(), td.getBosconn(), encoding, text, null, null, td.getAIMCaps(), null);
    }

    public void getInfo(String sn) throws IOException {
        if (this.getSession().isICQ()) {
            return;
        }
        LocateHandler loc = (LocateHandler)this.getSession().getHandler(2);
        loc.getInfo(this.getSession(), this.getToolData().getBosconn(), sn, 3);
    }

    public void getAway(String sn) throws IOException {
        if (this.getSession().isICQ()) {
            return;
        }
        LocateHandler loc = (LocateHandler)this.getSession().getHandler(2);
        loc.getInfo(this.getSession(), this.getToolData().getBosconn(), sn, 1);
    }

    public void setAwayAIM(String encoding, byte[] awaymb) throws IOException {
        LocateHandler loc = (LocateHandler)this.getSession().getHandler(2);
        String awaymsg = new String(awaymb, AIMUtil.charsetAOLToJava(encoding));
        loc.setProfile(this.getSession(), this.getToolData().getBosconn(), encoding, null, encoding, awaymsg, this.getToolData().getAIMCaps(), null);
    }

    public void setAwayAIM(String awaymsg) throws IOException {
        this.setAwayAIM("us-ascii", awaymsg.getBytes("US-ASCII"));
    }

    public void setAwayICQ(String awaymsg) throws IOException {
        ServiceHandler service = (ServiceHandler)this.getSession().getHandler(1);
        if (awaymsg.equals("Online")) {
            service.setExtStatus(this.getSession(), 0);
        } else if (awaymsg.equals("Away")) {
            service.setExtStatus(this.getSession(), 1);
        } else if (awaymsg.equals("Do Not Disturb")) {
            service.setExtStatus(this.getSession(), 19);
        } else if (awaymsg.equals("Not Available")) {
            service.setExtStatus(this.getSession(), 5);
        } else if (awaymsg.equals("Occupied")) {
            service.setExtStatus(this.getSession(), 17);
        } else if (awaymsg.equals("Free For Chat")) {
            service.setExtStatus(this.getSession(), 32);
        } else if (awaymsg.equals("Invisible")) {
            service.setExtStatus(this.getSession(), 256);
        }
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(2, 3, this);
        bosconn.registerListener(2, 6, this);
    }

    public void locateRights(AIMSession sess, AIMFrame frame, int maxsiglen) {
        block6: {
            try {
                LocateHandler loc = (LocateHandler)sess.getHandler(2);
                AIMConnection conn = AIMConnection.findByType(sess, 2);
                if (!sess.isICQ()) {
                    String certFilename = System.getProperty("user.home") + File.separator + "mycert.p12";
                    if (new File(certFilename).exists()) {
                        SecureIM secureIM = new SecureIM(sess, certFilename, "password");
                        try {
                            secureIM.init();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Exception", (Throwable)e);
                        }
                        loc.setProfile(sess, conn, "us-ascii", null, "us-ascii", null, this.getToolData().getAIMCaps(), secureIM.getEncoded());
                        break block6;
                    }
                    loc.setProfile(sess, conn, "us-ascii", null, "us-ascii", null, this.getToolData().getAIMCaps(), null);
                    break block6;
                }
                loc.setProfile(sess, conn, "us-ascii", null, "us-ascii", null, this.getToolData().getICQCaps(), null);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void userInfo(AIMSession sess, AIMFrame frame, UserInfo info, int infoType, String textEncoding, String text) {
        String onlineSince = null;
        String memberSince = null;
        String idleTime = null;
        if (text != null && text.length() > 0) {
            LOG.debug((Object)("Profile: " + text));
        }
        if ((info.getPresent() & 4) != 0) {
            LOG.debug((Object)("onlineSince=" + info.getOnlineSince()));
            onlineSince = "Online since: " + new Date((long)info.getOnlineSince() * 1000L);
        }
        if ((info.getPresent() & 2) != 0) {
            memberSince = "Member since: " + new Date((long)info.getMemberSince() * 1000L);
        }
        idleTime = (info.getPresent() & 8) != 0 ? "Idle: " + info.getIdleTime() + " minutes" : "Idle: Active";
        LOG.debug((Object)("Username: " + info.getSN() + "\n" + "Warning Level: " + info.getWarnLevel() / 10.0f + "%" + "\n" + (onlineSince != null ? onlineSince : "") + "\n" + (memberSince != null ? memberSince : "") + "\n" + (idleTime != null ? idleTime : "") + "\n"));
        if (infoType == 3) {
            LOG.debug((Object)("Away Message: " + (text != null ? text : "User has no away message")));
        } else if (infoType == 4) {
            LOG.debug((Object)("Client Capabilities: " + BuddyListTool.capsToText(info.getCapabilities())));
        } else {
            LOG.debug((Object)"No information provided");
        }
    }
}

