/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.EmailInfo;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.Redir;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.LoginHandler;
import org.walluck.oscar.handlers.MailHandler;
import org.walluck.oscar.handlers.MailListener;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.ServiceListener;
import org.walluck.oscar.tools.Tool;

public class MailTool
extends Tool
implements MailListener,
ServiceListener {
    private static final Logger LOG = Logger.getLogger((String)MailTool.class.getName());

    public MailTool() {
        this.setFamily(24);
        this.setId(16);
        this.setVersion(1849);
    }

    public void checkMail(AIMSession sess) throws IOException {
        MailHandler mail = (MailHandler)sess.getHandler(24);
        mail.sendCookies(sess);
        mail.activate(sess);
    }

    public void youveGotMail(AIMSession sess, AIMFrame frame, EmailInfo ei, boolean haveNewMail) {
        LOG.debug((Object)("url=" + ei.getURL() + ", numUnread=" + ei.getNumMsgs() + ", haveMail=" + (haveNewMail ? "yes" : "no") + ", domain=" + ei.getDomain() + ", flag=" + ei.getFlag()));
    }

    private void registerMailListeners(AIMConnection tstconn) {
        tstconn.registerListener(24, 7, this);
        tstconn.registerListener(1, 7, this);
        tstconn.registerListener(1, 5, this);
    }

    public void rateResp(AIMSession sess, AIMFrame frame) {
        if (frame.getConn().getType() == 24) {
            AIMConnection tstconn = frame.getConn();
            this.registerMailListeners(tstconn);
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            try {
                service.clientReady(sess, tstconn);
                this.checkMail(sess);
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e);
            }
        }
    }

    public void redirect(AIMSession sess, AIMFrame frame, Redir redir) {
        if (redir.getGroup() == 24) {
            AIMConnection exist = AIMConnection.findByType(sess, 24);
            if (exist != null) {
                exist.close();
            }
            AIMConnection tstconn = new AIMConnection(sess, 24, redir.getIp());
            try {
                this.registerMailListeners(tstconn);
                tstconn.connect();
                LoginHandler login = (LoginHandler)sess.getHandler(23);
                login.sendCookie(sess, tstconn, redir.getCookie());
            }
            catch (IOException ioe) {
                tstconn.close();
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void rateChange(AIMSession sess, AIMFrame frame, int code, RateClass rc) {
    }

    public void serverPause(AIMSession sess, AIMFrame frame) {
    }

    public void serverResume(AIMSession sess, AIMFrame frame) {
    }

    public void selfInfo(AIMSession sess, AIMFrame frame, UserInfo userinfo) {
    }

    public void evilNotify(AIMSession sess, AIMFrame frame, int newEvil, UserInfo userinfo) {
    }

    public void migrate(AIMSession sess, AIMFrame frame, String ip, byte[] cookie) {
    }

    public void motd(AIMSession sess, AIMFrame frame, int id, String msg) {
    }

    public void memRequest(AIMSession sess, AIMFrame frame, int offset, int len, String modname) {
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(24, 7, this);
        bosconn.registerListener(1, 7, this);
        bosconn.registerListener(1, 5, this);
    }
}

