/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.development.NSBundleFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSLegacyBundle
extends NSBundle {
    public static final String NS_GLOBAL_PROPERTIES_PATH = "NSGlobalPropertiesPath";
    private static final String LEGACY_GLOBAL_PROPERTIES_PATH = "WebObjectsPropertiesReplacement";
    public static final String CFBUNDLESHORTVERSIONSTRINGKEY = "CFBundleShortVersionString";
    public static final String MANIFESTIMPLEMENTATIONVERSIONKEY = "Implementation-Version";
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSBundle");
    public static final String BundleDidLoadNotification = "NSBundleDidLoadNotification";
    public static final String LoadedClassesNotification = "NSLoadedClassesNotification";
    private static final String JSUFFIX = String.valueOf(File.separator) + "Java";
    private static final String MAIN_BUNDLE_NAME = "MainBundle";
    private static final String NONLOCALIZED_LOCALE = "Nonlocalized.lproj";
    private static final String NONLOCALIZED_LOCALE_PREFIX = "Nonlocalized.lproj" + File.separator;
    private static final String RESOURCES = "Resources";
    public static final String RSUFFIX = String.valueOf(File.separator) + "Resources";
    public static final String RJSUFFIX = String.valueOf(RSUFFIX) + File.separator + "Java";
    private static final String CONTENTS = "Contents";
    public static final String CSUFFIX = String.valueOf(File.separator) + "Contents";
    public static final String CRSUFFIX = String.valueOf(CSUFFIX) + RSUFFIX;
    private static final int NSBUNDLE = 1;
    private static final int CFBUNDLE = 2;
    private static final _NSThreadsafeMutableDictionary OldResourceFilters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
    public static final String InfoPlistFilename = "Info.plist";
    private static final _NSUtilities.JavaArchiveFilter TheJavaArchiveFilter = new _NSUtilities.JavaArchiveFilter();
    private static final _NSUtilities.JavaClassFilter TheJavaClassFilter = new _NSUtilities.JavaClassFilter();
    public static String ResourcesInfoPlist = "Resources/Info.plist";
    private static String JarResourcesInfoPlist = "!/" + ResourcesInfoPlist;
    private static String ResourcesProperties = "Resources/Properties";
    private static NSMutableDictionary TheFileDict = new NSMutableDictionary(1);
    private static boolean safeInvokeDeprecatedJarBundleAPI = false;
    private boolean isJar;
    private JarFile jarFile;
    private NSMutableArray<JarEntry> jarFileEntries;
    private NSDictionary jarFileLayout;
    private String _bundleURLPrefix;
    private String bundlePath;
    private int bundleType;
    private boolean classesHaveBeenLoaded;
    private NSArray<String> classNames;
    private NSDictionary<String, Object> infoDictionary;
    private boolean isFramework;
    private Properties properties;
    private String name;
    private NSArray<String> packages;
    private NSMutableArray<String> resourceBuckets;
    private String resourcePath;
    private String contentsPath;
    private String _resourceLocation;
    private static final String jarEndsWithString = ".jar".concat(JarResourcesInfoPlist);

    private static final String __exctractStringFromURL(URL anURL) {
        String url2Path = null;
        try {
            String urlPath = anURL.getPath();
            if (urlPath.endsWith(jarEndsWithString)) {
                url2Path = urlPath.substring(0, urlPath.length() - JarResourcesInfoPlist.length());
                URL url2 = new URL(url2Path);
                url2Path = url2.getPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url2Path;
    }

    protected NSLegacyBundle(String bundlePath, boolean isJar) {
        this.initIsJar(isJar);
        this.initBundlePath(bundlePath);
    }

    protected NSLegacyBundle() {
    }

    public void _init() {
        this.initBundleURLPrefix();
        this.initBundleType();
        this.initJarFileLayout();
        this.initContentsPath();
        this.initResourcePath();
        this.initResourceBuckets();
        this.initInfoDictionary();
        this.initName();
        this.isFramework = this.couldBeAFramework();
        this.initProperties();
        this.initClassNames();
        this.initPackages();
    }

    @Override
    public void _bundlesDidLoad() {
    }

    private static NSBundle.OldResourceFilter OldResourceFilterForExtension(String anExtension) {
        NSBundle.OldResourceFilter rf = null;
        if (anExtension == null) {
            throw new IllegalArgumentException("Illegal resource search: cannot search using a null extension");
        }
        String correctedExtension = anExtension.startsWith(".") ? anExtension.substring(1) : anExtension;
        rf = (NSBundle.OldResourceFilter)OldResourceFilters.objectForKey((Object)correctedExtension);
        if (rf == null) {
            rf = new NSBundle.OldResourceFilter(correctedExtension);
            OldResourceFilters.setObjectForKey((Object)rf, (Object)correctedExtension);
        }
        return rf;
    }

    @Override
    public NSArray<String> bundleClassPackageNames() {
        return this.packages;
    }

    @Override
    @Deprecated
    public String bundlePath() {
        return this.bundlePath;
    }

    @Override
    public URL bundlePathURL() {
        return NSPathUtilities._URLWithPath((String)this.bundlePath);
    }

    @Override
    public String _bundleURLPrefix() {
        return this._bundleURLPrefix;
    }

    @Override
    public NSArray<String> bundleClassNames() {
        return this.classNames;
    }

    @Override
    @Deprecated
    public NSDictionary<String, Object> infoDictionary() {
        return this.infoDictionary;
    }

    @Override
    public NSDictionary<String, Object> _infoDictionary() {
        return this.infoDictionary;
    }

    @Override
    public URL pathURLForResourcePath(String aResourcePath) {
        return this._pathURLForResourcePath(aResourcePath, true);
    }

    @Override
    public URL _pathURLForResourcePath(String aResourcePath, boolean returnDirectories) {
        URL url = null;
        if (aResourcePath != null && aResourcePath.length() > 0 && this.resourceBuckets.indexOfIdenticalObject((Object)this._resourceLocation) != -1) {
            boolean isLocalized = true;
            if (aResourcePath.startsWith(NONLOCALIZED_LOCALE)) {
                isLocalized = false;
            }
            String realPath = isLocalized ? aResourcePath : aResourcePath.substring(NONLOCALIZED_LOCALE.length());
            if (this.isJar) {
                ZipEntry ze;
                if (!realPath.startsWith("/")) {
                    realPath = "/".concat(realPath);
                }
                if ((ze = this.jarFile.getEntry(this._resourceLocation.concat(realPath))) != null && (returnDirectories || !ze.isDirectory())) {
                    try {
                        url = new URL(this._bundleURLPrefix.concat(ze.getName()));
                    }
                    catch (Exception e) {
                        throw NSForwardException._runtimeExceptionForThrowable(e);
                    }
                }
            } else {
                if (!realPath.startsWith(File.separator)) {
                    realPath = File.separator.concat(realPath);
                }
                try {
                    File f = new File(this.resourcePath.concat(realPath));
                    if (f.exists() && (f.isFile() || returnDirectories)) {
                        url = NSPathUtilities._URLWithPath((String)f.getCanonicalPath());
                    }
                }
                catch (Exception exception) {
                    throw NSForwardException._runtimeExceptionForThrowable(exception);
                }
            }
        }
        return url;
    }

    @Override
    public boolean isFramework() {
        return this.isFramework;
    }

    @Override
    public boolean _isCFBundle() {
        return this.bundleType == 2;
    }

    @Override
    public boolean isJar() {
        return this.isJar;
    }

    @Override
    public JarFile _jarFile() {
        return this.jarFile;
    }

    @Override
    public NSDictionary _jarFileLayout() {
        return this.jarFileLayout;
    }

    @Override
    @Deprecated
    public boolean load() {
        return this.classesHaveBeenLoaded;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Deprecated
    public String pathForResource(String aName, String anExtension) {
        return this.pathForResource(aName, anExtension, null);
    }

    @Override
    @Deprecated
    public String pathForResource(String aName, String anExtension, String aSubDirPath) {
        if (this.isJar) {
            if (safeInvokeDeprecatedJarBundleAPI) {
                return null;
            }
            throw new IllegalStateException("pathsForResoures cannot be invoked on a jar-based NSBundle");
        }
        String path = null;
        if (aName != null) {
            String possiblePath;
            int i;
            String nextDir;
            Enumeration en = this.resourceBuckets.objectEnumerator();
            String localePrefix = NSBundle._DefaultLocalePrefix();
            String[] pathFragments = new String[2];
            String pathPrefix = null;
            String fileName = anExtension == null ? aName : (anExtension.startsWith(".") || aName.endsWith(".") ? String.valueOf(aName) + anExtension : String.valueOf(aName) + "." + anExtension);
            if (aSubDirPath == null) {
                pathFragments[0] = "";
                pathFragments[1] = localePrefix;
            } else {
                pathFragments[0] = aSubDirPath;
                pathFragments[1] = String.valueOf(aSubDirPath) + File.separator + localePrefix;
            }
            while (en.hasMoreElements() && path == null) {
                nextDir = (String)en.nextElement();
                pathPrefix = nextDir.equals("") ? this.bundlePath : String.valueOf(this.bundlePath) + File.separator + nextDir;
                i = 0;
                while (i < pathFragments.length && path == null) {
                    possiblePath = pathFragments[i].equals("") ? String.valueOf(pathPrefix) + File.separator + fileName : String.valueOf(pathPrefix) + File.separator + pathFragments[i] + File.separator + fileName;
                    try {
                        File possibleResource = new File(possiblePath);
                        if (possibleResource.exists()) {
                            path = possibleResource.getCanonicalPath();
                        }
                    }
                    catch (Exception exception) {
                        throw NSForwardException._runtimeExceptionForThrowable(exception);
                    }
                    ++i;
                }
            }
            if (path == null && anExtension == null) {
                NSBundle.SpecificResourceFilter srf = new NSBundle.SpecificResourceFilter(aName);
                en = this.resourceBuckets.objectEnumerator();
                while (en.hasMoreElements() && path == null) {
                    nextDir = (String)en.nextElement();
                    pathPrefix = nextDir.equals("") ? this.bundlePath : String.valueOf(this.bundlePath) + File.separator + nextDir;
                    i = 0;
                    while (i < pathFragments.length && path == null) {
                        String[] fileNames;
                        possiblePath = pathFragments[i].equals("") ? pathPrefix : String.valueOf(pathPrefix) + pathFragments[i];
                        File possibleResourceDir = new File(possiblePath);
                        if (possibleResourceDir.isDirectory() && (fileNames = possibleResourceDir.list(srf)).length > 0) {
                            try {
                                path = String.valueOf(possibleResourceDir.getCanonicalPath()) + File.separator + fileNames[0];
                            }
                            catch (IOException e) {
                                throw NSForwardException._runtimeExceptionForThrowable(e);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return path;
    }

    @Override
    @Deprecated
    public NSArray pathsForResources(String anExtension, String aSubDirPath) {
        if (this.isJar) {
            if (safeInvokeDeprecatedJarBundleAPI) {
                return NSArray.EmptyArray;
            }
            throw new IllegalStateException("pathsForResources cannot be invoked on a jar-based NSBundle");
        }
        Enumeration en = this.resourceBuckets.objectEnumerator();
        NSMutableArray fileArray = new NSMutableArray();
        String localePrefix = NSBundle._DefaultLocalePrefix();
        String[] pathFragments = new String[2];
        NSBundle.OldResourceFilter rf = null;
        if (anExtension != null && !anExtension.equals("")) {
            rf = NSLegacyBundle.OldResourceFilterForExtension(anExtension);
        }
        if (aSubDirPath == null) {
            pathFragments[0] = "";
            pathFragments[1] = localePrefix;
        } else {
            pathFragments[0] = aSubDirPath;
            pathFragments[1] = String.valueOf(aSubDirPath) + File.separator + localePrefix;
        }
        while (en.hasMoreElements()) {
            String nextDir = (String)en.nextElement();
            String pathPrefix = nextDir.equals("") ? this.bundlePath : String.valueOf(this.bundlePath) + File.separator + nextDir;
            int i = 0;
            while (i < pathFragments.length) {
                String[] resourceNames;
                String possiblePath = pathFragments[i].equals("") ? pathPrefix : String.valueOf(pathPrefix) + File.separator + pathFragments[i];
                File possibleResourceDir = new File(possiblePath);
                if (possibleResourceDir.isDirectory() && (resourceNames = rf == null ? possibleResourceDir.list() : possibleResourceDir.list(rf)).length > 0) {
                    String basePath;
                    try {
                        basePath = possibleResourceDir.getCanonicalPath();
                    }
                    catch (IOException e) {
                        throw NSForwardException._runtimeExceptionForThrowable(e);
                    }
                    int j = 0;
                    while (j < resourceNames.length) {
                        fileArray.addObject((Object)(String.valueOf(basePath) + File.separator + resourceNames[j]));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return fileArray;
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    @Deprecated
    public String resourcePath() {
        return this.resourcePath;
    }

    @Override
    public String resourcePathForLocalizedResourceNamed(String aName, String aSubDirPath) {
        return this.resourcePathForLocalizedResourceNamed(aName, aSubDirPath, (List<String>)this.resourceBuckets);
    }

    @Override
    public NSArray<String> resourcePathsForDirectories(String extension, String aSubDirPath) {
        NSMutableArray list = null;
        if (this.resourceBuckets.indexOfIdenticalObject((Object)this._resourceLocation) != -1) {
            if (this.isJar) {
                String anExtension = this.fixExtension(extension);
                if (aSubDirPath == null || aSubDirPath.length() == 0) {
                    NSMutableArray allPaths = new NSMutableArray(this.resourcePathsForDirectoriesInDirectoryInJar(this._resourceLocation, anExtension, false));
                    NSArray<String> lProjDirs = this.resourcePathsForDirectoriesInDirectoryInJar(this._resourceLocation, ".lproj", false);
                    int count = lProjDirs.count();
                    int i = 0;
                    while (i < count) {
                        String lProjDir = (String)lProjDirs.objectAtIndex(i);
                        allPaths.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectoryInJar(_NSStringUtilities.concat(this._resourceLocation, "/", lProjDir), anExtension, false));
                        ++i;
                    }
                    list = allPaths;
                } else {
                    String startPath = _NSStringUtilities.concat(this._resourceLocation, "/", aSubDirPath);
                    list = this.resourcePathsForDirectoriesInDirectoryInJar(startPath, anExtension, false);
                }
            } else {
                FilenameFilter rdf = extension == null ? TheDirectoryFilter : NSLegacyBundle.ResourceDirectoryFilterForExtension(extension);
                if (aSubDirPath == null) {
                    NSMutableArray allPaths = new NSMutableArray(this.resourcePathsForDirectoriesInDirectory(this.resourcePath, this.resourcePath, rdf, false));
                    NSArray<String> lProjDirs = this.resourcePathsForDirectoriesInDirectory(this.resourcePath, this.resourcePath, NSLegacyBundle.ResourceDirectoryFilterForExtension(".lproj"), false);
                    int count = lProjDirs.count();
                    int i = 0;
                    while (i < count) {
                        String lProjDir = (String)lProjDirs.objectAtIndex(i);
                        allPaths.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(this.resourcePath, File.separator, lProjDir), this.resourcePath, rdf, false));
                        ++i;
                    }
                    list = allPaths;
                } else {
                    String absolutePath = NSPathUtilities.stringByNormalizingExistingPath((String)_NSStringUtilities.concat(this.resourcePath, File.separator, aSubDirPath));
                    if (absolutePath.startsWith(this.resourcePath.concat(File.separator))) {
                        list = this.resourcePathsForDirectoriesInDirectory(absolutePath, this.resourcePath, rdf, false);
                    }
                }
            }
        }
        if (list == null || list.count() == 0) {
            return NSArray.emptyArray();
        }
        return list;
    }

    @Override
    public NSArray<String> resourcePathsForLocalizedResources(String extension, String aSubDirPath) {
        NSMutableArray localizedPaths = null;
        Object returnPaths = null;
        String anExtension = extension;
        if (this.resourceBuckets.indexOfIdenticalObject((Object)this._resourceLocation) != -1) {
            if (this.isJar) {
                String localePrefix = NSBundle._DefaultLocalePrefix();
                String lpSuffix = "/".concat(localePrefix);
                anExtension = this.fixExtension(anExtension);
                if (aSubDirPath == null || aSubDirPath.length() == 0) {
                    localizedPaths = new NSMutableArray(this.resourcePathsForResourcesInDirectoryInJar(_NSStringUtilities.concat(this._resourceLocation, lpSuffix), anExtension, false));
                } else {
                    String startPath = _NSStringUtilities.concat(this._resourceLocation, lpSuffix, "/", aSubDirPath);
                    localizedPaths = new NSMutableArray(this.resourcePathsForResourcesInDirectoryInJar(startPath, anExtension, false));
                }
                if (aSubDirPath == null || aSubDirPath.length() == 0) {
                    String nextName;
                    boolean identicalPath;
                    NSMutableArray dirNames = new NSMutableArray();
                    NSMutableArray fileNames = new NSMutableArray();
                    this._simplePathsInDirectoryInJar(this._resourceLocation, "", (NSMutableArray<String>)dirNames, anExtension, (NSMutableArray<String>)fileNames);
                    int dirNamesCount = dirNames.count();
                    int fileNamesCount = fileNames.count();
                    NSMutableArray nlPaths = new NSMutableArray();
                    int i = 0;
                    while (i < fileNamesCount) {
                        identicalPath = false;
                        nextName = _NSStringUtilities.concat(localePrefix, "/", (String)fileNames.objectAtIndex(i));
                        if (localizedPaths.indexOfObject((Object)nextName) != -1) {
                            identicalPath = true;
                        }
                        if (!identicalPath) {
                            localizedPaths.addObject((Object)_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", (String)fileNames.objectAtIndex(i)));
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < dirNamesCount) {
                        boolean useThisDir;
                        boolean bl = useThisDir = !((String)dirNames.objectAtIndex(i)).toString().endsWith(".lproj");
                        if (useThisDir) {
                            nlPaths.addObjectsFromArray(this.resourcePathsForResourcesInDirectoryInJar(_NSStringUtilities.concat(this._resourceLocation, "/", (String)dirNames.objectAtIndex(i)), anExtension, true));
                        }
                        ++i;
                    }
                    int nlPathsCount = nlPaths.count();
                    i = 0;
                    while (i < nlPathsCount) {
                        identicalPath = false;
                        nextName = localePrefix.concat(((String)nlPaths.objectAtIndex(i)).substring(NONLOCALIZED_LOCALE.length()));
                        if (localizedPaths.indexOfObject((Object)nextName) != -1) {
                            identicalPath = true;
                        }
                        if (!identicalPath) {
                            localizedPaths.addObject((Object)((String)nlPaths.objectAtIndex(i)));
                        }
                        ++i;
                    }
                }
            } else {
                String localePrefix = NSBundle._DefaultLocalePrefix();
                String lpSuffix = File.separator.concat(localePrefix);
                FilenameFilter rf = anExtension == null ? TheFilesFilter : NSLegacyBundle.ResourceFilterForExtension(anExtension);
                if (aSubDirPath == null) {
                    localizedPaths = new NSMutableArray(this.resourcePathsForResourcesInDirectory(this.resourcePath.concat(lpSuffix), this.resourcePath, rf, false));
                } else {
                    String absolutePath = NSPathUtilities.stringByNormalizingExistingPath((String)_NSStringUtilities.concat(this.resourcePath, lpSuffix, File.separator, aSubDirPath));
                    if (absolutePath.startsWith(this.resourcePath.concat(File.separator))) {
                        localizedPaths = new NSMutableArray(this.resourcePathsForDirectoriesInDirectory(absolutePath, this.resourcePath, rf, false));
                    }
                }
                File nlSubdir = new File(this.resourcePath);
                if (aSubDirPath == null && nlSubdir.isDirectory()) {
                    String nextName;
                    boolean identicalPath;
                    String[] dirNames = nlSubdir.list(TheDirectoryFilter);
                    int dirNamesCount = dirNames.length;
                    String[] fileNames = nlSubdir.list(rf);
                    int fileNamesCount = fileNames.length;
                    NSMutableArray nlPaths = new NSMutableArray();
                    int i = 0;
                    while (i < fileNamesCount) {
                        identicalPath = false;
                        nextName = _NSStringUtilities.concat(localePrefix, File.separator, fileNames[i]);
                        if (localizedPaths.indexOfObject((Object)nextName) != -1) {
                            identicalPath = true;
                        }
                        if (!identicalPath) {
                            localizedPaths.addObject((Object)NONLOCALIZED_LOCALE_PREFIX.concat(fileNames[i]));
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < dirNamesCount) {
                        boolean useThisDir;
                        boolean bl = useThisDir = !dirNames[i].endsWith(".lproj");
                        if (useThisDir) {
                            nlPaths.addObjectsFromArray(this.resourcePathsForResourcesInDirectory(_NSStringUtilities.concat(this.resourcePath, File.separator, dirNames[i]), this.resourcePath, rf, true));
                        }
                        ++i;
                    }
                    int nlPathsCount = nlPaths.count();
                    i = 0;
                    while (i < nlPathsCount) {
                        identicalPath = false;
                        nextName = localePrefix.concat(((String)nlPaths.objectAtIndex(i)).substring(NONLOCALIZED_LOCALE.length()));
                        if (localizedPaths.indexOfObject((Object)nextName) != -1) {
                            identicalPath = true;
                        }
                        if (!identicalPath) {
                            localizedPaths.addObject((Object)((String)nlPaths.objectAtIndex(i)));
                        }
                        ++i;
                    }
                }
            }
            returnPaths = localizedPaths == null || localizedPaths.count() == 0 ? NSArray.emptyArray() : localizedPaths;
        }
        return returnPaths;
    }

    @Override
    public NSArray<String> resourcePathsForResources(String extension, String aSubDirPath) {
        NSArray<String> list = null;
        String anExtension = extension;
        if (this.resourceBuckets.indexOfIdenticalObject((Object)this._resourceLocation) != -1) {
            if (this.isJar) {
                anExtension = this.fixExtension(anExtension);
                if (aSubDirPath == null || aSubDirPath.length() == 0) {
                    list = this.resourcePathsForResourcesInDirectoryInJar(this._resourceLocation, anExtension, false);
                } else {
                    String startPath = _NSStringUtilities.concat(this._resourceLocation, "/", aSubDirPath);
                    boolean prependNonLocalizedLproj = aSubDirPath.indexOf(".lproj") == -1;
                    list = this.resourcePathsForResourcesInDirectoryInJar(startPath, anExtension, prependNonLocalizedLproj);
                }
            } else {
                FilenameFilter rf = anExtension == null ? TheFilesFilter : NSLegacyBundle.ResourceFilterForExtension(anExtension);
                if (aSubDirPath == null) {
                    list = this.resourcePathsForResourcesInDirectory(this.resourcePath, this.resourcePath, rf, false);
                } else {
                    String absolutePath = NSPathUtilities.stringByNormalizingExistingPath((String)_NSStringUtilities.concat(this.resourcePath, File.separator, aSubDirPath));
                    if (absolutePath.startsWith(this.resourcePath.concat(File.separator))) {
                        boolean prependNonLocalizedLproj = aSubDirPath.indexOf(".lproj") == -1;
                        list = this.resourcePathsForResourcesInDirectory(absolutePath, this.resourcePath, rf, prependNonLocalizedLproj);
                    }
                }
            }
        }
        if (list == null || list.count() == 0) {
            return NSArray.emptyArray();
        }
        return list;
    }

    private void addResourceBucket(String aBundleSubDirPath) {
        if (aBundleSubDirPath != null && this.resourceBuckets.indexOfObject((Object)aBundleSubDirPath) == -1) {
            if (this.isJar) {
                ZipEntry ze = this.jarFile.getEntry(aBundleSubDirPath.concat("/"));
                if (ze != null && ze.isDirectory()) {
                    this.resourceBuckets.addObject((Object)aBundleSubDirPath);
                }
                if (aBundleSubDirPath.length() == 0) {
                    this.resourceBuckets.addObject((Object)aBundleSubDirPath);
                }
            } else {
                String resourceDirPath = _NSStringUtilities.concat(this.bundlePath, File.separator, aBundleSubDirPath);
                File resourceDir = new File(resourceDirPath);
                if (resourceDir.isDirectory()) {
                    this.resourceBuckets.addObject((Object)aBundleSubDirPath);
                }
            }
        }
    }

    private NSArray<String> classNamesFromDirectory(File aDirectory) {
        int i;
        int l;
        String[] classes = aDirectory.list(TheJavaClassFilter);
        NSMutableArray theClassNames = new NSMutableArray();
        String[] directories = aDirectory.list(TheDirectoryFilter);
        if (classes != null) {
            l = classes.length;
            i = 0;
            while (i < l) {
                String className;
                try {
                    className = _NSStringUtilities.concat(aDirectory.getCanonicalPath(), File.separator, classes[i]);
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
                className = this.resourcePath == this.bundlePath ? className.substring(this.resourcePath.length() + 1, className.lastIndexOf(46)) : className.substring(this.resourcePath.length() + JSUFFIX.length() + 1, className.lastIndexOf(46));
                theClassNames.addObject((Object)className.replace(File.separatorChar, '.'));
                ++i;
            }
        }
        if (directories != null) {
            l = directories.length;
            i = 0;
            while (i < l) {
                File f;
                try {
                    f = new File(_NSStringUtilities.concat(aDirectory.getCanonicalPath(), File.separator, directories[i]));
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
                theClassNames.addObjectsFromArray(this.classNamesFromDirectory(f));
                ++i;
            }
        }
        if (theClassNames.count() == 0) {
            return NSArray.emptyArray();
        }
        return theClassNames;
    }

    private boolean couldBeAFramework() {
        if (this.infoDictionary != null) {
            if (this.infoDictionary.objectForKey((Object)"Has_WOComponents") != null) {
                this.isFramework = true;
            } else {
                String value = (String)this.infoDictionary.objectForKey((Object)"CFBundlePackageType");
                if (value != null && value.equalsIgnoreCase("FMWK")) {
                    this.isFramework = true;
                }
            }
        }
        return this.isFramework;
    }

    private void initIsJar(boolean newIsJar) {
        this.isJar = newIsJar;
    }

    private void initBundlePath(String newBundlePath) {
        this.bundlePath = newBundlePath;
    }

    private void initBundleURLPrefix() {
        this._bundleURLPrefix = this.isJar ? _NSStringUtilities.concat("jar:", NSPathUtilities._fileURLPrefix, this.bundlePath, "!/") : _NSStringUtilities.concat(NSPathUtilities._fileURLPrefix, this.bundlePath, "/");
    }

    private void initJarFileLayout() {
        if (!this.isJar) {
            return;
        }
        NSMutableDictionary root = new NSMutableDictionary();
        Enumeration<JarEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String zePath = ze.getName();
            NSArray zeArray = NSArray.componentsSeparatedByString((String)zePath, (String)"/");
            NSMutableDictionary currentDict = root;
            Enumeration e2 = zeArray.objectEnumerator();
            while (e2.hasMoreElements()) {
                String element = (String)e2.nextElement();
                if (element.length() <= 0) continue;
                NSMutableDictionary aDict = (NSMutableDictionary)currentDict.objectForKey((Object)element);
                if (aDict == null) {
                    if (e2.hasMoreElements()) {
                        NSMutableDictionary newDict = new NSMutableDictionary();
                        currentDict.setObjectForKey((Object)newDict, (Object)element);
                        currentDict = newDict;
                        continue;
                    }
                    currentDict.setObjectForKey((Object)TheFileDict, (Object)element);
                    continue;
                }
                if (aDict == TheFileDict) continue;
                currentDict = aDict;
            }
        }
        this.jarFileLayout = root;
    }

    private void initBundleType() {
        if (this.isJar) {
            this.bundleType = 1;
            try {
                URL url = new URL(this._bundleURLPrefix.concat(ResourcesInfoPlist));
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                this.jarFile = jarConnection.getJarFile();
                this.jarFileEntries = new NSMutableArray();
                Enumeration<JarEntry> e = this.jarFile.entries();
                while (e.hasMoreElements()) {
                    this.jarFileEntries.addObject((Object)e.nextElement());
                }
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        } else {
            File contentsDir = new File(this.bundlePath.concat(CSUFFIX));
            this.bundleType = contentsDir.exists() ? 2 : 1;
            this.jarFile = null;
        }
    }

    private void initClassNames() {
        NSMutableSet classes = new NSMutableSet();
        this.classNames = new NSMutableArray();
        if (this.isJar) {
            if (this.jarFile != null) {
                Enumeration e = this.jarFileEntries.objectEnumerator();
                while (e.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)e.nextElement();
                    String path = entry.getName();
                    if (!path.endsWith(".class") || path.startsWith("WebServerResources") || path.startsWith(RESOURCES)) continue;
                    String nextClassName = path.substring(0, path.lastIndexOf(46));
                    nextClassName = nextClassName.replace('/', '.');
                    nextClassName = nextClassName.intern();
                    classes.addObject((Object)nextClassName);
                }
            }
        } else {
            Enumeration en = NSBundle._classPath().objectEnumerator();
            while (en.hasMoreElements()) {
                String nextPath = (String)en.nextElement();
                if (!nextPath.startsWith(this.resourcePath)) continue;
                File f = new File(nextPath);
                if (f.isDirectory()) {
                    try {
                        if (!this.bundlePath.equals(NSBundle._userDirPath()) && !f.getCanonicalPath().endsWith(RJSUFFIX)) continue;
                        classes.addObjectsFromArray(this.classNamesFromDirectory(f));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                if (!TheJavaArchiveFilter.accept(null, nextPath)) continue;
                classes.addObjectsFromArray(_NSUtilities.classNamesFromArchive(f));
            }
        }
        if (classes.count() == 0) {
            this.classesHaveBeenLoaded = false;
            this.classNames = NSArray.emptyArray();
        } else {
            this.classesHaveBeenLoaded = true;
            this.setClassNames((NSArray<String>)classes.allObjects());
        }
    }

    private void initInfoDictionary() {
        this.infoDictionary = NSDictionary.emptyDictionary();
        String infoPlistPath = this._bundleURLPrefix.concat(this.bundleType == 2 ? "Contents/Info.plist" : ResourcesInfoPlist);
        try {
            URL infoDictURL = new URL(infoPlistPath);
            this.infoDictionary = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)infoDictURL);
        }
        catch (Exception e) {
            NSLog.err.appendln((Object)("Failed to load " + infoPlistPath + ". Treating as empty. " + e));
        }
    }

    private void initName() {
        String newName = null;
        if (this.infoDictionary != null) {
            newName = (String)this.infoDictionary.objectForKey((Object)"NSExecutable");
        }
        if (newName == null && (newName = NSPathUtilities.lastPathComponent((String)this.bundlePath)).length() > 3) {
            newName = NSPathUtilities.stringByDeletingPathExtension((String)newName);
        }
        this.name = newName;
    }

    private void initPackages() {
        NSMutableArray thePackages = new NSMutableArray(this.packages);
        this.packages = new NSMutableArray();
        Enumeration en = this.classNames.objectEnumerator();
        while (en.hasMoreElements()) {
            String nextClass = (String)en.nextElement();
            String newPackage = _NSStringUtilities.stringByDeletingLastComponent(nextClass, '.');
            if (thePackages.containsObject((Object)newPackage)) continue;
            thePackages.addObject((Object)newPackage);
        }
        this.packages = thePackages.immutableClone();
    }

    private void initProperties() {
        block10: {
            String propertiesPath = this._bundleURLPrefix.concat(this.bundleType == 2 ? "Contents/" + ResourcesProperties : ResourcesProperties);
            try {
                URL propertiesURL = new URL(propertiesPath);
                this.properties = new NSProperties.NestedProperties(null);
                InputStream propertiesStream = propertiesURL.openStream();
                try {
                    this.properties.load(propertiesStream);
                }
                finally {
                    propertiesStream.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                if (!NSLegacyBundle.shouldValidateProperties()) break block10;
                try {
                    if (NSBundle._bundleUrlExists(new URL(propertiesPath))) {
                        throw new RuntimeException("Failed to load '" + propertiesPath + "'.", fnfe);
                    }
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Failed to load '" + propertiesPath + "'.", e);
                }
            }
            catch (Exception e) {
                if (NSLegacyBundle.shouldValidateProperties()) {
                    throw new RuntimeException("Failed to load '" + propertiesPath + "'.", e);
                }
                NSLog.err.appendln((Object)("Error reading properties file " + propertiesPath + ". Exception was " + e));
                NSLog.err.appendln((Object)"Ignoring this file.");
                this.properties = null;
            }
        }
    }

    private void initResourceBuckets() {
        this.resourceBuckets = new NSMutableArray();
        if (this.isJar) {
            this._resourceLocation = RESOURCES;
            if (this.jarFile.getEntry(this._resourceLocation) != null) {
                this.addResourceBucket(this._resourceLocation);
            }
        } else {
            String resourceLocation;
            switch (this.bundleType) {
                case 1: {
                    resourceLocation = RESOURCES;
                    break;
                }
                case 2: {
                    resourceLocation = _NSStringUtilities.concat(CONTENTS, File.separator, RESOURCES);
                    break;
                }
                default: {
                    throw new IllegalStateException("Inconsistent Bundle type");
                }
            }
            File rlFile = new File(_NSStringUtilities.concat(this.bundlePath, File.separator, resourceLocation));
            if (rlFile.exists()) {
                this._resourceLocation = NSPathUtilities.stringByNormalizingExistingPath((String)_NSStringUtilities.concat(this.bundlePath, File.separator, resourceLocation)).substring(this.bundlePath.length() + 1);
                this.addResourceBucket(this._resourceLocation);
            } else if (this.bundleType == 2) {
                throw new IllegalStateException("Bundle at path \"" + this.bundlePath + "\" is a CFBundle, but is missing its \"Contents" + File.separator + "Resources\" subdirectory.");
            }
        }
        this.addResourceBucket("");
    }

    private void initContentsPath() {
        if (this.isJar) {
            this.contentsPath = this._bundleURLPrefix;
        } else {
            switch (this.bundleType) {
                case 1: {
                    this.contentsPath = this.bundlePath;
                    break;
                }
                case 2: {
                    File contentsDir = new File(this.bundlePath.concat(CSUFFIX));
                    if (contentsDir.exists()) {
                        try {
                            this.contentsPath = contentsDir.getCanonicalPath();
                            break;
                        }
                        catch (IOException e) {
                            throw NSForwardException._runtimeExceptionForThrowable(e);
                        }
                    }
                    this.contentsPath = this.bundlePath;
                    break;
                }
                default: {
                    throw new IllegalStateException("Inconsistent Bundle type");
                }
            }
        }
    }

    private void initResourcePath() {
        if (this.isJar) {
            this.resourcePath = this.contentsPath.concat(RESOURCES);
        } else {
            switch (this.bundleType) {
                case 1: {
                    File resourceDir = new File(this.bundlePath.concat(RSUFFIX));
                    if (resourceDir.exists()) {
                        try {
                            this.resourcePath = resourceDir.getCanonicalPath();
                            break;
                        }
                        catch (IOException e) {
                            throw NSForwardException._runtimeExceptionForThrowable(e);
                        }
                    }
                    this.resourcePath = this.bundlePath;
                    break;
                }
                case 2: {
                    File resourceDir = new File(this.bundlePath.concat(CRSUFFIX));
                    if (resourceDir.exists()) {
                        try {
                            this.resourcePath = resourceDir.getCanonicalPath();
                            break;
                        }
                        catch (IOException e) {
                            throw NSForwardException._runtimeExceptionForThrowable(e);
                        }
                    }
                    this.resourcePath = this.bundlePath;
                    break;
                }
                default: {
                    throw new IllegalStateException("Inconsistent Bundle type");
                }
            }
        }
    }

    private void postNotification() {
        NSNotificationCenter.defaultCenter().postNotification(BundleDidLoadNotification, (Object)this, new NSDictionary(this.classNames, (Object)LoadedClassesNotification));
    }

    protected boolean _prefixPathWithNonLocalizedPrefixJar(String aPath) {
        return aPath.equals(this._resourceLocation);
    }

    private String fixExtension(String anExtension) {
        return anExtension == null ? "" : (anExtension.startsWith(".") ? anExtension.substring(1) : anExtension);
    }

    @Override
    public void _simplePathsInDirectoryInJar(String startPath, String dirExtension, NSMutableArray<String> dirs, String fileExtension, NSMutableArray<String> files) {
        block5: {
            NSArray keyArray;
            NSDictionary filesDict;
            String aPath;
            block4: {
                if (startPath.length() != 0 && !startPath.equals(".") && !startPath.equals("/")) break block4;
                Enumeration e = this.jarFileLayout.keyEnumerator();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    NSDictionary value = (NSDictionary)this.jarFileLayout.objectForKey((Object)key);
                    if (value == TheFileDict) {
                        if (!key.endsWith(fileExtension) || files == null) continue;
                        files.addObject((Object)key);
                        continue;
                    }
                    if (!key.endsWith(dirExtension) || dirs == null) continue;
                    dirs.addObject((Object)key);
                }
                break block5;
            }
            String string = aPath = !startPath.endsWith("/") ? startPath.concat("/") : startPath;
            if (this.jarFile.getEntry(aPath) == null || (filesDict = (NSDictionary)_NSUtilities.valueForKeyArray((NSKeyValueCoding)this.jarFileLayout, keyArray = NSArray.componentsSeparatedByString((String)aPath.substring(0, aPath.length() - 1), (String)"/"))) == null) break block5;
            Enumeration e = filesDict.keyEnumerator();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                NSDictionary value = (NSDictionary)filesDict.objectForKey((Object)key);
                if (value == TheFileDict) {
                    if (!key.endsWith(fileExtension) || files == null) continue;
                    files.addObject((Object)key);
                    continue;
                }
                if (!key.endsWith(dirExtension) || dirs == null) continue;
                dirs.addObject((Object)key);
            }
        }
    }

    private NSArray<String> resourcePathsForDirectoriesInDirectoryInJar(String startPath, String anExtension, boolean prependNonlocalizedLProj) {
        String dirName;
        NSMutableArray returnList = new NSMutableArray();
        NSMutableArray dirNames = new NSMutableArray();
        this._simplePathsInDirectoryInJar(startPath, anExtension, (NSMutableArray<String>)dirNames, "", null);
        String prefix = this._prefixPathWithNonLocalizedPrefixJar(startPath) ? "" : startPath.substring(this._resourceLocation.concat("/").length());
        int i = 0;
        while (i < dirNames.count()) {
            dirName = (String)dirNames.objectAtIndex(i);
            if (prefix.length() == 0) {
                if (dirName.endsWith(".lproj")) {
                    returnList.addObject((Object)dirName);
                } else {
                    returnList.addObject((Object)_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", dirName));
                }
            } else if (prependNonlocalizedLProj) {
                returnList.addObject((Object)_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", prefix, "/", dirName));
            } else {
                returnList.addObject((Object)_NSStringUtilities.concat(prefix, "/", dirName));
            }
            ++i;
        }
        i = 0;
        while (i < dirNames.count()) {
            dirName = (String)dirNames.objectAtIndex(i);
            if (prefix.length() == 0) {
                boolean endWithLPROJ = dirName.endsWith(".lproj");
                returnList.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectoryInJar(_NSStringUtilities.concat(startPath, "/", dirName), anExtension, !endWithLPROJ));
            } else {
                returnList.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectoryInJar(_NSStringUtilities.concat(startPath, "/", dirName), anExtension, prependNonlocalizedLProj));
            }
            ++i;
        }
        if (returnList.count() == 0) {
            return NSArray.emptyArray();
        }
        return returnList;
    }

    private NSArray<String> resourcePathsForResourcesInDirectoryInJar(String aPath, String anExtension, boolean prependNonlocalizedLProj) {
        NSMutableArray returnList = new NSMutableArray();
        NSMutableArray fileNames = new NSMutableArray();
        NSMutableArray dirNames = new NSMutableArray();
        this._simplePathsInDirectoryInJar(aPath, "", (NSMutableArray<String>)dirNames, anExtension, (NSMutableArray<String>)fileNames);
        String prefix = this._prefixPathWithNonLocalizedPrefixJar(aPath) ? "" : aPath.substring(this._resourceLocation.concat("/").length());
        int i = 0;
        while (i < fileNames.count()) {
            String fileName = (String)fileNames.objectAtIndex(i);
            if (prefix.length() == 0) {
                returnList.addObject((Object)_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", fileName));
            } else if (prependNonlocalizedLProj) {
                returnList.addObject((Object)_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", prefix, "/", fileName));
            } else {
                returnList.addObject((Object)_NSStringUtilities.concat(prefix, "/", fileName));
            }
            ++i;
        }
        i = 0;
        while (i < dirNames.count()) {
            String dirName = (String)dirNames.objectAtIndex(i);
            boolean prepend = prefix.length() == 0 ? !dirName.endsWith(".lproj") : prependNonlocalizedLProj;
            returnList.addObjectsFromArray(this.resourcePathsForResourcesInDirectoryInJar(_NSStringUtilities.concat(aPath, "/", dirName), anExtension, prepend));
            ++i;
        }
        if (returnList.count() == 0) {
            return NSArray.emptyArray();
        }
        return returnList;
    }

    private void setClassNames(NSArray<String> classes) {
        if (classes != null) {
            NSMutableArray theClasses = new NSMutableArray(this.classNames);
            Enumeration en = classes.objectEnumerator();
            while (en.hasMoreElements()) {
                String nextClassName = (String)en.nextElement();
                if (theClasses.containsObject((Object)nextClassName)) continue;
                theClasses.addObject((Object)nextClassName);
                NSBundle._registerClassNameForBundle(nextClassName, this);
            }
            this.classNames = theClasses.immutableClone();
        }
    }

    protected static boolean shouldValidateProperties() {
        return Boolean.valueOf(System.getProperty("NSValidateProperties", "true"));
    }

    public static class Factory
    extends NSBundleFactory {
        public static NSBundle _bundleWithPathShouldCreateIsJar(String aPath, boolean shouldCreateBundle, boolean newIsJar) {
            NSBundle bundle = null;
            String normalizedPath = null;
            String cleanedPath = null;
            NSBundle mainBundle = NSBundle.mainBundle();
            if (mainBundle != null && mainBundle.name().equals(aPath)) {
                bundle = mainBundle;
            }
            if (bundle == null) {
                bundle = NSBundle.bundleForName(aPath);
            }
            if (bundle == null) {
                normalizedPath = NSBundle._normalizeExistingBundlePath(aPath);
                bundle = NSBundle._lookupBundleWithPath(normalizedPath);
            }
            if (bundle == null) {
                cleanedPath = NSBundle._cleanNormalizedBundlePath(normalizedPath);
                bundle = NSBundle._lookupBundleWithPath(cleanedPath);
            }
            if (bundle == null && shouldCreateBundle) {
                if (newIsJar) {
                    try {
                        URL url = new URL(_NSStringUtilities.concat("jar:", NSPathUtilities._fileURLPrefix, aPath, "!/").concat(ResourcesInfoPlist));
                        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                        jarConnection.getJarFile();
                        bundle = new NSLegacyBundle(aPath, true);
                        ((NSLegacyBundle)bundle)._init();
                    }
                    catch (Exception exception) {}
                } else {
                    bundle = new NSLegacyBundle(cleanedPath, false);
                    ((NSLegacyBundle)bundle)._init();
                }
            }
            return bundle;
        }

        public NSBundle bundleForPath(String path, boolean shouldCreateBundle, boolean newIsJar) {
            NSBundle bundle = null;
            if (newIsJar) {
                bundle = Factory._bundleWithPathShouldCreateIsJar(path, shouldCreateBundle, true);
            } else if (!shouldCreateBundle) {
                bundle = Factory._bundleWithPathShouldCreateIsJar(path, false, false);
            } else {
                int index = path.lastIndexOf(RSUFFIX);
                NSMutableArray resourcesSubdirs = new NSMutableArray();
                if (index == -1) {
                    resourcesSubdirs.addObject((Object)path.concat(RSUFFIX));
                    resourcesSubdirs.addObject((Object)path.concat(CSUFFIX));
                } else {
                    resourcesSubdirs.addObject((Object)path.substring(0, index + RSUFFIX.length()));
                }
                for (String oneSubdir : resourcesSubdirs) {
                    String infoDictPath = String.valueOf(oneSubdir) + File.separator + NSLegacyBundle.InfoPlistFilename;
                    File file = new File(infoDictPath);
                    if (!file.exists()) continue;
                    bundle = Factory._bundleWithPathShouldCreateIsJar(path, true, false);
                    break;
                }
            }
            return bundle;
        }
    }
}

