/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.development.NSLegacyBundle;
import com.webobjects.foundation.development.NSResourceType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NSProjectBundle
extends NSBundle {
    protected static final String NONLOCALIZED_LOCALE = "Nonlocalized.lproj";
    protected static final String NONLOCALIZED_LOCALE_PREFIX = "Nonlocalized.lproj" + File.separator;
    private static ConcurrentHashMap<String, NSResourceType> _resourceTypeExtensions = new ConcurrentHashMap();
    private String _projectPath;
    private String _bundleURLPrefix;
    private LinkedHashSet<String> _classpathPaths;
    private Properties _properties;
    private Class _principalClass;
    private NSArray<String> _packageNames;
    private NSArray<String> _classNames;

    static {
        _resourceTypeExtensions.put("wo", NSResourceType.Component);
        _resourceTypeExtensions.put("eomodeld", NSResourceType.Model);
        _resourceTypeExtensions.put("d2wmodel", NSResourceType.D2WModel);
        _resourceTypeExtensions.put("gif", NSResourceType.WebServer);
        _resourceTypeExtensions.put("png", NSResourceType.WebServer);
        _resourceTypeExtensions.put("jpg", NSResourceType.WebServer);
        _resourceTypeExtensions.put("jpeg", NSResourceType.WebServer);
        _resourceTypeExtensions.put("tiff", NSResourceType.WebServer);
        _resourceTypeExtensions.put("js", NSResourceType.WebServer);
        _resourceTypeExtensions.put("css", NSResourceType.WebServer);
    }

    public static void registerResourceTypeForExtension(NSResourceType resourceType, String extension) {
        _resourceTypeExtensions.put(extension, resourceType);
    }

    public NSProjectBundle(String projectPath) {
        this._projectPath = projectPath;
        this._bundleURLPrefix = _NSStringUtilities.concat(NSPathUtilities._fileURLPrefix, this._projectPath, "/");
        this._classpathPaths = new LinkedHashSet();
    }

    public void _bundleLoadedFromPath(String path) {
        this._classpathPaths.add(path);
    }

    @Override
    public void _bundlesDidLoad() {
        this.ensureClassAndPackageNamesLoaded();
    }

    public String projectPath() {
        return this._projectPath;
    }

    @Override
    public String bundlePath() {
        return this._projectPath;
    }

    @Override
    public URL bundlePathURL() {
        try {
            return new File(this._projectPath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    @Override
    public String _bundleURLPrefix() {
        return this._bundleURLPrefix;
    }

    protected void fillInClassNames(Set<String> packageNames, Set<String> classNames, File folder, NSMutableArray<String> packageNameArray) {
        File[] files = folder.listFiles();
        if (files != null) {
            String packageName = null;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                if (file.isDirectory()) {
                    if (!name.equals("CVS") && !name.equals(".svn")) {
                        packageNameArray.addObject((Object)name);
                        try {
                            this.fillInClassNames(packageNames, classNames, file, packageNameArray);
                        }
                        finally {
                            packageNameArray.removeLastObject();
                        }
                    }
                } else if (name.endsWith(".class")) {
                    if (packageName == null) {
                        packageName = packageNameArray.componentsJoinedByString(".");
                        packageNames.add(packageName);
                    }
                    String className = String.valueOf(packageName) + "." + name.substring(0, name.length() - ".class".length());
                    classNames.add(className);
                    NSBundle._registerClassNameForBundle(className, this);
                }
                ++n2;
            }
        }
    }

    protected void fillInClassNamesFromJar(Set<String> packageNames, Set<String> classNames, File jarFile) {
        NSArray jarClassNames = _NSUtilities.classNamesFromArchive(jarFile);
        for (String className : jarClassNames) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String packageName = className.substring(0, lastDotIndex);
                packageNames.add(packageName);
            }
            classNames.add(className);
            NSBundle._registerClassNameForBundle(className, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillInClassAndPackageNames() {
        HashSet<String> packageNames = new HashSet<String>();
        HashSet<String> classNames = new HashSet<String>();
        for (String classpathPath : this._classpathPaths) {
            File classpathFile = new File(classpathPath);
            if (classpathFile.isDirectory()) {
                NSMutableArray packageName = new NSMutableArray();
                this.fillInClassNames(packageNames, classNames, classpathFile, (NSMutableArray<String>)packageName);
                continue;
            }
            this.fillInClassNamesFromJar(packageNames, classNames, classpathFile);
        }
        NSProjectBundle nSProjectBundle = this;
        synchronized (nSProjectBundle) {
            this._packageNames = new NSArray(packageNames);
            this._classNames = new NSArray(classNames);
        }
    }

    protected void ensureClassAndPackageNamesLoaded() {
        if (this._packageNames == null || this._classNames == null) {
            this.fillInClassAndPackageNames();
        }
    }

    @Override
    public synchronized NSArray<String> bundleClassPackageNames() {
        this.ensureClassAndPackageNamesLoaded();
        return this._packageNames;
    }

    @Override
    public synchronized NSArray<String> bundleClassNames() {
        this.ensureClassAndPackageNamesLoaded();
        return this._classNames;
    }

    @Override
    public URL _pathURLForResourcePath(String aResourcePath, boolean returnDirectories) {
        URL url = null;
        if (aResourcePath != null && aResourcePath.length() > 0) {
            String realPath;
            boolean isLocalized = true;
            if (aResourcePath.startsWith(NONLOCALIZED_LOCALE)) {
                isLocalized = false;
            }
            if (!(realPath = isLocalized ? aResourcePath : aResourcePath.substring(NONLOCALIZED_LOCALE.length())).startsWith(File.separator)) {
                realPath = File.separator.concat(realPath);
            }
            for (String resourcePath : this.relativePathForResourceType(this.resourceTypeForResourceNamed(aResourcePath))) {
                try {
                    File f = new File(String.valueOf(this._projectPath) + File.separator + resourcePath + realPath);
                    if (!f.exists() || !f.isFile() && !returnDirectories) continue;
                    url = NSPathUtilities._URLWithPath((String)f.getCanonicalPath());
                    break;
                }
                catch (Exception exception) {
                    throw NSForwardException._runtimeExceptionForThrowable(exception);
                }
            }
        }
        return url;
    }

    @Override
    public boolean isFramework() {
        return "FMWK".equals(this.infoDictionary().objectForKey((Object)"CFBundlePackageType"));
    }

    @Override
    public boolean _isCFBundle() {
        return false;
    }

    @Override
    public boolean isJar() {
        return false;
    }

    @Override
    public JarFile _jarFile() {
        return null;
    }

    @Override
    public NSDictionary _jarFileLayout() {
        return null;
    }

    @Override
    public boolean load() {
        return false;
    }

    @Override
    public String name() {
        return (String)this.infoDictionary().objectForKey((Object)"NSExecutable");
    }

    @Override
    public String pathForResource(String aName, String anExtension, String aSubDirPath) {
        throw new RuntimeException("NSProjectBundle.pathForResource: " + aName + ":" + anExtension + ":" + aSubDirPath);
    }

    @Override
    public NSArray pathsForResources(String anExtension, String aSubDirPath) {
        throw new RuntimeException("NSProjectBundle.pathsForResources: " + anExtension + ":" + aSubDirPath);
    }

    @Override
    public Class principalClass() {
        return this._principalClass;
    }

    @Override
    public Properties properties() {
        if (this._properties == null) {
            NSProperties.NestedProperties properties;
            block11: {
                properties = new NSProperties.NestedProperties(null);
                String propertiesPath = this.resourcePathForLocalizedResourceNamed("Properties", null);
                try {
                    InputStream propertiesStream = this.inputStreamForResourcePath(propertiesPath);
                    if (propertiesStream == null) break block11;
                    try {
                        properties.load(propertiesStream);
                    }
                    finally {
                        propertiesStream.close();
                    }
                }
                catch (FileNotFoundException fnfe) {
                    if (!NSLegacyBundle.shouldValidateProperties()) break block11;
                    try {
                        if (NSBundle._bundleUrlExists(new URL(propertiesPath))) {
                            throw new RuntimeException("Failed to load '" + propertiesPath + "'.", fnfe);
                        }
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("Failed to load '" + propertiesPath + "'.", e);
                    }
                }
                catch (Exception e) {
                    if (NSLegacyBundle.shouldValidateProperties()) {
                        throw new RuntimeException("Failed to load '" + propertiesPath + "'.", e);
                    }
                    NSLog.err.appendln((Object)("Error reading properties file " + propertiesPath + ". Exception was " + e));
                    NSLog.err.appendln((Object)"Ignoring this file.");
                }
            }
            this._properties = properties;
        }
        return this._properties;
    }

    @Override
    public String resourcePath() {
        return this.bundlePath();
    }

    @Override
    public String resourcePathForLocalizedResourceNamed(String aName, String aSubDirPath) {
        return this.resourcePathForLocalizedResourceNamed(aName, aSubDirPath, this.relativePathForResourceType(this.resourceTypeForResourceNamed(aName)));
    }

    @Override
    public NSArray<String> resourcePathsForDirectories(String extension, String aSubDirPath) {
        NSMutableArray list = null;
        FilenameFilter rdf = extension == null ? TheDirectoryFilter : NSProjectBundle.ResourceDirectoryFilterForExtension(extension);
        NSMutableArray masterList = new NSMutableArray();
        for (String relativeResourcePath : this.relativePathForResourceType(this.resourceTypeForResourceWithExtension(extension))) {
            String resourcePath = _NSStringUtilities.concat(this._projectPath, File.separator, relativeResourcePath);
            if (aSubDirPath == null) {
                NSMutableArray allPaths = new NSMutableArray(this.resourcePathsForDirectoriesInDirectory(resourcePath, resourcePath, rdf, false));
                NSArray<String> lProjDirs = this.resourcePathsForDirectoriesInDirectory(resourcePath, resourcePath, NSProjectBundle.ResourceDirectoryFilterForExtension(".lproj"), false);
                int count = lProjDirs.count();
                int i = 0;
                while (i < count) {
                    String lProjDir = (String)lProjDirs.objectAtIndex(i);
                    allPaths.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(resourcePath, File.separator, lProjDir), resourcePath, rdf, false));
                    ++i;
                }
                list = allPaths;
            } else {
                String absolutePath = NSPathUtilities.stringByNormalizingExistingPath((String)_NSStringUtilities.concat(resourcePath, File.separator, aSubDirPath));
                if (absolutePath.startsWith(resourcePath.concat(File.separator))) {
                    list = this.resourcePathsForDirectoriesInDirectory(absolutePath, resourcePath, rdf, false);
                }
            }
            if (list == null) continue;
            masterList.addObjectsFromArray(list);
        }
        if (masterList == null || masterList.count() == 0) {
            return NSArray.emptyArray();
        }
        return masterList;
    }

    @Override
    public NSArray<String> resourcePathsForLocalizedResources(String extension, String aSubDirPath) {
        throw new RuntimeException("NSProjectBundle.resourcePathsForLocalizedResources: " + extension + ":" + aSubDirPath);
    }

    @Override
    public NSArray<String> resourcePathsForResources(String extension, String aSubDirPath) {
        String anExtension = extension;
        FilenameFilter rf = anExtension == null ? TheFilesFilter : NSProjectBundle.ResourceFilterForExtension(anExtension);
        NSMutableArray masterList = new NSMutableArray();
        for (String relativeResourcePath : this.relativePathForResourceType(this.resourceTypeForResourceWithExtension(extension))) {
            String resourcePath = _NSStringUtilities.concat(this._projectPath, File.separator, relativeResourcePath);
            NSArray<String> list = null;
            if (aSubDirPath == null) {
                list = this.resourcePathsForResourcesInDirectory(resourcePath, resourcePath, rf, false);
            } else {
                String absolutePath = NSPathUtilities.stringByNormalizingExistingPath((String)_NSStringUtilities.concat(resourcePath, File.separator, aSubDirPath));
                if (absolutePath.startsWith(resourcePath.concat(File.separator))) {
                    boolean prependNonLocalizedLproj = aSubDirPath.indexOf(".lproj") == -1;
                    list = this.resourcePathsForResourcesInDirectory(absolutePath, resourcePath, rf, prependNonLocalizedLproj);
                }
            }
            if (list == null) continue;
            masterList.addObjectsFromArray(list);
        }
        if (masterList == null || masterList.count() == 0) {
            return NSArray.emptyArray();
        }
        return masterList;
    }

    @Override
    public void _simplePathsInDirectoryInJar(String startPath, String dirExtension, NSMutableArray<String> dirs, String fileExtension, NSMutableArray<String> files) {
        throw new RuntimeException("NSProjectBundle._simplePathsInDirectoryInJar: " + startPath + ", " + dirExtension + "," + dirs + "," + fileExtension + "," + files);
    }

    public NSResourceType resourceTypeForResourceWithExtension(String extension) {
        NSResourceType resourceType = null;
        if (extension != null) {
            resourceType = _resourceTypeExtensions.get(extension);
        }
        if (resourceType == null) {
            resourceType = NSResourceType.Other;
        }
        return resourceType;
    }

    public NSResourceType resourceTypeForResourceNamed(String resourceName) {
        return this.resourceTypeForResourceWithExtension(NSPathUtilities.pathExtension((String)resourceName));
    }

    public abstract List<String> relativePathForResourceType(NSResourceType var1);
}

