/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.foundation.ERXValueUtilities;
import er.grouping.DRAttribute;
import java.util.Enumeration;

public class DRAttributeGroup
extends DRAttribute {
    protected NSMutableArray _attributes;
    protected NSMutableArray _flatAttributes;
    protected NSMutableArray _flatAttributesTotal;

    public static DRAttributeGroup withKeyPathFormatLabelTotalListUserInfo(String keyPath, String format, String label, boolean shouldTotal, NSArray attributes, NSDictionary userInfo) {
        DRAttributeGroup attributeGroup = new DRAttributeGroup(keyPath, format, label, shouldTotal, attributes, userInfo);
        return attributeGroup;
    }

    public void resetDefaults() {
        super.resetDefaults();
        this._attributes = new NSMutableArray();
        this._flatAttributes = new NSMutableArray();
        this._isGroup = true;
        this._flatAttributesTotal = null;
    }

    public DRAttributeGroup(String keyPath, String format, String label, boolean shouldTotal, NSArray attributes, NSDictionary userInfo) {
        super(keyPath, format, label, shouldTotal, userInfo);
        if (attributes != null) {
            this._attributes.addObjectsFromArray(attributes);
        }
        this.flatListForAttributeList();
    }

    public DRAttributeGroup(NSDictionary dictionary, NSArray subAttributes) {
        this((String)dictionary.objectForKey((Object)"keyPath"), (String)dictionary.objectForKey((Object)"format"), (String)dictionary.objectForKey((Object)"label"), ERXValueUtilities.booleanValue((Object)dictionary.objectForKey((Object)"total")), subAttributes, (NSDictionary)dictionary.objectForKey((Object)"userInfo"));
    }

    public boolean showTotal() {
        return this._shouldTotal;
    }

    public boolean isGroup() {
        return this._isGroup;
    }

    public NSMutableArray attributes() {
        return this._attributes;
    }

    protected void flatListForAttributeDepthDictionary(DRAttribute att, int attributeListDepth, NSMutableDictionary flatAttributeDepthDict) {
        if (!att.isGroup()) {
            this._flatAttributes.addObject((Object)att);
        } else {
            NSArray subvls = att.flatAttributesWithDepthDictionary(attributeListDepth, flatAttributeDepthDict);
            this._flatAttributes.addObjectsFromArray(subvls);
            if (att.shouldTotal()) {
                this._flatAttributes.addObject((Object)att);
            }
        }
        if (flatAttributeDepthDict != null) {
            Integer dpthKey = new Integer(attributeListDepth);
            NSMutableArray lst = (NSMutableArray)flatAttributeDepthDict.objectForKey((Object)dpthKey);
            if (lst == null) {
                lst = new NSMutableArray();
                flatAttributeDepthDict.setObjectForKey((Object)lst, (Object)dpthKey);
            }
            lst.addObject((Object)att);
        }
    }

    protected NSArray flatAttributesWithDepthDictionary(int attributeListDepth, NSMutableDictionary flatAttributeDepthDict) {
        Enumeration anEnum = this._attributes.objectEnumerator();
        this._flatAttributes.removeAllObjects();
        ++attributeListDepth;
        while (anEnum.hasMoreElements()) {
            DRAttribute att = (DRAttribute)anEnum.nextElement();
            this.flatListForAttributeDepthDictionary(att, attributeListDepth, flatAttributeDepthDict);
        }
        if (flatAttributeDepthDict != null && this.showTotal()) {
            Integer dpthKey = new Integer(attributeListDepth);
            NSMutableArray lst = (NSMutableArray)flatAttributeDepthDict.objectForKey((Object)dpthKey);
            if (lst == null) {
                lst = new NSMutableArray();
                flatAttributeDepthDict.setObjectForKey((Object)lst, (Object)dpthKey);
            }
            lst.addObject((Object)DRAttribute.withAttributeGroup(this));
        }
        return this._flatAttributes;
    }

    protected void flatListForAttributeList() {
        this.flatAttributesWithDepthDictionary(0, null);
    }

    public NSArray flatAttributes() {
        return this._flatAttributes;
    }

    public NSArray flatAttributesTotal() {
        if (this._flatAttributesTotal == null) {
            Enumeration anEnum = this.flatAttributes().objectEnumerator();
            this._flatAttributesTotal = new NSMutableArray();
            while (anEnum.hasMoreElements()) {
                DRAttribute att = (DRAttribute)anEnum.nextElement();
                if (!att.shouldTotal()) continue;
                this._flatAttributesTotal.addObject((Object)att);
            }
        }
        return this._flatAttributesTotal;
    }

    public String toString() {
        return "<DRAttributeGroup keyPath:\"" + this.keyPath() + "\"; label:\"" + this.label() + "\"; attributes: " + this.attributes() + "; >";
    }
}

