/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOSession;
import com.webobjects.directtoweb.D2W;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.directtoweb.D2WPage;
import com.webobjects.directtoweb.EditPageInterface;
import com.webobjects.directtoweb.InspectPageInterface;
import com.webobjects.directtoweb.ListPageInterface;
import com.webobjects.directtoweb.NextPageDelegate;
import com.webobjects.directtoweb.QueryPageInterface;
import com.webobjects.eoaccess.EODatabaseDataSource;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOArrayDataSource;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import er.bugtracker.Bug;
import er.bugtracker.Component;
import er.bugtracker.Framework;
import er.bugtracker.People;
import er.bugtracker.Priority;
import er.bugtracker.Release;
import er.bugtracker.Requirement;
import er.bugtracker.Session;
import er.bugtracker.State;
import er.bugtracker.TestItem;
import er.bugtracker.TestItemState;
import er.bugtracker.pages.ReportPage;
import er.directtoweb.ERD2WFactory;
import er.directtoweb.interfaces.ERDQueryPageInterface;
import er.directtoweb.pages.ERD2WInspectPage;
import er.directtoweb.pages.ERD2WQueryPage;
import er.extensions.appserver.ERXSession;
import er.extensions.appserver.navigation.ERXNavigationManager;
import er.extensions.eof.EOEnterpriseObjectClazz;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;

public class Factory
extends ERD2WFactory
implements NSKeyValueCoding {
    public void takeValueForKey(Object value, String key) {
        throw new UnsupportedOperationException("Can't takeValueForKey");
    }

    public Object valueForKey(String key) {
        key = ERXStringUtilities.uncapitalize((String)key);
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)((Object)this), (String)key);
    }

    public WOComponent pageWithContextTaskEntity(D2WContext d2wcontext, String task, String entity, WOContext wocontext) {
        WOComponent nextPage = super.pageWithContextTaskEntity(d2wcontext, task, entity, wocontext);
        if (nextPage instanceof D2WPage) {
            String oldState = ERXNavigationManager.manager().navigationStateForSession(wocontext.session()).stateAsString();
            D2WPage page = (D2WPage)nextPage;
            page.setNextPage(this.currentPage());
            String newState = (String)page.d2wContext().valueForKey("navigationState");
            if (oldState != null && (newState == null || oldState.startsWith(newState))) {
                page.d2wContext().takeValueForKey((Object)oldState, "navigationState");
            }
            log.debug((Object)("Create page: " + page.d2wContext().dynamicPage() + " old: " + oldState + " news: " + newState));
        }
        return nextPage;
    }

    public EditPageInterface editPageNamed(String pageConfiguration, EOEnterpriseObject eo) {
        EditPageInterface epi = (EditPageInterface)this.inspectPageNamed(pageConfiguration, eo);
        epi.setObject(eo);
        return epi;
    }

    public InspectPageInterface inspectPageNamed(String pageConfiguration, EOEnterpriseObject eo) {
        InspectPageInterface epi = (InspectPageInterface)this.pageForConfigurationNamed(pageConfiguration, (WOSession)this.session());
        epi.setObject(eo);
        return epi;
    }

    protected InspectPageInterface createPageNamed(String name) {
        EditPageInterface epi = this.editPageForNewObjectWithConfigurationNamed(name, (WOSession)this.session());
        epi.setNextPage(this.homePage());
        return epi;
    }

    protected void applyCurrentUser(EOEnterpriseObject eo, String relationshipName) {
        EOEditingContext ec = eo.editingContext();
        People user = this.currentUser(ec);
        eo.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)user, relationshipName);
    }

    protected ListPageInterface listPageNamed(String name, EODataSource ds) {
        ListPageInterface lpi = (ListPageInterface)this.pageForConfigurationNamed(name);
        lpi.setDataSource(ds);
        return lpi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListPageInterface listPageNamed(String name, EOEnterpriseObjectClazz clazz) {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            EODatabaseDataSource ds = clazz.newDatabaseDataSource(ec);
            ListPageInterface listPageInterface = this.listPageNamed(name, (EODataSource)ds);
            return listPageInterface;
        }
        finally {
            ec.unlock();
        }
    }

    protected WOComponent pageForConfigurationNamed(String name) {
        WOComponent page = D2W.factory().pageForConfigurationNamed(name, (WOSession)this.session());
        page.takeValueForKey((Object)this.pageWithName("HomePage"), "nextPage");
        return page;
    }

    private Session session() {
        return (Session)ERXSession.anySession();
    }

    public WOComponent currentPage() {
        return this.session().context().page();
    }

    private People currentUser(EOEditingContext ec) {
        ec = ec == null ? this.session().defaultEditingContext() : ec;
        return People.clazz.currentUser(ec);
    }

    protected WOComponent pageWithName(String name) {
        return WOApplication.application().pageWithName(name, this.session().context());
    }

    public WOComponent homePage() {
        return this.pageWithName("HomePage");
    }

    public static Factory bugTracker() {
        return (Factory)D2W.factory();
    }

    public WOComponent createComponent() {
        ERD2WInspectPage page = (ERD2WInspectPage)this.createPageNamed("CreateComponent");
        Component eo = (Component)page.object();
        this.applyCurrentUser((EOEnterpriseObject)eo, "owner");
        return page;
    }

    public WOComponent listComponents() {
        return (WOComponent)this.listPageNamed("ListComponent", (EOEnterpriseObjectClazz)Component.clazz);
    }

    public WOComponent createPeople() {
        ERD2WInspectPage page = (ERD2WInspectPage)this.createPageNamed("CreatePeople");
        EOEnterpriseObject eo = page.object();
        return page;
    }

    public WOComponent signUp() {
        ERD2WInspectPage page;
        People signUp = this.session().signUp();
        if (signUp == null) {
            page = (ERD2WInspectPage)this.createPageNamed("SignUpPeople");
            signUp = (People)page.object();
            this.session().setSignUp(signUp);
        } else {
            page = (ERD2WInspectPage)this.editPageNamed("SignUpPeople", (EOEnterpriseObject)signUp);
        }
        page.setNextPageDelegate(new NextPageDelegate(){

            public WOComponent nextPage(WOComponent arg0) {
                if (page.objectWasSaved()) {
                    Factory.this.session().finishSignUp();
                } else {
                    Factory.this.session().setSignUp(null);
                }
                return Factory.this.homePage();
            }
        });
        return page;
    }

    public WOComponent listPeoples() {
        return (WOComponent)this.listPageNamed("ListPeople", (EOEnterpriseObjectClazz)People.clazz);
    }

    public WOComponent createFramework() {
        ERD2WInspectPage page = (ERD2WInspectPage)this.createPageNamed("CreateFramework");
        EOEnterpriseObject eo = page.object();
        this.applyCurrentUser(eo, "owner");
        return page;
    }

    public WOComponent listFrameworks() {
        return (WOComponent)this.listPageNamed("ListFramework", (EOEnterpriseObjectClazz)Framework.clazz);
    }

    public WOComponent createRequirement() {
        ERD2WInspectPage page = (ERD2WInspectPage)this.createPageNamed("CreateRequirement");
        EOEnterpriseObject eo = page.object();
        this.applyCurrentUser(eo, "originator");
        this.applyCurrentUser(eo, "owner");
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent listMyRequirements() {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            NSArray array = Requirement.clazz.myRequirementsWithUser(ec, People.clazz.currentUser(ec));
            EOArrayDataSource ds = Requirement.clazz.newArrayDataSource(ec);
            ds.setArray(array);
            WOComponent wOComponent = (WOComponent)this.listPageNamed("ListMyRequirement", (EODataSource)ds);
            return wOComponent;
        }
        finally {
            ec.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent listRecentRequirements() {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            WOComponent page;
            EODatabaseDataSource ds = Requirement.clazz.newDatabaseDataSource(ec);
            EOFetchSpecification fs = Requirement.clazz.fetchSpecificationForRecentBugs();
            ds.setFetchSpecification(fs);
            WOComponent wOComponent = page = (WOComponent)this.listPageNamed("ListRecentRequirement", (EODataSource)ds);
            return wOComponent;
        }
        finally {
            ec.unlock();
        }
    }

    public WOComponent queryRequirements() {
        return this.pageForConfigurationNamed("QueryRequirement");
    }

    public WOComponent createTestItem() {
        ERD2WInspectPage page = (ERD2WInspectPage)this.createPageNamed("CreateTestItem");
        EOEnterpriseObject eo = page.object();
        this.applyCurrentUser(eo, "owner");
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent createBugFromTestItem(TestItem testItem) {
        EOEditingContext peer = ERXEC.newEditingContext((EOObjectStore)testItem.editingContext().parentObjectStore());
        EditPageInterface epi = null;
        peer.lock();
        try {
            testItem = (TestItem)testItem.localInstanceIn(peer);
            People user = People.clazz.currentUser(peer);
            Component component = testItem.component();
            Bug bug = (Bug)Bug.clazz.createAndInsertObject(peer);
            testItem.setState(TestItemState.BUG);
            bug.setTextDescription("[From Test #" + testItem.primaryKey() + "]");
            bug.addToTestItems(testItem);
            bug.setOriginator(user);
            bug.setComponent(component);
            epi = (EditPageInterface)this.createPageNamed("CreateBugFromTestItem");
            epi.setObject((EOEnterpriseObject)bug);
            epi.setNextPage(this.session().context().page());
        }
        finally {
            peer.unlock();
        }
        return (WOComponent)epi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent createTestItemFromBug(Bug bug) {
        EOEditingContext peer = ERXEC.newEditingContext((EOObjectStore)bug.editingContext().parentObjectStore());
        peer.lock();
        try {
            bug = (Bug)bug.localInstanceIn(peer);
            TestItem testItem = (TestItem)TestItem.clazz.createAndInsertObject(peer);
            testItem.setComponent(bug.component());
            String description = ERXLocalizer.currentLocalizer().localizedTemplateStringForKeyWithObject("CreateTestItemFrom" + bug.entityName() + ".templateString", (Object)bug);
            testItem.setTextDescription(description);
            bug.addToTestItems(testItem);
            EditPageInterface epi = (EditPageInterface)this.createPageNamed("CreateTestItemFrom" + bug.entityName());
            epi.setObject((EOEnterpriseObject)testItem);
            epi.setNextPage(this.session().context().page());
            WOComponent wOComponent = (WOComponent)epi;
            return wOComponent;
        }
        finally {
            peer.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent listMyTestItems() {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            NSArray array = TestItem.clazz.unclosedTestItemsWithUser(ec, People.clazz.currentUser(ec));
            EOArrayDataSource ds = TestItem.clazz.newArrayDataSource(ec);
            ds.setArray(array);
            WOComponent wOComponent = (WOComponent)this.listPageNamed("ListMyTestItem", (EODataSource)ds);
            return wOComponent;
        }
        finally {
            ec.unlock();
        }
    }

    public WOComponent queryTestItems() {
        return this.pageForConfigurationNamed("QueryTestItem");
    }

    public WOComponent trackDefaultRelease() {
        EOEditingContext ec = this.session().defaultEditingContext();
        EOKeyValueQualifier q1 = new EOKeyValueQualifier("state", EOQualifier.QualifierOperatorEqual, (Object)State.ANALYZE);
        EOKeyValueQualifier q2 = new EOKeyValueQualifier("targetRelease", EOQualifier.QualifierOperatorEqual, (Object)Release.clazz.defaultRelease(ec));
        EOAndQualifier q = new EOAndQualifier(new NSArray(new Object[]{q1, q2}));
        EODatabaseDataSource ds = new EODatabaseDataSource(ec, "Bug");
        EOFetchSpecification fs = new EOFetchSpecification("Bug", (EOQualifier)q, null);
        ds.setFetchSpecification(fs);
        ListPageInterface lpi = (ListPageInterface)this.pageForConfigurationNamed("GroupedBugsByUser");
        lpi.setDataSource((EODataSource)ds);
        return (WOComponent)lpi;
    }

    public WOComponent createRelease() {
        ERD2WInspectPage page = (ERD2WInspectPage)this.createPageNamed("CreateRelease");
        EOEnterpriseObject eo = page.object();
        return page;
    }

    public WOComponent trackRelease() {
        return this.trackDefaultRelease();
    }

    public WOComponent trackMyRelease() {
        return this.trackDefaultRelease();
    }

    public WOComponent pushRelease() {
        EOEditingContext ec = this.session().defaultEditingContext();
        People user = this.currentUser(ec);
        ERDQueryPageInterface qpi = (ERDQueryPageInterface)this.pageForConfigurationNamed("QueryBugForPush", (WOSession)this.session());
        qpi.setQueryMatchForKey((Object)new NSArray((Object)State.BUILD), "isContainedInArray", "state");
        Release release = Release.clazz.defaultRelease(ec);
        if (release != null) {
            qpi.setQueryMatchForKey((Object)new NSArray((Object)release), "isContainedInArray", "targetRelease");
        }
        qpi.setNextPageDelegate(new NextPageDelegate(){

            public WOComponent nextPage(WOComponent sender2) {
                QueryPageInterface qpi2 = (QueryPageInterface)sender2;
                WOComponent bugList = sender2.pageWithName("GroupedBugsByRelease");
                return bugList;
            }
        });
        return (WOComponent)qpi;
    }

    public WOComponent createBug() {
        ERD2WInspectPage page = (ERD2WInspectPage)this.createPageNamed("CreateBug");
        Bug bug = (Bug)page.object();
        this.applyCurrentUser((EOEnterpriseObject)bug, "originator");
        this.applyCurrentUser((EOEnterpriseObject)bug, "owner");
        return page;
    }

    public WOComponent editBug(Bug bug) {
        EditPageInterface epi = this.editPageNamed("Edit" + bug.entityName(), (EOEnterpriseObject)bug);
        epi.setNextPage(this.homePage());
        return (WOComponent)epi;
    }

    public WOComponent inspectBug(Bug bug) {
        InspectPageInterface epi = this.inspectPageNamed("Inspect" + bug.entityName(), (EOEnterpriseObject)bug);
        epi.setNextPage(this.homePage());
        return (WOComponent)epi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent listRecentBugs() {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            WOComponent page;
            EODatabaseDataSource ds = Bug.clazz.newDatabaseDataSource(ec);
            EOFetchSpecification fs = Bug.clazz.fetchSpecificationForRecentBugs();
            ds.setFetchSpecification(fs);
            WOComponent wOComponent = page = (WOComponent)this.listPageNamed("ListRecentBug", (EODataSource)ds);
            return wOComponent;
        }
        finally {
            ec.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent listMyBugs() {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            EODatabaseDataSource ds = Bug.clazz.newDatabaseDataSource(ec);
            EOFetchSpecification fs = Bug.clazz.fetchSpecificationForOwnedBugs(this.currentUser(ec));
            ds.setFetchSpecification(fs);
            WOComponent wOComponent = (WOComponent)this.listPageNamed("ListMyBug", (EODataSource)ds);
            return wOComponent;
        }
        finally {
            ec.unlock();
        }
    }

    public WOComponent queryBugs() {
        ERD2WQueryPage page = (ERD2WQueryPage)this.pageForConfigurationNamed("QueryBug");
        page.setQueryMatchForKey((Object)new NSArray((Object)Priority.CRITICAL), EOQualifier.QualifierOperatorEqual.name(), "priority");
        page.setQueryMatchForKey((Object)new NSArray((Object)People.clazz.currentUser(this.session().defaultEditingContext())), EOQualifier.QualifierOperatorEqual.name(), "originator");
        page.setShowResults(true);
        return page;
    }

    public WOComponent findBugs(String string) {
        WOComponent result;
        NSArray bugs = Bug.clazz.findBugs(this.session().defaultEditingContext(), string);
        if (bugs != null && bugs.count() == 1) {
            InspectPageInterface ipi = D2W.factory().inspectPageForEntityNamed("Bug", (WOSession)this.session());
            ipi.setObject((EOEnterpriseObject)bugs.objectAtIndex(0));
            ipi.setNextPage(this.currentPage());
            result = (WOComponent)ipi;
        } else {
            EOArrayDataSource ds = Bug.clazz.newArrayDataSource(this.session().defaultEditingContext());
            ds.setArray(bugs);
            ListPageInterface lpi = D2W.factory().listPageForEntityNamed("Bug", (WOSession)this.session());
            lpi.setDataSource((EODataSource)ds);
            lpi.setNextPage(this.currentPage());
            result = (WOComponent)lpi;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent resolveBug(Bug bug) {
        EOEditingContext peer = ERXEC.newEditingContext((EOObjectStore)bug.editingContext().parentObjectStore());
        EditPageInterface epi = null;
        peer.lock();
        try {
            bug = (Bug)bug.localInstanceIn(peer);
            bug.close();
            epi = this.editPageNamed("Edit" + bug.entityName() + "ToClose", (EOEnterpriseObject)bug);
            epi.setObject((EOEnterpriseObject)bug);
            epi.setNextPage(this.currentPage());
        }
        finally {
            peer.unlock();
        }
        return (WOComponent)epi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent commentBug(Bug bug) {
        EOEditingContext peer = ERXEC.newEditingContext((EOObjectStore)bug.editingContext().parentObjectStore());
        EditPageInterface epi = null;
        peer.lock();
        try {
            bug = (Bug)bug.localInstanceIn(peer);
            epi = this.editPageNamed("Edit" + bug.entityName() + "ToComment", (EOEnterpriseObject)bug);
            epi.setObject((EOEnterpriseObject)bug);
            epi.setNextPage(this.currentPage());
        }
        finally {
            peer.unlock();
        }
        return (WOComponent)epi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent reopenBug(Bug bug) {
        EOEditingContext peer = ERXEC.newEditingContext((EOObjectStore)bug.editingContext().parentObjectStore());
        EditPageInterface epi = null;
        peer.lock();
        try {
            bug = (Bug)bug.localInstanceIn(peer);
            bug.reopen();
            epi = this.editPageNamed("Edit" + bug.entityName() + "ToReopen", (EOEnterpriseObject)bug);
            epi.setObject((EOEnterpriseObject)bug);
            epi.setNextPage(this.currentPage());
        }
        finally {
            peer.unlock();
        }
        return (WOComponent)epi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent rejectBug(Bug bug) {
        EOEditingContext peer = ERXEC.newEditingContext((EOObjectStore)bug.editingContext().parentObjectStore());
        EditPageInterface epi = null;
        peer.lock();
        try {
            bug = (Bug)bug.localInstanceIn(peer);
            bug.rejectVerification();
            epi = this.editPageNamed("Edit" + bug.entityName() + "ToReject", (EOEnterpriseObject)bug);
            epi.setObject((EOEnterpriseObject)bug);
            epi.setNextPage(this.currentPage());
        }
        finally {
            peer.unlock();
        }
        return (WOComponent)epi;
    }

    public WOComponent reportForName(String name) {
        ReportPage report = (ReportPage)this.pageForConfigurationNamed(name);
        report.setSelectedReportName(name);
        return report;
    }
}

