/*
 * Decompiled with CFR 0.152.
 */
package er.javamail;

import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.ERXExtensions;
import er.extensions.ERXFrameworkPrincipal;
import er.extensions.foundation.ERXProperties;
import er.extensions.validation.ERXValidationFactory;
import er.javamail.ERMessage;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.Session;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERJavaMail
extends ERXFrameworkPrincipal {
    public static final Class<?>[] REQUIRES = new Class[]{ERXExtensions.class};
    private static final Logger log = Logger.getLogger(ERJavaMail.class);
    protected static ERJavaMail sharedInstance;
    private static final String sp = "!#$%&'*+\\-/=?^_`{|}~";
    private static final String atext = "[a-zA-Z0-9!#$%&'*+\\-/=?^_`{|}~]";
    private static final String atom = "[a-zA-Z0-9!#$%&'*+\\-/=?^_`{|}~]+";
    private static final String dotAtom = "\\.[a-zA-Z0-9!#$%&'*+\\-/=?^_`{|}~]+";
    private static final String localPart = "[a-zA-Z0-9!#$%&'*+\\-/=?^_`{|}~]+(\\.[a-zA-Z0-9!#$%&'*+\\-/=?^_`{|}~]+)*";
    private static final String letter = "[a-zA-Z]";
    private static final String letDig = "[a-zA-Z0-9]";
    private static final String letDigHyp = "[a-zA-Z0-9\\-]";
    private static final String rfcLabel = "[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]){0,1}";
    private static final String domain = "[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]){0,1}((\\.[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]){0,1})*\\.[a-zA-Z]{2,6}){0,1}";
    private static final String EMAIL_VALIDATION_PATTERN = "^[a-zA-Z0-9!#$%&'*+\\-/=?^_`{|}~]+(\\.[a-zA-Z0-9!#$%&'*+\\-/=?^_`{|}~]+)*@[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]){0,1}((\\.[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]){0,1})*\\.[a-zA-Z]{2,6}){0,1}$";
    protected Pattern _pattern = null;
    private Delegate _delegate;
    protected Session _defaultSession;
    private final Map<String, Session> _sessions = new ConcurrentHashMap<String, Session>();
    protected String _adminEmail;
    protected boolean _debugEnabled = true;
    protected String _defaultXMailerHeader = null;
    protected boolean _centralize = true;
    protected int _senderQueueSize = 50;
    protected int _milliSecondsWaitIfSenderOverflowed = 6000;
    protected NSArray<String> whiteListEmailAddressPatterns;
    protected NSArray<String> blakListEmailAddressPatterns;
    protected EOOrQualifier whiteListQualifier;
    protected EOOrQualifier blackListQualifier;

    public static ERJavaMail sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = (ERJavaMail)ERXFrameworkPrincipal.sharedInstance(ERJavaMail.class);
        }
        return sharedInstance;
    }

    public void setDelegate(Delegate delegate) {
        this._delegate = delegate;
    }

    public void finishInitialization() {
        this.initializeFrameworkFromSystemProperties();
    }

    public void initializeFrameworkFromSystemProperties() {
        boolean centralize = ERXProperties.booleanForKey((String)"er.javamail.centralize");
        this.setCentralize(centralize);
        log.debug((Object)("er.javamail.centralize: " + centralize));
        String adminEmail = System.getProperty("er.javamail.adminEmail");
        if (this.isValidEmail(adminEmail)) {
            this.setAdminEmail(adminEmail);
            log.debug((Object)("er.javamail.adminEmail: " + this._adminEmail));
        } else if (centralize) {
            throw new IllegalArgumentException("When 'er.javamail.centralize' is true (default), all outgoing mails will get sent to 'er.javamail.adminEmail' instead of the normal TO addresses, but you did not provide a valid email for that property.");
        }
        boolean debug = ERXProperties.booleanForKey((String)"er.javamail.debugEnabled");
        this.setDebugEnabled(debug);
        log.debug((Object)("er.javamail.debugEnabled: " + debug));
        int queueSize = ERXProperties.intForKey((String)"er.javamail.senderQueue.size");
        if (queueSize >= 1) {
            this.setSenderQueueSize(queueSize);
        }
        log.debug((Object)("er.javamail.senderQueue.size: " + queueSize));
        int milliswait = ERXProperties.intForKey((String)"er.javamail.milliSecondsWaitIfSenderOverflowed");
        if (milliswait > 1000) {
            this.setMilliSecondsWaitIfSenderOverflowed(milliswait);
        }
        log.debug((Object)("er.javamail.milliSecondsWaitIfSenderOverflowed: " + milliswait));
        this.setupSmtpHostSafely();
        this.setDefaultSession(this.newSession());
        if (this.defaultSession() == null) {
            log.warn((Object)"Unable to create default mail session!");
        }
        this.setDefaultXMailerHeader(System.getProperty("er.javamail.XMailerHeader"));
        log.debug((Object)("er.javamail.XMailHeader: " + this.defaultXMailerHeader()));
    }

    protected void setupSmtpHostSafely() {
        this.setupSmtpProperties(System.getProperties(), null);
    }

    protected void setupSmtpProperties(Properties properties, String contextString) {
        String contextSuffix = contextString == null ? "" : "." + contextString;
        String smtpProtocol = this.smtpProtocolForContext(contextString);
        String smtpHost = ERXProperties.stringForKeyWithDefault((String)("er.javamail.smtpHost" + contextSuffix), (String)ERXProperties.stringForKey((String)"er.javamail.smtpHost"));
        if (smtpHost == null || smtpHost.length() == 0) {
            smtpHost = ERXProperties.stringForKey((String)("mail." + smtpProtocol + ".host"));
            if (smtpHost == null || smtpHost.length() == 0) {
                smtpHost = ERXProperties.stringForKey((String)"WOSMTPHost");
                if (smtpHost == null || smtpHost.length() == 0) {
                    throw new RuntimeException("ERJavaMail: You must specify a SMTP host for outgoing mail with the property 'er.javamail.smtpHost'");
                }
                properties.setProperty("mail." + smtpProtocol + ".host", smtpHost);
                properties.setProperty("er.javamail.smtpHost", smtpHost);
            } else {
                properties.setProperty("er.javamail.smtpHost", smtpHost);
            }
        } else {
            properties.setProperty("mail." + smtpProtocol + ".host", smtpHost);
        }
        log.debug((Object)("er.javamail.smtpHost: " + smtpHost));
        String port = ERXProperties.stringForKeyWithDefault((String)("er.javamail.smtpPort" + contextSuffix), (String)ERXProperties.stringForKey((String)"er.javamail.smtpPost"));
        if (port != null && port.length() > 0) {
            properties.setProperty("mail." + smtpProtocol + ".port", port);
            log.debug((Object)("ERJavaMail will use smtp port: " + port));
        }
        boolean smtpAuth = ERXProperties.booleanForKeyWithDefault((String)("er.javamail.smtpAuth" + contextSuffix), (boolean)ERXProperties.booleanForKey((String)"er.javamail.smtpAuth"));
        log.debug((Object)"ERJavaMail will use authenticated SMTP connections.");
        if (smtpAuth) {
            properties.setProperty("mail." + smtpProtocol + ".auth", String.valueOf(smtpAuth));
            String user = ERXProperties.stringForKeyWithDefault((String)("er.javamail.smtpUser" + contextSuffix), (String)ERXProperties.stringForKey((String)"er.javamail.smtpUser"));
            if (user == null || user.length() == 0) {
                throw new RuntimeException("You specified er.javamail.smtpAuth=true, but you didn't specify an er.javamail.smtpUser to use as the login name.");
            }
            properties.setProperty("mail." + smtpProtocol + ".user", user);
            String password = ERXProperties.stringForKeyWithDefault((String)("er.javamail.smtpPassword" + contextSuffix), (String)ERXProperties.stringForKey((String)"er.javamail.smtpPassword"));
            if (password == null || password.length() == 0) {
                log.warn((Object)("You specified er.javamail.smtpAuth=true, but you didn't set er.javamail.smtpPassword for the " + user + " mail user."));
            }
            if (password != null) {
                properties.setProperty("mail." + smtpProtocol + ".password", password);
            }
        }
        if ("smtps".equals(smtpProtocol)) {
            properties.setProperty("mail.smtps.socketFactory.fallback", "false");
        }
    }

    public void setDefaultSession(Session session) {
        session.setDebug(this.debugEnabled());
        this._defaultSession = session;
    }

    public Session defaultSession() {
        return this._defaultSession;
    }

    public Session newSession(Properties props) {
        return this.newSessionForContext(props, null);
    }

    public Session newSession() {
        return this.newSession(System.getProperties());
    }

    public Session newSessionForMessage(ERMessage message) {
        return this.newSessionForContext(message.contextString());
    }

    public Session sessionForMessage(ERMessage message) {
        return this.sessionForContext(message.contextString());
    }

    protected Session newSessionForContext(String contextString) {
        Session session;
        if (contextString == null || contextString.length() == 0) {
            session = this.newSessionForContext(System.getProperties(), contextString);
        } else {
            Properties sessionProperties = new Properties();
            sessionProperties.putAll((Map<?, ?>)System.getProperties());
            this.setupSmtpProperties(sessionProperties, contextString);
            session = this.newSessionForContext(sessionProperties, contextString);
        }
        return session;
    }

    public Session newSessionForContext(Properties properties, String contextString) {
        if (this._delegate != null) {
            this._delegate.willCreateSessionWithPropertiesForContext(properties, contextString);
        }
        Session session = Session.getInstance((Properties)properties);
        if (this._delegate != null) {
            this._delegate.didCreateSession(session);
        }
        session.setDebug(this.debugEnabled());
        return session;
    }

    protected Session sessionForContext(String contextString) {
        Session session;
        if (contextString == null || contextString.length() == 0) {
            session = this.defaultSession();
        } else {
            session = this._sessions.get(contextString);
            if (session == null) {
                session = this.newSessionForContext(contextString);
                this._sessions.put(contextString, session);
            }
        }
        return session;
    }

    public String adminEmail() {
        return this._adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        if (!(this.isValidEmail(adminEmail) || adminEmail != null && adminEmail.trim().length() > 0)) {
            throw new IllegalArgumentException("You specified an invalid admin email address '" + adminEmail + "'.");
        }
        this._adminEmail = adminEmail;
    }

    public boolean debugEnabled() {
        return this._debugEnabled;
    }

    public void setDebugEnabled(boolean debug) {
        this._debugEnabled = debug;
    }

    public String defaultXMailerHeader() {
        return this._defaultXMailerHeader;
    }

    public void setDefaultXMailerHeader(String header) {
        this._defaultXMailerHeader = header;
    }

    public boolean centralize() {
        return this._centralize;
    }

    public void setCentralize(boolean centralize) {
        this._centralize = centralize;
    }

    public String smtpProtocolForContext(String contextString) {
        String contextSuffix = contextString == null ? "" : "." + contextString;
        return ERXProperties.stringForKeyWithDefault((String)("er.javamail.smtpProtocol" + contextSuffix), (String)ERXProperties.stringForKeyWithDefault((String)"er.javamail.smtpProtocol", (String)ERXProperties.stringForKeyWithDefault((String)"mail.smtp.protocol", (String)"smtp")));
    }

    public int senderQueueSize() {
        return this._senderQueueSize;
    }

    public void setSenderQueueSize(int value) {
        this._senderQueueSize = value;
    }

    public int milliSecondsWaitIfSenderOverflowed() {
        return this._milliSecondsWaitIfSenderOverflowed;
    }

    public void setMilliSecondsWaitIfSenderOverflowed(int value) {
        this._milliSecondsWaitIfSenderOverflowed = value;
    }

    public String validateEmail(EOEnterpriseObject object, String key, String email) {
        if (email != null && !this.isValidEmail(email)) {
            throw ERXValidationFactory.defaultFactory().createException(object, key, (Object)email, "malformedEmail");
        }
        return email;
    }

    public synchronized boolean isValidEmail(String email) {
        if (this._pattern == null) {
            String patternString = ERXProperties.stringForKey((String)"er.javamail.emailPattern");
            if (patternString == null || patternString.trim().length() == 0) {
                patternString = EMAIL_VALIDATION_PATTERN;
            }
            try {
                this._pattern = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("The compilation of the email pattern '" + patternString + "' failed.", e);
            }
        }
        if (email != null) {
            return this._pattern.matcher(email).matches();
        }
        return false;
    }

    public boolean hasWhiteList() {
        return this.whiteListEmailAddressPatterns().count() > 0;
    }

    public boolean hasBlackList() {
        return this.blackListEmailAddressPatterns().count() > 0;
    }

    public NSArray<String> whiteListEmailAddressPatterns() {
        if (this.whiteListEmailAddressPatterns == null) {
            this.whiteListEmailAddressPatterns = ERXProperties.arrayForKeyWithDefault((String)"er.javamail.WhiteListEmailAddressPatterns", (NSArray)NSArray.EmptyArray);
        }
        return this.whiteListEmailAddressPatterns;
    }

    public NSArray<String> blackListEmailAddressPatterns() {
        if (this.blakListEmailAddressPatterns == null) {
            this.blakListEmailAddressPatterns = ERXProperties.arrayForKeyWithDefault((String)"er.javamail.BlackListEmailAddressPatterns", (NSArray)NSArray.EmptyArray);
        }
        return this.blakListEmailAddressPatterns;
    }

    public EOOrQualifier whiteListQualifier() {
        if (this.whiteListQualifier == null) {
            this.whiteListQualifier = this.qualifierArrayForEmailPatterns(this.whiteListEmailAddressPatterns());
        }
        return this.whiteListQualifier;
    }

    public EOOrQualifier blackListQualifier() {
        if (this.blackListQualifier == null) {
            this.blackListQualifier = this.qualifierArrayForEmailPatterns(this.blackListEmailAddressPatterns());
        }
        return this.blackListQualifier;
    }

    protected EOOrQualifier qualifierArrayForEmailPatterns(NSArray<String> emailPatterns) {
        NSMutableArray patternQualifiers = new NSMutableArray();
        for (String pattern : emailPatterns) {
            patternQualifiers.addObject((Object)EOQualifier.qualifierWithQualifierFormat((String)("toString caseInsensitiveLike '" + pattern + "'"), null));
        }
        return new EOOrQualifier((NSArray)patternQualifiers);
    }

    public NSArray<String> filterEmailAddresses(NSArray<String> emailAddresses) {
        NSMutableArray filteredAddresses = null;
        if (emailAddresses != null && emailAddresses.count() > 0 && (this.hasWhiteList() || this.hasBlackList())) {
            filteredAddresses = new NSMutableArray(emailAddresses);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filtering email addresses: " + filteredAddresses));
            }
            if (this.hasWhiteList()) {
                EOQualifier.filterArrayWithQualifier((NSMutableArray)filteredAddresses, (EOQualifier)this.whiteListQualifier());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("White list qualifier: " + this.whiteListQualifier() + " after filtering: " + filteredAddresses));
                }
            }
            if (this.hasBlackList()) {
                NSArray filteredOutAddresses = EOQualifier.filteredArrayWithQualifier((NSArray)filteredAddresses, (EOQualifier)this.blackListQualifier());
                if (filteredOutAddresses.count() > 0) {
                    filteredAddresses.removeObjectsInArray(filteredOutAddresses);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Black list qualifier: " + this.blackListQualifier() + " filtering: " + filteredAddresses));
                }
            }
        }
        return filteredAddresses != null ? filteredAddresses.immutableClone() : emailAddresses;
    }

    static {
        ERJavaMail.setUpFrameworkPrincipalClass(ERJavaMail.class);
    }

    public static interface Delegate {
        public void willCreateSessionWithPropertiesForContext(Properties var1, String var2);

        public void didCreateSession(Session var1);
    }
}

