/*
 * Decompiled with CFR 0.152.
 */
package er.javamail;

import com.webobjects.foundation.NSData;
import er.javamail.ERMailAttachment;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;

public class ERMailDataAttachment
extends ERMailAttachment {
    protected String _fileName;
    protected String _contentID;
    protected String _mimeType;
    protected DataHandler _dataHandler;

    protected ERMailDataAttachment(Object content) {
        super(content);
    }

    public ERMailDataAttachment(String fileName, String id, NSData content) {
        this(fileName, id, content._bytesNoCopy());
    }

    public ERMailDataAttachment(String fileName, String id, byte[] content) {
        super(content);
        this._mimeType = FileTypeMap.getDefaultFileTypeMap().getContentType(fileName);
        this.setFileName(fileName);
        this.setContentID(id);
    }

    public ERMailDataAttachment(String aFilename, String anId, DataHandler aHandler) {
        super(null);
        this.setFileName(aFilename);
        this.setContentID(anId);
        this._dataHandler = aHandler;
        this._mimeType = FileTypeMap.getDefaultFileTypeMap().getContentType(aFilename);
    }

    public String fileName() {
        if (this._fileName == null) {
            this._fileName = "attachement.txt";
        }
        return this._fileName;
    }

    public DataHandler getDataHandler() {
        return this._dataHandler;
    }

    public void setFileName(String name) {
        this._fileName = name;
    }

    public String contentID() {
        return this._contentID;
    }

    public void setContentID(String id) {
        this._contentID = id;
    }

    protected BodyPart getBodyPart() throws MessagingException {
        MimeBodyPart bp = new MimeBodyPart();
        if (this.getDataHandler() == null) {
            ByteArrayDataSource ds = new ByteArrayDataSource((byte[])this.content(), this._mimeType);
            bp.setDataHandler(new DataHandler((DataSource)ds));
        } else {
            bp.setDataHandler(this.getDataHandler());
            if (this._mimeType != null) {
                bp.setHeader("Content-type", this._mimeType);
            }
        }
        if (this.contentID() != null) {
            bp.setHeader("Content-ID", this.contentID());
        }
        bp.setFileName(this.fileName());
        return bp;
    }
}

