/*
 * Decompiled with CFR 0.152.
 */
package er.javamail;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOSession;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.appserver.ERXApplication;
import er.javamail.ERMailDelivery;
import er.javamail.ERMailDeliveryHTML;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERMailUtils {
    private static Logger log = Logger.getLogger(ERMailUtils.class);
    private static ERMailDeliveryHTML sharedDeliverer;

    public static ERMailDeliveryHTML sharedDeliverer() {
        if (sharedDeliverer == null) {
            sharedDeliverer = ERMailDeliveryHTML.newMailDelivery();
        }
        return sharedDeliverer;
    }

    public static WOComponent instantiatePage(String pageName, NSDictionary sessionDict) {
        WOComponent component = ERXApplication.instantiatePage((String)pageName);
        if (sessionDict != null) {
            ERMailUtils.setDictionaryValuesInSession(sessionDict, component.session());
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendHTMLMail(ERMailDeliveryHTML delivery, String pageName, String alternatePageName, String emailFrom, String emailTo, String emailReplyTo, String subject) {
        WOComponent mailPage = ERMailUtils.instantiatePage(pageName, delivery.sessionDictionary());
        delivery.newMail();
        delivery.setComponent(mailPage);
        if (alternatePageName != null) {
            String alternateString = null;
            WOComponent alternateMailTemplate = ERMailUtils.instantiatePage(alternatePageName, delivery.sessionDictionary());
            alternateString = alternateMailTemplate.generateResponse().contentString();
            if (alternateString != null) {
                delivery.setHiddenPlainTextContent(alternateString);
                alternateMailTemplate.session().terminate();
            }
        }
        try {
            delivery.setFromAddress(emailFrom);
            delivery.setToAddress(emailTo);
            delivery.setReplyToAddress(emailReplyTo);
            delivery.setSubject(subject == null ? "" : subject);
            delivery.sendMail();
        }
        catch (MessagingException e) {
            log.warn((Object)"While trying to sendMail: ", (Throwable)e);
        }
        finally {
            mailPage.session().terminate();
        }
    }

    public static void sendHTMLMail(String pageName, String alternatePageName, String emailFrom, String emailTo, String emailReplyTo, String subject) {
        ERMailUtils.sendHTMLMail(ERMailUtils.sharedDeliverer(), pageName, alternatePageName, emailFrom, emailTo, emailReplyTo, subject);
    }

    public static void setDictionaryValuesInSession(NSDictionary dict, WOSession session) {
        if (dict == null || session == null) {
            return;
        }
        Enumeration en = dict.keyEnumerator();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object object = dict.objectForKey((Object)key);
            if (object == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting in session dict value '" + object.toString() + "' for key '" + key + "'"));
            }
            session.setObjectForKey(object, key);
        }
    }

    public static String encodeString(String string, String charset) {
        String encodedString = null;
        try {
            encodedString = MimeUtility.encodeText((String)string, (String)charset, (String)(!charset.equals(ERMailDelivery.DefaultCharset) ? "B" : null));
        }
        catch (Exception e) {
            encodedString = string;
        }
        return encodedString;
    }

    public static InternetAddress[] convertNSArrayToInternetAddresses(NSArray addrs) throws AddressException {
        if (addrs == null) {
            return new InternetAddress[0];
        }
        InternetAddress[] addrArray = new InternetAddress[addrs.count()];
        Enumeration en = addrs.objectEnumerator();
        int i = 0;
        while (en.hasMoreElements()) {
            String anAddress = (String)en.nextElement();
            addrArray[i] = new InternetAddress(anAddress);
            ++i;
        }
        return addrArray;
    }

    public static NSArray<String> convertInternetAddressesToNSArray(Address[] addressesArray) {
        if (addressesArray == null) {
            return NSArray.EmptyArray;
        }
        NSMutableArray addresses = new NSMutableArray(addressesArray.length);
        for (int i = 0; i < addressesArray.length; ++i) {
            Address anAddress = addressesArray[i];
            String emailAddress = null;
            emailAddress = anAddress instanceof InternetAddress ? ((InternetAddress)anAddress).toUnicodeString() : anAddress.toString();
            addresses.addObject((Object)emailAddress);
        }
        return addresses;
    }

    public static InternetAddress[] convertNSDictionaryToInternetAddresses(NSDictionary<String, String> addrs, String charset) throws AddressException {
        if (addrs == null || addrs.isEmpty()) {
            return new InternetAddress[0];
        }
        InternetAddress[] addrArray = new InternetAddress[addrs.count()];
        int i = 0;
        for (String email : addrs.allKeys()) {
            InternetAddress address;
            String personal = (String)addrs.objectForKey((Object)email);
            if (personal != null && personal.length() > 0) {
                address = new InternetAddress();
                address.setAddress(email);
                try {
                    address.setPersonal(personal, charset);
                }
                catch (UnsupportedEncodingException ex) {
                    try {
                        address.setPersonal(personal);
                    }
                    catch (Exception e) {}
                }
            } else {
                address = new InternetAddress(email);
            }
            addrArray[i++] = address;
        }
        return addrArray;
    }
}

