/*
 * Decompiled with CFR 0.152.
 */
package ognl.helperfunction;

import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSStringUtilities;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import ognl.helperfunction.WOHelperFunctionDeclarationFormatException;
import ognl.helperfunction.WOHelperFunctionHTMLFormatException;
import ognl.helperfunction.WOHelperFunctionParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class WOHelperFunctionHTMLParser {
    public static Logger log = Logger.getLogger(WOHelperFunctionHTMLParser.class);
    private WOHelperFunctionParser _parserDelegate;
    private String _unparsedTemplate;
    private StringBuffer _contentText;
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INSIDE_COMMENT = 3;
    private static final String JS_START_TAG = "<script";
    private static final String JS_END_TAG = "</script";
    private static final String WO_END_TAG = "</wo";
    private static final String WO_START_TAG = "<wo ";
    private static final String WEBOBJECT_END_TAG = "</webobject";
    private static final String WEBOBJECT_START_TAG = "<webobject";
    private static final String WO_COLON_END_TAG = "</wo:";
    private static final String WO_COLON_START_TAG = "<wo:";
    private static final String WO_REPLACEMENT_MARKER = "__REPL__";
    private static boolean _parseStandardTags = false;
    private NSMutableDictionary _stackDict;

    public WOHelperFunctionHTMLParser(WOHelperFunctionParser parserDelegate, String unparsedTemplate) {
        this._parserDelegate = parserDelegate;
        this._unparsedTemplate = unparsedTemplate;
        this._contentText = new StringBuffer(128);
    }

    public static void setParseStandardTags(boolean flag) {
        _parseStandardTags = flag;
    }

    public void parseHTML() throws WOHelperFunctionHTMLFormatException, WOHelperFunctionDeclarationFormatException, ClassNotFoundException {
        this._stackDict = new NSMutableDictionary();
        StringTokenizer templateTokenizer = new StringTokenizer(this._unparsedTemplate, "<");
        boolean flag = true;
        int parserState = 0;
        String token = this._unparsedTemplate.startsWith("<") || !templateTokenizer.hasMoreTokens() ? null : templateTokenizer.nextToken("<");
        try {
            while (templateTokenizer.hasMoreTokens()) {
                switch (parserState) {
                    case 0: {
                        String tagLowerCase;
                        if (token != null) {
                            if (token.startsWith(">")) {
                                token = token.substring(1);
                            }
                            this._contentText.append(token);
                        }
                        token = templateTokenizer.nextToken(">");
                        if (_parseStandardTags) {
                            token = this.checkToken(token);
                        }
                        if ((tagLowerCase = token.toLowerCase()).startsWith(WEBOBJECT_START_TAG) || tagLowerCase.startsWith(WO_COLON_START_TAG) || tagLowerCase.startsWith(WO_START_TAG)) {
                            if (token.endsWith("/")) {
                                this.startOfWebObjectTag(token.substring(0, token.length() - 1));
                                this.endOfWebObjectTag("/");
                                break;
                            }
                            this.startOfWebObjectTag(token);
                            break;
                        }
                        int tagIndex = tagLowerCase.indexOf(WEBOBJECT_START_TAG);
                        if (tagIndex > 1 || (tagIndex = tagLowerCase.indexOf(WO_COLON_START_TAG)) > 1 || (tagIndex = tagLowerCase.indexOf(WO_START_TAG)) > 1) {
                            this._contentText.append(token.substring(0, token.lastIndexOf("<")));
                            if (token.endsWith("/")) {
                                this.startOfWebObjectTag(token.substring(tagIndex, token.length() - 1));
                                this.endOfWebObjectTag("/");
                                break;
                            }
                            this.startOfWebObjectTag(token.substring(tagIndex, token.length()));
                            break;
                        }
                        if (tagLowerCase.startsWith(WEBOBJECT_END_TAG) || tagLowerCase.startsWith(WO_COLON_END_TAG) || tagLowerCase.equals(WO_END_TAG)) {
                            this.endOfWebObjectTag(token);
                            break;
                        }
                        if (tagLowerCase.startsWith(JS_START_TAG)) {
                            this.didParseText();
                            this._contentText.append(token);
                            this._contentText.append('>');
                            flag = false;
                            break;
                        }
                        if (tagLowerCase.startsWith(JS_END_TAG)) {
                            this.didParseText();
                            this._contentText.append(token);
                            this._contentText.append('>');
                            flag = true;
                            break;
                        }
                        if (token.startsWith("<!--") && flag) {
                            this.didParseText();
                            this._contentText.append(token);
                            if (token.endsWith("--")) {
                                this._contentText.append('>');
                                this.didParseComment();
                                break;
                            }
                            this._contentText.append('>');
                            parserState = 3;
                            break;
                        }
                        this._contentText.append(token);
                        this._contentText.append('>');
                        break;
                    }
                    case 3: {
                        token = templateTokenizer.nextToken(">");
                        this._contentText.append(token);
                        this._contentText.append('>');
                        if (!token.endsWith("--")) break;
                        this.didParseComment();
                        parserState = 0;
                        break;
                    }
                }
                token = null;
                if (parserState != 0) continue;
                token = templateTokenizer.nextToken("<");
            }
        }
        catch (NoSuchElementException e) {
            log.error((Object)e);
            this.didParseText();
            return;
        }
        if (token != null) {
            if (token.startsWith(">")) {
                token = token.substring(1);
            }
            this._contentText.append(token);
        }
        this.didParseText();
        this._stackDict = null;
    }

    private String checkToken(String token) {
        String original = new String(token);
        try {
            String stackContent;
            Stack stack;
            if (token == null || token.toLowerCase().startsWith(WEBOBJECT_START_TAG) || token.toLowerCase().startsWith(WO_COLON_START_TAG) || token.toLowerCase().startsWith(WO_START_TAG)) {
                return token;
            }
            String[] tokenParts = token.split(" ");
            String tokenPart = tokenParts[0].substring(1);
            if ((token.indexOf("\"$") != -1 || token.indexOf("\"~") != -1) && token.startsWith("<")) {
                token = token.replaceAll(tokenParts[0], "<wo:__REPL__" + tokenPart);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rewritten <" + tokenPart + " ...> tag to <wo:" + tokenPart + " ...>"));
                }
                if (!token.endsWith("/")) {
                    Stack<String> stack2 = (Stack<String>)this._stackDict.objectForKey((Object)tokenPart);
                    if (stack2 == null) {
                        stack2 = new Stack<String>();
                        stack2.push(WO_REPLACEMENT_MARKER);
                        this._stackDict.setObjectForKey(stack2, (Object)tokenPart);
                    } else {
                        stack2.push(WO_REPLACEMENT_MARKER);
                        this._stackDict.setObjectForKey(stack2, (Object)tokenPart);
                    }
                }
            } else if (!token.startsWith("</") && this._stackDict.containsKey((Object)tokenPart)) {
                Stack stack3 = (Stack)this._stackDict.objectForKey((Object)tokenPart);
                if (this._stackDict != null && stack3 != null) {
                    stack3.push(tokenPart);
                    this._stackDict.setObjectForKey((Object)stack3, (Object)tokenPart);
                }
            } else if (token.startsWith("</") && (stack = (Stack)this._stackDict.objectForKey((Object)tokenParts[0].substring(2))) != null && !stack.empty() && (stackContent = (String)stack.pop()).equals(WO_REPLACEMENT_MARKER)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Replaced end tag for '" + tokenParts[0].substring(2) + "' with 'wo' endtag"));
                }
                token = WO_END_TAG;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return original;
        }
        return token;
    }

    private void startOfWebObjectTag(String token) throws WOHelperFunctionHTMLFormatException {
        this.didParseText();
        this._contentText.append(token);
        this.didParseOpeningWebObjectTag();
    }

    private void endOfWebObjectTag(String token) throws WOHelperFunctionDeclarationFormatException, WOHelperFunctionHTMLFormatException, ClassNotFoundException {
        this.didParseText();
        this._contentText.append(token);
        this.didParseClosingWebObjectTag();
    }

    private void didParseText() {
        if (this._contentText != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsed Text (" + this._contentText.length() + ") : " + this._contentText));
            }
            if (this._contentText.length() > 0) {
                this._parserDelegate.didParseText(_NSStringUtilities.stringFromBuffer((StringBuffer)this._contentText), this);
                this._contentText.setLength(0);
            }
        }
    }

    private void didParseOpeningWebObjectTag() throws WOHelperFunctionHTMLFormatException {
        if (this._contentText != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsed Opening WebObject (" + this._contentText.length() + ") : " + this._contentText));
            }
            if (this._contentText.length() > 0) {
                this._parserDelegate.didParseOpeningWebObjectTag(_NSStringUtilities.stringFromBuffer((StringBuffer)this._contentText), this);
                this._contentText.setLength(0);
            }
        }
    }

    private void didParseClosingWebObjectTag() throws WOHelperFunctionDeclarationFormatException, WOHelperFunctionHTMLFormatException, ClassNotFoundException, ClassNotFoundException {
        if (this._contentText != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsed Closing WebObject (" + this._contentText.length() + ") : " + this._contentText));
            }
            if (this._contentText.length() > 0) {
                this._parserDelegate.didParseClosingWebObjectTag(_NSStringUtilities.stringFromBuffer((StringBuffer)this._contentText), this);
                this._contentText.setLength(0);
            }
        }
    }

    private void didParseComment() {
        if (this._contentText != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsed Comment (" + this._contentText.length() + ") : " + this._contentText));
            }
            if (this._contentText.length() > 0) {
                this._parserDelegate.didParseComment(_NSStringUtilities.stringFromBuffer((StringBuffer)this._contentText), this);
                this._contentText.setLength(0);
            }
        }
    }

    static {
        log.setLevel(Level.WARN);
    }
}

