/*
 * Decompiled with CFR 0.152.
 */
package ognl.helperfunction;

import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation._NSUtilities;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import ognl.helperfunction.WOHelperFunctionClassKeyValueCoding;
import org.apache.log4j.Logger;

public class WOHelperFunctionRegistry {
    public static Logger log = Logger.getLogger(WOHelperFunctionRegistry.class);
    public static final String APP_FRAMEWORK_NAME = "app";
    private static WOHelperFunctionRegistry _instance;
    private Map _applicationHelperInstanceCache = new HashMap();

    private WOHelperFunctionRegistry() {
    }

    public static synchronized WOHelperFunctionRegistry registry() {
        if (_instance == null) {
            _instance = new WOHelperFunctionRegistry();
        }
        return _instance;
    }

    public synchronized void setHelperInstanceForClassInFrameworkNamed(Object helperInstance, Class targetObjectClass, String frameworkName) {
        this.setHelperInstanceForClassInFrameworkNamed(helperInstance, null, targetObjectClass, frameworkName);
    }

    protected synchronized void setHelperInstanceForClassInFrameworkNamed(Object helperInstance, String helperFunction, Class targetObjectClass, String frameworkName) {
        HashMap<Class, Object> frameworkHelperInstanceCache;
        if (frameworkName == null) {
            frameworkName = APP_FRAMEWORK_NAME;
        }
        if ((frameworkHelperInstanceCache = (HashMap<Class, Object>)this._applicationHelperInstanceCache.get(frameworkName)) == null) {
            frameworkHelperInstanceCache = new HashMap<Class, Object>();
            this._applicationHelperInstanceCache.put(frameworkName, frameworkHelperInstanceCache);
        }
        frameworkHelperInstanceCache.put(targetObjectClass, helperInstance);
        if (helperFunction != null) {
            frameworkHelperInstanceCache.put((Class)((Object)(targetObjectClass.getName() + helperFunction)), helperInstance);
        }
    }

    protected synchronized Object _cachedHelperInstanceForFrameworkNamed(Class targetClass, String frameworkName) {
        return this.__cachedHelperInstanceForFrameworkNamed(targetClass, frameworkName);
    }

    protected synchronized Object _cachedHelperInstanceForFrameworkNamed(Class targetClass, String helperFunction, String frameworkName) {
        return this.__cachedHelperInstanceForFrameworkNamed(targetClass.getName() + "." + helperFunction, frameworkName);
    }

    protected synchronized Object __cachedHelperInstanceForFrameworkNamed(Object key, String frameworkName) {
        Object helperInstance = null;
        Map frameworkHelperInstanceCache = (Map)this._applicationHelperInstanceCache.get(frameworkName);
        if (frameworkHelperInstanceCache != null) {
            helperInstance = frameworkHelperInstanceCache.get(key);
        }
        return helperInstance;
    }

    public synchronized Object _helperInstanceForFrameworkNamed(Object targetObject, String helperFunction, String keyPath, String frameworkName) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException {
        Class<Object> helpedClass;
        if (frameworkName == null) {
            frameworkName = APP_FRAMEWORK_NAME;
        }
        if (targetObject == null) {
            throw new IllegalArgumentException("The target of a helper keypath must not be null.");
        }
        if (keyPath == null) {
            throw new NullPointerException("You must specify a keypath to use helper functions.");
        }
        Object helpedObject = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)targetObject, (String)keyPath);
        if (helpedObject != null) {
            helpedClass = helpedObject.getClass();
        } else {
            NSKeyValueCoding._KeyBinding keyBinding = WOHelperFunctionClassKeyValueCoding.DefaultImplementation.keyGetBindingForKeyPath(targetObject.getClass(), keyPath);
            if (keyBinding != null) {
                helpedClass = keyBinding.valueType();
            } else {
                log.warn((Object)("Unable to determine the value class of the keypath '" + keyPath + "' for the object " + targetObject));
                helpedClass = Object.class;
            }
        }
        Object helperInstance = null;
        helperInstance = this._cachedHelperInstanceForFrameworkNamed(helpedClass, helperFunction, frameworkName);
        if (helperInstance == null && !APP_FRAMEWORK_NAME.equals(frameworkName)) {
            helperInstance = this._cachedHelperInstanceForFrameworkNamed(helpedClass, helperFunction, APP_FRAMEWORK_NAME);
        }
        if (helperInstance == null) {
            helperInstance = this._cachedHelperInstanceForFrameworkNamed(helpedClass, frameworkName);
            if (helperInstance == null && !APP_FRAMEWORK_NAME.equals(frameworkName)) {
                helperInstance = this._cachedHelperInstanceForFrameworkNamed(helpedClass, APP_FRAMEWORK_NAME);
            }
            if (helperInstance != null) {
                if (this.classImplementsMethod(helperInstance.getClass(), helperFunction)) {
                    this.setHelperInstanceForClassInFrameworkNamed(helperInstance, helperFunction, helpedClass, frameworkName);
                } else {
                    helperInstance = null;
                }
            }
        }
        if (helperInstance == null) {
            Class targetHelperClass = this.helperClassForClass(helpedClass, helperFunction);
            if (targetHelperClass == null) {
                throw new NoSuchElementException("Could not find a helper class for '" + helpedClass.getName() + " implementing " + helperFunction + "'.");
            }
            helperInstance = targetHelperClass.newInstance();
            this.setHelperInstanceForClassInFrameworkNamed(helperInstance, helperFunction, helpedClass, frameworkName);
        }
        return helperInstance;
    }

    protected Class helperClassForClass(Class helpedClass, String helperFunction) {
        String targetHelperName;
        Class helperClass;
        String targetClassName = helpedClass.getName();
        int lastDotIndex = targetClassName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            targetClassName = targetClassName.substring(lastDotIndex + 1);
        }
        if ((helperClass = _NSUtilities.classWithName((String)(targetHelperName = targetClassName + "Helper"))) != null && this.classImplementsMethod(helperClass, helperFunction)) {
            return helperClass;
        }
        Class<?>[] interfaces = helpedClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            helperClass = this.helperClassForClass(interfaces[i], helperFunction);
            if (helperClass == null || !this.classImplementsMethod(helperClass, helperFunction)) continue;
            return helperClass;
        }
        Class superClass = helpedClass.getSuperclass();
        if (superClass != null) {
            return this.helperClassForClass(superClass, helperFunction);
        }
        return null;
    }

    protected boolean classImplementsMethod(Class theClass, String methodName) {
        Method[] methods = theClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }
}

