/*
 * Decompiled with CFR 0.152.
 */
package ognl.webobjects;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPropertyListSerialization;
import ognl.DynamicSubscript;
import ognl.NoSuchPropertyException;
import ognl.OgnlException;
import ognl.webobjects.NSObjectPropertyAccessor;

public class NSArrayPropertyAccessor
extends NSObjectPropertyAccessor {
    public Object getProperty(Object target, Object name) throws OgnlException {
        if (name instanceof String) {
            return super.getProperty(target, name);
        }
        NSArray array = (NSArray)target;
        if (name instanceof Number) {
            return array.objectAtIndex(((Number)name).intValue());
        }
        if (name instanceof DynamicSubscript) {
            int len = array.count();
            switch (((DynamicSubscript)name).getFlag()) {
                case 0: {
                    return len > 0 ? array.objectAtIndex(0) : null;
                }
                case 1: {
                    return len > 0 ? array.objectAtIndex(len / 2) : null;
                }
                case 2: {
                    return len > 0 ? array.lastObject() : null;
                }
                case 3: {
                    return array.clone();
                }
            }
        }
        throw new NoSuchPropertyException(target, name);
    }

    public void setProperty(Object target, Object name, Object value) throws OgnlException {
        if (name instanceof String) {
            super.setProperty(target, name, value);
            return;
        }
        NSMutableArray array = (NSMutableArray)target;
        if (name instanceof Number) {
            array.replaceObjectAtIndex(value, ((Number)name).intValue());
            return;
        }
        if (name instanceof DynamicSubscript) {
            int len = array.count();
            switch (((DynamicSubscript)name).getFlag()) {
                case 0: {
                    if (len > 0) {
                        array.replaceObjectAtIndex(value, 0);
                    }
                    return;
                }
                case 1: {
                    if (len > 0) {
                        array.replaceObjectAtIndex(value, len / 2);
                    }
                    return;
                }
                case 2: {
                    if (len > 0) {
                        array.replaceObjectAtIndex(value, len - 1);
                    }
                    return;
                }
                case 3: {
                    array.setArray(NSPropertyListSerialization.arrayForString((String)((String)value)));
                    return;
                }
            }
        }
        throw new NoSuchPropertyException(target, name);
    }
}

