/*
 * Decompiled with CFR 0.152.
 */
package er.plot;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import er.plot.ERPChart;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERPCategoryChart
extends ERPChart {
    public static final NSArray<String> SUPPORTED_TYPES = new NSArray((Object[])new String[]{"BarChart", "StackedBarChart", "BarChart3D", "StackedBarChart3D", "AreaChart", "StackedAreaChart", "LineChart", "WaterfallChart"});
    protected String _categoryKey;
    protected String _yName;
    protected String _xName;
    protected PlotOrientation _orientation;

    public ERPCategoryChart(WOContext context) {
        super(context);
    }

    @Override
    public void reset() {
        super.reset();
        this._xName = null;
        this._yName = null;
        this._categoryKey = null;
        this._orientation = null;
    }

    public String categoryKey() {
        if (this._categoryKey == null) {
            this._categoryKey = this.stringValueForBinding("categoryKey", null);
        }
        return this._categoryKey;
    }

    public String xName() {
        if (this._xName == null) {
            this._xName = this.stringValueForBinding("xName", "xName");
        }
        return this._xName;
    }

    public String yName() {
        if (this._yName == null) {
            this._yName = this.stringValueForBinding("yName", "yName");
        }
        return this._yName;
    }

    public PlotOrientation orientation() {
        if (this._orientation == null) {
            this._orientation = "horizontal".equals(this.stringValueForBinding("orientation", "vertical")) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        }
        return this._orientation;
    }

    @Override
    protected NSArray<String> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    protected JFreeChart createChart() {
        JFreeChart chart = null;
        String name = this.stringValueForBinding("name", "");
        Class<ChartFactory> clazz = ChartFactory.class;
        try {
            Method method = clazz.getDeclaredMethod("create" + this.chartType(), String.class, String.class, String.class, CategoryDataset.class, PlotOrientation.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            chart = (JFreeChart)method.invoke(clazz, name, this.xName(), this.yName(), this.dataset(), this.orientation(), this.showLegends() ? Boolean.TRUE : Boolean.FALSE, this.showToolTips() ? Boolean.TRUE : Boolean.FALSE, this.showUrls() ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)t);
        }
        return chart;
    }

    @Override
    protected Dataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Enumeration items = this.items().objectEnumerator();
        while (items.hasMoreElements()) {
            Object item = items.nextElement();
            Comparable name = (Comparable)NSKeyValueCodingAdditions.Utility.valueForKeyPath(item, (String)this.nameKey());
            Number value = (Number)NSKeyValueCodingAdditions.Utility.valueForKeyPath(item, (String)this.valueKey());
            Comparable category = null;
            if (this.categoryKey() != null) {
                category = (Comparable)NSKeyValueCodingAdditions.Utility.valueForKeyPath(item, (String)this.categoryKey());
            }
            dataset.setValue(value, name, category);
        }
        return dataset;
    }
}

