/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

public class WOParsedErrorLine {
    protected String _packageName;
    protected String _className;
    protected String _methodName;
    protected String _fileName;
    protected int _line;
    protected boolean _ignorePackage;

    public WOParsedErrorLine(String line) {
        int index;
        int atIndex = line.indexOf("at ") + 3;
        int classIndex = line.indexOf(40) + 1;
        int methodIndex = line.lastIndexOf(46, classIndex - 2) + 1;
        int lineIndex = line.lastIndexOf(58);
        if (lineIndex < 0) {
            this._line = -1;
            this._fileName = null;
        } else {
            if ((index = line.indexOf(41, ++lineIndex)) < 0) {
                index = line.length();
            }
            String string = line.substring(lineIndex, index);
            try {
                this._line = Integer.parseInt(string);
                this._fileName = line.substring(classIndex, lineIndex - 1);
            }
            catch (NumberFormatException ex) {
                this._line = -1;
                this._fileName = null;
            }
        }
        this._methodName = line.substring(methodIndex, classIndex - 1);
        this._packageName = line.substring(atIndex, methodIndex - 1);
        index = this._packageName.lastIndexOf(46);
        if (index >= 0) {
            this._className = this._packageName.substring(index + 1);
            this._packageName = this._packageName.substring(0, index);
        } else {
            this._className = this._packageName;
        }
        if (this._line < 0) {
            this._fileName = this._className + ".java";
        }
        this._ignorePackage = false;
    }

    public String packageName() {
        return this._packageName;
    }

    public String className() {
        return this._className;
    }

    public String packageClassPath() {
        if (this._packageName == this._className) {
            return this._className;
        }
        return this._packageName + "." + this._className;
    }

    public String methodName() {
        return this._methodName;
    }

    public boolean isDisable() {
        return this._line < 0 || this._ignorePackage;
    }

    protected void setIgnorePackage(boolean yn) {
        this._ignorePackage = yn;
    }

    public String fileName() {
        return this._fileName;
    }

    public String lineNumber() {
        if (this._line >= 0) {
            return String.valueOf(this._line);
        }
        return "NA";
    }

    public int line() {
        return this._line;
    }

    public String toString() {
        String fileInfo;
        String lineInfo = this._line >= 0 ? String.valueOf(this._line) : "No line info due to compiled code";
        String string = fileInfo = this._line >= 0 ? this._fileName : "Compiled code no file info";
        if (this._packageName == this._className) {
            return "class : " + this._className + ": " + this._methodName + " in file :" + fileInfo + " - line :" + lineInfo;
        }
        return "In package : " + this._packageName + ", class : " + this._className + " method : " + this._methodName + " in file :" + fileInfo + " - line :" + lineInfo;
    }
}

