/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class MiscUtil {
    public static String identityToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public static String identityToString(Class klass) {
        if (klass == null) {
            return "null";
        }
        return klass.getName() + "@" + MiscUtil.identityToString(klass.getClassLoader());
    }

    public static String identityToString(Class[] classes) {
        if (classes == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < classes.length; ++i) {
            Class klass = classes[i];
            sb.append(MiscUtil.identityToString(klass));
            if (i >= classes.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static Class[] add(Class[] array, Class element) {
        if (element == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            return new Class[]{element};
        }
        Class[] result = new Class[array.length + 1];
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = element;
        return result;
    }

    public static ClassLoader getSystemClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }
}

