/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.zeroturnaround.javarebel.Reloader;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.integration.util.ClassReflectionUtil;

public class ReloaderUtil {
    private static final Reloader reloader = ReloaderFactory.getInstance();

    public static void checkAndReload(Collection classes) {
        if (classes == null) {
            return;
        }
        Iterator<Object> it = Arrays.asList(classes.toArray()).iterator();
        while (it.hasNext()) {
            reloader.checkAndReload((Class)it.next());
        }
    }

    public static boolean isReloadingAnyClass(Collection classes) {
        return ReloaderUtil.isReloadingAnyClass(classes, null);
    }

    public static boolean isReloadingAnyClass(Collection classes, Class exclude) {
        if (classes == null) {
            return false;
        }
        Iterator<Object> it = Arrays.asList(classes.toArray()).iterator();
        while (it.hasNext()) {
            Class klass = (Class)it.next();
            if (exclude != null && exclude.equals(klass) || !reloader.isReloadingClass(klass)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsReloadableClass(Collection classes) {
        if (classes == null) {
            return false;
        }
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class klass = (Class)it.next();
            if (!ReloaderUtil.isRelodableClass(klass)) continue;
            return true;
        }
        return false;
    }

    public static Collection getReloadableClasses(Collection classes) {
        if (classes == null) {
            return null;
        }
        ArrayList<Class> result = new ArrayList<Class>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class klass = (Class)it.next();
            if (!ReloaderUtil.isRelodableClass(klass)) continue;
            result.add(klass);
        }
        return result;
    }

    private static Set retainReloadableClasses(Set classes) {
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class klass = (Class)it.next();
            if (ReloaderUtil.isRelodableClass(klass)) continue;
            it.remove();
        }
        return classes;
    }

    private static boolean isRelodableClass(Class klass) {
        if (klass == null) {
            return false;
        }
        String name = klass.getName();
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("net.sf.cglib.")) {
            return false;
        }
        return reloader.isReloadableClass(klass);
    }

    public static boolean isReloadableClassHierarchy(Class klass) {
        return ReloaderUtil.containsReloadableClass(ClassReflectionUtil.getClassHierarchy(klass));
    }

    public static boolean existsReloadableClassHierarchy(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            Class klass = classes[i];
            if (!ReloaderUtil.isReloadableClassHierarchy(klass)) continue;
            return true;
        }
        return false;
    }

    public static Set getReloadableClassHierarchy(Class klass) {
        return ReloaderUtil.retainReloadableClasses(ClassReflectionUtil.getClassHierarchy(klass));
    }

    public static Set getReloadableClassHierarchies(Class[] classes) {
        return ReloaderUtil.retainReloadableClasses(ClassReflectionUtil.getClassHierarchies(classes));
    }

    public static Set getReloadableClassHierarchies(Collection classes) {
        return ReloaderUtil.retainReloadableClasses(ClassReflectionUtil.getClassHierarchies(classes));
    }

    public static Set withParents(Class klass) {
        return ReloaderUtil.getReloadableClassHierarchy(klass);
    }

    public static Set getParents(Class klass) {
        Set result = ReloaderUtil.getReloadableClassHierarchy(klass);
        result.remove(klass);
        return result;
    }

    public static Set withParentInterfaces(Class klass) {
        Set result = ClassReflectionUtil.getClassHierarchies(klass.getInterfaces());
        result.add(klass);
        ReloaderUtil.retainReloadableClasses(result);
        return result;
    }

    public static Set withParentInterfaces(Collection classes) {
        Set result = ClassReflectionUtil.getClassHierarchies(ClassReflectionUtil.getInterfaces(classes));
        result.addAll(classes);
        ReloaderUtil.retainReloadableClasses(result);
        return result;
    }

    public static Set getInterfaces(Class klass) {
        return ReloaderUtil.getReloadableClassHierarchies(klass.getInterfaces());
    }
}

