/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.ClassLoaderDestructionListener;
import org.zeroturnaround.javarebel.IntegrationFactory;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.RequestIntegrationFactory;
import org.zeroturnaround.javarebel.RequestListener;

public class WeakUtil {
    public static List createWeakReferenceList(Collection elements) {
        if (elements == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object == null) continue;
            result.add(new WeakReference(object));
        }
        return result;
    }

    public static Set createWeakHashSet() {
        return WeakUtil.createWeakHashSetInternal(null);
    }

    public static Set createWeakHashSet(Collection elements) {
        if (elements == null) {
            return null;
        }
        return WeakUtil.createWeakHashSetInternal(elements);
    }

    private static Set createWeakHashSetInternal(Collection elements) {
        final WeakHashMap map = new WeakHashMap();
        if (elements != null) {
            WeakUtil.fill(map, elements);
        }
        return new FilterSet(map.keySet()){

            public boolean add(Object o) {
                boolean modified = !map.containsKey(o);
                map.put(o, null);
                return modified;
            }
        };
    }

    private static void fill(Map map, Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            map.put(object, null);
        }
    }

    public static ClassBytecodeProcessor weakCBP(ClassBytecodeProcessor cbp) {
        return new WeakClassBytecodeProcessorAdapter(cbp);
    }

    public static ClassEventListener weakCEL(ClassEventListener cel) {
        return new WeakClassEventListenerAdapter(cel);
    }

    public static ClassLoaderDestructionListener weakCDL(ClassLoaderDestructionListener cdl) {
        return new WeakClassLoaderDestructionListener(cdl);
    }

    public static RequestListener weak(RequestListener listener) {
        return new WeakRequestListener(listener);
    }

    private static class WeakRequestListener
    implements RequestListener {
        private final WeakReference ref;

        public WeakRequestListener(RequestListener target) {
            this.ref = new WeakReference<RequestListener>(target);
        }

        public boolean rawRequest(Object request, Object response) {
            RequestListener target = (RequestListener)this.ref.get();
            if (target != null) {
                return target.rawRequest(request, response);
            }
            RequestIntegrationFactory.getInstance().removeRequestListener((RequestListener)this);
            return false;
        }

        public void beforeRequest() {
            RequestListener target = (RequestListener)this.ref.get();
            if (target != null) {
                target.beforeRequest();
            }
        }

        public void requestFinally() {
            RequestListener target = (RequestListener)this.ref.get();
            if (target != null) {
                target.requestFinally();
            }
        }
    }

    private static class WeakClassLoaderDestructionListener
    implements ClassLoaderDestructionListener {
        private final WeakReference cdl;

        public WeakClassLoaderDestructionListener(ClassLoaderDestructionListener cdl) {
            this.cdl = new WeakReference<ClassLoaderDestructionListener>(cdl);
        }

        public void onDestroy(ClassLoader cl) {
            ClassLoaderDestructionListener delegate = (ClassLoaderDestructionListener)this.cdl.get();
            if (delegate == null) {
                IntegrationFactory.getInstance().removeClassLoaderDestructionListener((ClassLoaderDestructionListener)this);
                return;
            }
            delegate.onDestroy(cl);
        }
    }

    private static class WeakClassEventListenerAdapter
    implements ClassEventListener {
        private final WeakReference cel;
        private final int priority;

        public WeakClassEventListenerAdapter(ClassEventListener cel) {
            this.cel = new WeakReference<ClassEventListener>(cel);
            this.priority = cel.priority();
        }

        public void onClassEvent(int eventType, Class klass) {
            ClassEventListener delegate = (ClassEventListener)this.cel.get();
            if (delegate == null) {
                ReloaderFactory.getInstance().removeClassReloadListener((ClassEventListener)this);
                return;
            }
            delegate.onClassEvent(eventType, klass);
        }

        public int priority() {
            return this.priority;
        }
    }

    private static class WeakClassBytecodeProcessorAdapter
    implements ClassBytecodeProcessor {
        private final WeakReference cbp;

        public WeakClassBytecodeProcessorAdapter(ClassBytecodeProcessor cbp) {
            this.cbp = new WeakReference<ClassBytecodeProcessor>(cbp);
        }

        public byte[] process(ClassLoader cl, String classname, byte[] bytecode) {
            ClassBytecodeProcessor delegate = (ClassBytecodeProcessor)this.cbp.get();
            if (delegate == null) {
                return bytecode;
            }
            return delegate.process(cl, classname, bytecode);
        }
    }

    private static class FilterSet
    implements Set {
        private final Set s;

        public FilterSet(Set s) {
            this.s = s;
        }

        public boolean add(Object o) {
            return this.s.add(o);
        }

        public boolean addAll(Collection c) {
            return this.s.addAll(c);
        }

        public void clear() {
            this.s.clear();
        }

        public boolean contains(Object o) {
            return this.s.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this.s.containsAll(c);
        }

        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        public Iterator iterator() {
            return this.s.iterator();
        }

        public boolean remove(Object o) {
            return this.s.remove(o);
        }

        public boolean removeAll(Collection c) {
            return this.s.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.s.retainAll(c);
        }

        public int size() {
            return this.s.size();
        }

        public Object[] toArray() {
            return this.s.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.s.toArray(a);
        }
    }
}

