/*
 * Decompiled with CFR 0.152.
 */
package er.modern.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class ERMDatePicker
extends ERXStatelessComponent {
    static final Logger log = Logger.getLogger(ERMDatePicker.class);
    public static final String FRAMEWORK_NAME = "ERModernDirectToWeb";
    public static final String CSS_FILENAME = "datepicker.css";
    private String _elementID;
    private String _openScript;
    private String _createScript;

    public ERMDatePicker(WOContext context) {
        super(context);
    }

    public void awake() {
        super.awake();
    }

    public void reset() {
        super.reset();
        this._elementID = null;
        this._openScript = null;
        this._createScript = null;
    }

    public NSTimestamp value() {
        return (NSTimestamp)this.objectValueForBinding("value");
    }

    public void setValue(NSTimestamp newDateIn) {
        this.setValueForBinding(newDateIn, "value");
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        if (this.booleanValueForBinding("injectStylesheet")) {
            String framework = this.stringValueForBinding("cssFramework", FRAMEWORK_NAME);
            String cssFilename = this.stringValueForBinding("cssFile", CSS_FILENAME);
            ERXResponseRewriter.addStylesheetResourceInHead((WOResponse)response, (WOContext)context, (String)framework, (String)cssFilename);
        }
        String datepickerjsName = ERXApplication.isDevelopmentModeSafe() ? "datepicker_lg.js" : "datepicker.js";
        ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)FRAMEWORK_NAME, (String)datepickerjsName);
        String langScript = ERXLocalizer.currentLocalizer().languageCode() + ".js";
        ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)FRAMEWORK_NAME, (String)("lang/" + langScript));
        super.appendToResponse(response, context);
    }

    public String dateformat() {
        String format = this.stringValueForBinding("dateformat");
        if (format == null) {
            format = "%m/%d/%Y";
        }
        return format;
    }

    public String name() {
        return this.elementID();
    }

    public void setDateformat(String value) {
        this.setValueForBinding(value, "dateformat");
    }

    public String dateFormatString() {
        String result = this.dateformat();
        result = ERXStringUtilities.replaceStringByStringInString((String)"-", (String)"-ds", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%a", (String)"-D", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%A", (String)"-l", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%b", (String)"-M", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%B", (String)"-F", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%d", (String)"-d", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%e", (String)"-j", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%m", (String)"-m", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%y", (String)"-y", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%Y", (String)"-Y", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"%w", (String)"-w", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)" ", (String)"-sp", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)".", (String)"-dt", (String)result);
        result = ERXStringUtilities.replaceStringByStringInString((String)"/", (String)"-sl", (String)result);
        if ((result = ERXStringUtilities.replaceStringByStringInString((String)",", (String)"-cc", (String)result)).indexOf("-") == 0) {
            result = result.substring(1);
        }
        return result;
    }

    public String datePickerCreateScript() {
        if (this._createScript == null) {
            this._createScript = "datePickerController.destroyDatePicker('" + this.elementID() + "'); datePickerController.createDatePicker(" + this.datePickerOptions() + ")";
        }
        log.debug((Object)this._createScript);
        return this._createScript;
    }

    private String datePickerOptions() {
        boolean hideControl;
        boolean fillGrid;
        boolean hideInput;
        boolean noDrag;
        String cursorDate;
        boolean noTodayButton;
        boolean showWeeks;
        int finalOpacity;
        boolean disableFade;
        String enabledDates;
        String disabledDates;
        String disabledDays;
        String rangeHigh;
        String rangeLow;
        String opts = "{";
        opts = opts + "formElements:{'" + this.elementID() + "':'" + this.dateFormatString() + "'}";
        String highlightDays = this.stringValueForBinding("highlightDays");
        if (this.ne(highlightDays)) {
            opts = opts + ",highlightDays:" + highlightDays;
        }
        if (this.ne(rangeLow = this.stringValueForBinding("rangeLow"))) {
            opts = opts + ",rangeLow:'" + rangeLow + "'";
        }
        if (this.ne(rangeHigh = this.stringValueForBinding("rangeHigh"))) {
            opts = opts + ",rangeHigh:'" + rangeHigh + "'";
        }
        if (this.ne(disabledDays = this.stringValueForBinding("disabledDays"))) {
            opts = opts + ",disabledDays:" + disabledDays;
        }
        if (this.ne(disabledDates = this.stringValueForBinding("disabledDates"))) {
            opts = opts + ",disabledDates:" + this.parseDateRangeString(disabledDates);
        }
        if (this.ne(enabledDates = this.stringValueForBinding("enabledDates"))) {
            opts = opts + ",enabledDates:" + this.parseDateRangeString(enabledDates);
        }
        if (disableFade = this.booleanValueForBinding("noFadeEffect", false)) {
            opts = opts + ",noFadeEffect:true";
        }
        if ((finalOpacity = this.intValueForBinding("finalOpacity", 0)) > 20) {
            opts = opts + ",finalOpacity:" + finalOpacity;
        }
        if (showWeeks = this.booleanValueForBinding("showWeeks", false)) {
            opts = opts + ",showWeeks:true";
        }
        if (noTodayButton = this.booleanValueForBinding("noTodayButton", false)) {
            opts = opts + ",noTodayButton:true";
        }
        if (this.ne(cursorDate = this.stringValueForBinding("cursorDate"))) {
            opts = opts + ",cursorDate:'" + cursorDate + "'";
        }
        if (noDrag = this.booleanValueForBinding("dragDisabled", false)) {
            opts = opts + ",dragDisabled:true";
        }
        if (hideInput = this.booleanValueForBinding("hideInput", false)) {
            opts = opts + ",hideInput:true";
        }
        if (fillGrid = this.booleanValueForBinding("fillGrid", false)) {
            opts = opts + ",fillGrid:true";
            boolean constrainSelection = this.booleanValueForBinding("constrainSelection", true);
            opts = opts + ",constrainSelection:" + constrainSelection;
        }
        if (hideControl = this.booleanValueForBinding("hideControl", false)) {
            opts = opts + ",hideControl:true";
        }
        opts = opts + "}";
        return opts;
    }

    public String datePickerOpenScript() {
        if (this._openScript == null) {
            this._openScript = "datePickerController.show('" + this.elementID() + "');";
        }
        return this._openScript;
    }

    public String elementID() {
        if (this._elementID == null) {
            this._elementID = ERXStringUtilities.safeIdentifierName((String)this.context().elementID(), (String)"datebox");
        }
        return this._elementID;
    }

    private String parseDateRangeString(String dateRange) {
        String result = "";
        if (dateRange.indexOf(":") > 0) {
            NSArray components = NSArray.componentsSeparatedByString((String)dateRange, (String)":");
            String firstDate = "'" + (String)components.objectAtIndex(0) + "'";
            String lastDate = (String)components.objectAtIndex(1);
            if (!lastDate.equals("1")) {
                lastDate = "'" + lastDate + "'";
            }
            result = "{" + firstDate + ":" + lastDate + "}";
        } else {
            result = "{'" + dateRange + "':1}";
        }
        return result;
    }

    private boolean ne(String v) {
        return v != null && v.length() > 0;
    }

    public static String optionsStringForTimestamp(NSTimestamp ts) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        return formatter.format((Date)ts);
    }
}

