/*
 * Decompiled with CFR 0.152.
 */
package er.modern.directtoweb.components.buttons;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.directtoweb.ConfirmPageInterface;
import com.webobjects.directtoweb.D2W;
import com.webobjects.directtoweb.D2WPage;
import com.webobjects.directtoweb.NextPageDelegate;
import com.webobjects.eocontrol.EODetailDataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSValidation;
import er.directtoweb.delegates.ERDDeletionDelegate;
import er.directtoweb.delegates.ERDPageDelegate;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXGuardedObjectInterface;
import er.extensions.localization.ERXLocalizer;
import er.modern.directtoweb.components.buttons.ERMDActionButton;
import org.apache.log4j.Logger;

public class ERMDDeleteButton
extends ERMDActionButton {
    private static final Logger log = Logger.getLogger(ERMDDeleteButton.class);
    public static final String DisplayGroupObjectDeleted = "DisplayGroupObjectDeleted";
    private String _cancelButtonLabel;
    private String _cancelButtonClass;
    private String _deleteButtonClass;
    private String _localUpdateContainer;
    protected String _dialogMessage;
    protected String _disabledButtonClass;

    public ERMDDeleteButton(WOContext context) {
        super(context);
    }

    public WOActionResults buttonAction() {
        WOActionResults result = null;
        if (this.shouldUseAjax()) {
            EOEditingContext ec = ERXEC.newEditingContext((EOObjectStore)this.object().editingContext());
            EOEnterpriseObject localObj = ERXEOControlUtilities.localInstanceOfObject((EOEditingContext)ec, (EOEnterpriseObject)this.object());
            this.d2wContext().takeValueForKey((Object)localObj, "objectPendingDeletion");
        } else {
            ConfirmPageInterface nextPage = (ConfirmPageInterface)D2W.factory().pageForConfigurationNamed((String)this.valueForBinding("confirmDeleteConfigurationName"), this.session());
            nextPage.setConfirmDelegate((NextPageDelegate)new ERDDeletionDelegate(this.object(), this.dataSource(), this.context().page()));
            nextPage.setCancelDelegate((NextPageDelegate)new ERDPageDelegate(this.context().page()));
            D2WPage d2wPage = (D2WPage)nextPage;
            String message = ERXLocalizer.currentLocalizer().localizedTemplateStringForKeyWithObject("ERDTrashcan.confirmDeletionMessage", (Object)this.d2wContext());
            nextPage.setMessage(message);
            d2wPage.setObject(this.object());
            result = (WOActionResults)nextPage;
        }
        return result;
    }

    public WOActionResults deleteAction() {
        return this.deleteObjectWithFinalCommit(true);
    }

    public WOActionResults deleteObjectWithFinalCommit(boolean finalCommit) {
        this.dataSource().deleteObject((Object)this.object());
        EOEnterpriseObject obj = (EOEnterpriseObject)this.d2wContext().valueForKey("objectPendingDeletion");
        obj.editingContext().deleteObject(obj);
        try {
            obj.editingContext().saveChanges();
            if (this.displayGroup() != null && this.displayGroup().displayedObjects().count() == 0) {
                this.displayGroup().displayPreviousBatch();
            }
            if (finalCommit) {
                this.object().editingContext().saveChanges();
            }
            this.d2wContext().takeValueForKey(null, "objectPendingDeletion");
            this.postDeleteNotification();
        }
        catch (NSValidation.ValidationException e) {
            this.parent().validationFailedWithException((Throwable)e, e.object(), e.key());
        }
        return null;
    }

    public WOActionResults cancelAction() {
        EOEnterpriseObject obj = (EOEnterpriseObject)this.d2wContext().valueForKey("objectPendingDeletion");
        obj.editingContext().revert();
        this.d2wContext().takeValueForKey(null, "objectPendingDeletion");
        return null;
    }

    public void postDeleteNotification() {
        D2WPage obj = this.parentD2WPage();
        String OBJECT_KEY = "object";
        NSMutableDictionary userInfo = new NSMutableDictionary((Object)obj, (Object)OBJECT_KEY);
        if (this.dataSource() instanceof EODetailDataSource) {
            EODetailDataSource dds = (EODetailDataSource)this.dataSource();
            userInfo.setObjectForKey(dds.masterObject(), (Object)OBJECT_KEY);
            userInfo.setObjectForKey((Object)dds.detailKey(), (Object)"propertyKey");
        }
        NSNotificationCenter.defaultCenter().postNotification("ERMDActionButtonPerformedDelete", (Object)obj, (NSDictionary)userInfo);
    }

    public boolean canDelete() {
        return this.object() != null && this.object() instanceof ERXGuardedObjectInterface ? ((ERXGuardedObjectInterface)this.object()).canDelete() : true;
    }

    public String buttonLabel() {
        if (this._buttonLabel == null) {
            this._buttonLabel = this.stringValueForBinding("deleteButtonLabel", "Delete");
        }
        return this._buttonLabel;
    }

    public String cancelButtonLabel() {
        if (this._cancelButtonLabel == null) {
            this._cancelButtonLabel = this.stringValueForBinding("cancelButtonLabel", "Cancel");
        }
        return this._cancelButtonLabel;
    }

    public String buttonClass() {
        String result = null;
        result = this.canDelete() && !this.showDialog() ? this.activeButtonClass() : this.disabledButtonClass();
        return result;
    }

    public String activeButtonClass() {
        if (this._buttonClass == null) {
            this._buttonClass = this.stringValueForBinding("classForDeleteObjButton", "Button ObjButton DeleteObjButton");
        }
        return this._buttonClass;
    }

    public String disabledButtonClass() {
        if (this._disabledButtonClass == null) {
            this._disabledButtonClass = this.stringValueForBinding("classForDisabledDeleteObjButton", "Button ObjButton DisabledObjButton DisabledDeleteObjButton");
        }
        return this._disabledButtonClass;
    }

    public String cancelButtonClass() {
        if (this._cancelButtonClass == null) {
            this._cancelButtonClass = this.stringValueForBinding("classForCancelDialogButton", "Button DialogButton CancelDialogButton");
        }
        return this._cancelButtonClass;
    }

    public String deleteButtonClass() {
        if (this._deleteButtonClass == null) {
            this._deleteButtonClass = this.stringValueForBinding("classForDeleteDialogButton", "Button DialogButton DeleteDialogButton");
        }
        return this._deleteButtonClass;
    }

    public boolean showDialog() {
        boolean show = this.object() != null && ERXEOControlUtilities.eoEquals((EOEnterpriseObject)this.object(), (EOEnterpriseObject)((EOEnterpriseObject)this.d2wContext().valueForKey("objectPendingDeletion")));
        return show;
    }

    public Boolean useAjax() {
        if (this._useAjax == null) {
            this._useAjax = this.shouldUseAjax();
        }
        return this._useAjax;
    }

    public String localUpdateContainer() {
        if (this._localUpdateContainer == null) {
            this._localUpdateContainer = (String)this.valueForBinding("idForPropertyContainer");
            this._localUpdateContainer = this._localUpdateContainer + "_" + this.object().hashCode();
        }
        return this._localUpdateContainer;
    }

    public String dialogMessage() {
        if (this._dialogMessage == null) {
            this._dialogMessage = (String)this.valueForBinding("confirmDeleteMessage");
        }
        return this._dialogMessage;
    }

    public static interface Keys
    extends ERMDActionButton.Keys {
        public static final String deleteButtonLabel = "deleteButtonLabel";
        public static final String classForDeleteObjButton = "classForDeleteObjButton";
        public static final String classForDisabledDeleteObjButton = "classForDisabledDeleteObjButton";
        public static final String objectPendingDeletion = "objectPendingDeletion";
        public static final String cancelButtonLabel = "cancelButtonLabel";
        public static final String classForCancelDialogButton = "classForCancelDialogButton";
        public static final String classForDeleteDialogButton = "classForDeleteDialogButton";
        public static final String confirmDeleteMessage = "confirmDeleteMessage";
    }
}

