/*
 * Decompiled with CFR 0.152.
 */
package er.rest.example.controllers;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSArray;
import er.extensions.eof.ERXKey;
import er.extensions.eof.ERXKeyFilter;
import er.rest.ERXRestFetchSpecification;
import er.rest.example.model.Company;
import er.rest.example.model.Person;
import er.rest.routes.ERXDefaultRouteController;

public class PersonController
extends ERXDefaultRouteController {
    public PersonController(WORequest request) {
        super(request);
    }

    protected boolean isAutomaticHtmlRoutingEnabled() {
        return true;
    }

    protected Person person() {
        Person person = (Person)((Object)this.routeObjectForKey("person"));
        return person;
    }

    public static ERXKeyFilter queryFilter() {
        ERXKeyFilter filter = ERXKeyFilter.filterWithAllRecursive();
        return filter;
    }

    public static ERXKeyFilter showFilter() {
        ERXKeyFilter filter = ERXKeyFilter.filterWithAttributes();
        filter.include(Person.COMPANY).includeAttributes();
        filter.include(Person.PETS).includeAttributes();
        filter.include(new ERXKey("derivedCurrentTime"));
        return filter;
    }

    public static ERXKeyFilter updateFilter() {
        ERXKeyFilter filter = ERXKeyFilter.filterWithAttributes();
        filter.include(Person.COMPANY).includeAttributes();
        return filter;
    }

    public WOActionResults createAction() {
        Person person = (Person)((Object)this.create(PersonController.updateFilter()));
        this.editingContext().saveChanges();
        return this.response((Object)person, PersonController.showFilter());
    }

    public WOActionResults updateAction() {
        Person person = this.person();
        this.update((Object)person, PersonController.updateFilter());
        this.editingContext().saveChanges();
        return this.response((Object)person, PersonController.showFilter());
    }

    public WOActionResults lockedUpdateAction() {
        Person person = this.person();
        ERXKeyFilter filter = ERXKeyFilter.filterWithAttributes();
        filter.include(Person.COMPANY).includeAttributes();
        filter.lockRelationship(new ERXKey[]{Person.COMPANY});
        this.update((Object)person, filter);
        this.editingContext().saveChanges();
        return this.response((Object)person, PersonController.showFilter());
    }

    public WOActionResults securityUpdateAction() {
        Person person = this.person();
        ERXKeyFilter filter = ERXKeyFilter.filterWithAttributes();
        filter.include(Person.COMPANY).includeAttributes();
        filter.setDelegate(new ERXKeyFilter.Delegate(){

            public void willTakeValueForKey(Object target, Object value, String key) throws SecurityException {
                if (target instanceof Company && "name".equals(key) && value != null && ((String)value).contains("Microsoft")) {
                    throw new SecurityException("You can't change a Person's company name to Microsoft.");
                }
            }

            public void didTakeValueForKey(Object target, Object value, String key) throws SecurityException {
            }

            public void didSkipValueForKey(Object target, Object value, String key) throws SecurityException {
            }
        });
        this.update((Object)person, filter);
        this.editingContext().saveChanges();
        return this.response((Object)person, PersonController.showFilter());
    }

    public WOActionResults destroyAction() throws Throwable {
        Person person = this.person();
        person.delete();
        this.editingContext().saveChanges();
        return this.response((Object)person, PersonController.showFilter());
    }

    public WOActionResults newAction() throws Throwable {
        Person person = Person.createPerson(this.editingContext(), "New Person");
        return this.response((Object)person, PersonController.showFilter());
    }

    public WOActionResults showAction() {
        return this.response((Object)this.person(), PersonController.showFilter());
    }

    public WOActionResults indexAction() {
        if (this.isSchemaRequest()) {
            return this.schemaResponse(PersonController.showFilter());
        }
        ERXRestFetchSpecification fetchSpec = new ERXRestFetchSpecification("Person", null, null, PersonController.queryFilter(), (NSArray)Person.NAME.ascs(), 25);
        return this.response(fetchSpec, PersonController.showFilter());
    }
}

