/*
 * Decompiled with CFR 0.152.
 */
package net.spy.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import net.spy.util.CloseUtil;
import net.spy.util.SpyToker;
import net.spy.util.SpyUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class BuildInfoTask
extends Task {
    private static final String BUILDINFO = "net/spy/ant/BuildInfo.txt";
    private String pkg = null;
    private String buildProps = null;
    private String changelog = null;
    private String destdir = ".";

    public void setPackage(String to) {
        this.pkg = to;
    }

    public void setBuildprops(String to) {
        this.buildProps = to;
    }

    public void setChangelog(String to) {
        this.changelog = to;
    }

    public void setDestdir(String to) {
        this.destdir = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.pkg == null) {
            throw new BuildException("package name required");
        }
        if (this.buildProps == null) {
            throw new BuildException("buildprops required");
        }
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        URL u = cl.getResource(BUILDINFO);
        if (u == null) {
            throw new BuildException("Can't find net/spy/ant/BuildInfo.txt");
        }
        try {
            InputStreamReader ir = new InputStreamReader(u.openStream());
            String s = null;
            try {
                s = SpyUtil.getReaderAsString(ir);
            }
            finally {
                CloseUtil.close(ir);
            }
            HashMap<String, String> tokens = new HashMap<String, String>();
            tokens.put("PACKAGE", this.pkg);
            tokens.put("CHANGELOG", this.changelog);
            tokens.put("BUILDPROPS", this.buildProps);
            String output = new SpyToker().tokenizeString(s, tokens);
            String outFileName = this.destdir + File.separatorChar + this.pkg.replace('.', File.separatorChar);
            new File(outFileName).mkdirs();
            outFileName = outFileName + File.separatorChar + "BuildInfo.java";
            File outFile = new File(outFileName);
            FileWriter fw = new FileWriter(outFile);
            try {
                fw.write(output);
            }
            finally {
                CloseUtil.close(fw);
            }
            System.out.println("Wrote " + this.pkg + ".BuildInfo");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException("Could not process buildinfo", (Throwable)e);
        }
    }
}

