/*
 * Decompiled with CFR 0.152.
 */
package net.spy.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.spy.concurrent.RetryableCallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryableExecutorCompletionService<V>
implements CompletionService<V> {
    private ExecutorService executor = null;
    BlockingQueue<Future<V>> completionQueue = new LinkedBlockingQueue<Future<V>>();

    public RetryableExecutorCompletionService(ExecutorService e) {
        this.executor = e;
    }

    @Override
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> submit(Callable<V> c) {
        Future<Object> rv = null;
        if (c instanceof RetryableCallable) {
            TrackingCallable tc;
            TrackingCallable trackingCallable = tc = new TrackingCallable((RetryableCallable)c);
            synchronized (trackingCallable) {
                rv = this.executor.submit(tc);
                tc.setFuture(rv);
            }
        } else {
            rv = new QueueingFuture(c);
            this.executor.submit((Runnable)((Object)rv));
        }
        return rv;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        QueueingFuture rv = new QueueingFuture(task, result);
        this.executor.execute(rv);
        return rv;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TrackingCallable
    implements RetryableCallable<V> {
        private RetryableCallable<V> callable = null;
        private Future<V> future = null;

        public TrackingCallable(RetryableCallable<V> c) {
            this.callable = c;
        }

        public void setFuture(Future<V> f) {
            this.future = f;
            assert (this.future != null) : "Future is null";
        }

        @Override
        public long getRetryDelay() {
            return this.callable.getRetryDelay();
        }

        @Override
        public synchronized void onComplete(boolean success, Object res) {
            this.callable.onComplete(success, res);
            assert (this.future != null) : "Future is null";
            RetryableExecutorCompletionService.this.completionQueue.add(this.future);
        }

        @Override
        public void onExecutionException(ExecutionException exception) {
            this.callable.onExecutionException(null);
        }

        @Override
        public V call() throws Exception {
            assert (this.future != null) : "Future is null";
            return this.callable.call();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueueingFuture
    extends FutureTask<V> {
        QueueingFuture(Callable<V> c) {
            super(c);
        }

        QueueingFuture(Runnable t, V r) {
            super(t, r);
        }

        @Override
        protected void done() {
            RetryableExecutorCompletionService.this.completionQueue.add(this);
        }
    }
}

