/*
 * Decompiled with CFR 0.152.
 */
package net.spy.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.spy.concurrent.RetryableCallable;
import net.spy.concurrent.RetryableExecutorCompletionService;
import net.spy.concurrent.ScheduledCompletionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledExecutorCompletionService<V>
extends RetryableExecutorCompletionService<V>
implements ScheduledCompletionService<V> {
    private ScheduledExecutorService executor = null;

    public ScheduledExecutorCompletionService(ScheduledExecutorService ex) {
        super(ex);
        this.executor = ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> schedule(Callable<V> c, long d, TimeUnit unit) {
        Future rv = null;
        if (c instanceof RetryableCallable) {
            RetryableExecutorCompletionService.TrackingCallable tc;
            RetryableExecutorCompletionService.TrackingCallable trackingCallable = tc = new RetryableExecutorCompletionService.TrackingCallable((RetryableCallable)c);
            synchronized (trackingCallable) {
                rv = this.executor.schedule(tc, d, unit);
                tc.setFuture(rv);
            }
        } else {
            rv = new RetryableExecutorCompletionService.QueueingFuture(c);
            this.executor.schedule((Runnable)((Object)rv), d, unit);
        }
        return rv;
    }

    @Override
    public Future<?> schedule(Runnable r, long d, TimeUnit unit) {
        RetryableExecutorCompletionService.QueueingFuture rv = new RetryableExecutorCompletionService.QueueingFuture(r, null);
        this.executor.schedule(rv, d, unit);
        return rv;
    }
}

