/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.db.OverDrawnException;

public class KeyStore {
    private BigDecimal start = null;
    private BigDecimal end = null;
    private AtomicReference<BigDecimal> current = null;
    private static final BigDecimal ONE = new BigDecimal(1);

    public KeyStore(BigDecimal s, BigDecimal e) {
        this.start = s;
        this.current = new AtomicReference<BigDecimal>(s);
        this.end = e;
    }

    public String toString() {
        return "KeyStore from " + this.start + " to " + this.end;
    }

    public BigDecimal nextKey() throws OverDrawnException {
        boolean found = false;
        BigDecimal rv = null;
        while (!found) {
            rv = this.current.get();
            if (rv.compareTo(this.end) > 0) {
                throw new OverDrawnException();
            }
            found = this.current.compareAndSet(rv, rv.add(ONE));
        }
        return rv;
    }
}

