/*
 * Decompiled with CFR 0.152.
 */
package net.spy.factory;

import java.util.Timer;
import java.util.TimerTask;
import net.spy.SpyObject;
import net.spy.factory.GenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheRefresher
extends SpyObject {
    private static CacheRefresher instance = null;
    private Timer timer = new Timer("CacheRefresh timer", true);

    protected CacheRefresher() {
    }

    public static synchronized CacheRefresher getInstance() {
        if (instance == null) {
            CacheRefresher.setInstance(new CacheRefresher());
        }
        return instance;
    }

    public static synchronized void setInstance(CacheRefresher to) {
        if (instance != null) {
            throw new IllegalStateException("Attempting to overwrite cache refresher instance");
        }
        instance = to;
    }

    public void shutdown() {
        this.timer.cancel();
        instance = null;
    }

    synchronized void performRecache(GenFactory<?> gf, long when) {
        if (when > gf.getLastRefresh()) {
            gf.recache();
        } else {
            this.getLogger().info("Avoiding unnecessary recache of %s.", gf);
        }
        gf.setNextRefresh(null);
    }

    public synchronized void recache(final GenFactory<?> gf, final long when, long delay) {
        TimerTask nextRefresh = gf.getNextRefresh();
        if (nextRefresh != null) {
            boolean canceled = nextRefresh.cancel();
            this.getLogger().debug("%s next refresh of %s, scheduling a future one.", canceled ? "Cancelled" : "Did not cancel", gf);
            nextRefresh = null;
        }
        nextRefresh = new TimerTask(){

            public void run() {
                CacheRefresher.this.performRecache(gf, when);
            }
        };
        this.timer.schedule(nextRefresh, delay);
        gf.setNextRefresh(nextRefresh);
    }
}

