/*
 * Decompiled with CFR 0.152.
 */
package net.spy.factory;

import java.util.Collection;
import java.util.TimerTask;
import net.spy.SpyObject;
import net.spy.cache.SimpleCache;
import net.spy.factory.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenFactory<T>
extends SpyObject {
    private String cacheKey = null;
    private long cacheTime = 0L;
    private long lastRefresh = 0L;
    private TimerTask nextRefresh = null;

    protected GenFactory(String key, long time) {
        if (key == null) {
            throw new NullPointerException("Cache key must not be null.");
        }
        if (time < 1L) {
            throw new IllegalArgumentException("Invalid cache time:  " + time);
        }
        this.cacheKey = key;
        this.cacheTime = time;
    }

    protected Storage<T> getCache() {
        SimpleCache sc = SimpleCache.getInstance();
        Storage<T> rv = (Storage<T>)sc.get(this.cacheKey);
        if (rv == null) {
            rv = this.setCache();
        }
        return rv;
    }

    private Storage<T> setCache() {
        Storage<T> rv = new Storage<T>(this.getInstances());
        this.lastRefresh = System.currentTimeMillis();
        SimpleCache sc = SimpleCache.getInstance();
        sc.store(this.cacheKey, rv, this.cacheTime);
        return rv;
    }

    protected void cacheInstance(T i) throws Exception {
        this.getCache().cacheInstance(i);
    }

    protected abstract Collection<T> getInstances();

    protected T handleNullLookup(String cacheName, Object key) {
        return null;
    }

    public T getObject(String cacheName, Object key) {
        Storage<T> ce = this.getCache();
        T rv = ce.getObject(cacheName, key);
        if (rv == null) {
            rv = this.handleNullLookup(cacheName, key);
        }
        return rv;
    }

    public T getObject(int id) {
        return this.getObject("id", id);
    }

    public Collection<T> getObjects(String cacheName, Object key) {
        Collection<T> rv = this.getCache().getObjects(cacheName, key);
        assert (rv != null);
        return rv;
    }

    public Collection<T> getObjects() {
        Storage<T> ce = this.getCache();
        return ce.getAllObjects();
    }

    public void recache() {
        this.setCache();
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    TimerTask getNextRefresh() {
        return this.nextRefresh;
    }

    void setNextRefresh(TimerTask next) {
        this.nextRefresh = next;
    }
}

