/*
 * Decompiled with CFR 0.152.
 */
package net.spy.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.spy.SpyObject;
import net.spy.factory.CacheKey;
import net.spy.factory.CacheKeyFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage<T>
extends SpyObject {
    private Collection<T> allObjects = null;
    private Map<String, Map<Object, T>> singleCache = null;
    private Map<String, Map<Object, List<T>>> multiCache = null;

    public Storage(Collection<T> obs) {
        this.allObjects = Collections.unmodifiableCollection(obs);
        this.singleCache = new HashMap<String, Map<Object, T>>();
        this.multiCache = new HashMap<String, Map<Object, List<T>>>();
        this.index();
    }

    private void storeEntry(CacheKey ck, Object key, T val) {
        if (key != null) {
            String name = ck.name();
            switch (ck.type()) {
                case SINGLE: {
                    Map<Object, T> sm = this.singleCache.get(name);
                    if (sm == null) {
                        sm = new HashMap<Object, T>();
                        this.singleCache.put(name, sm);
                    }
                    sm.put(key, val);
                    break;
                }
                case MULTI: {
                    List<T> l;
                    Map<Object, List<T>> mm = this.multiCache.get(name);
                    if (mm == null) {
                        mm = new HashMap<Object, List<T>>();
                        this.multiCache.put(name, mm);
                    }
                    if ((l = mm.get(key)) == null) {
                        l = new ArrayList<T>();
                        mm.put(key, l);
                    }
                    l.add(val);
                }
            }
        }
    }

    private void index() {
        for (T i : this.allObjects) {
            try {
                this.internalCacheInstance(i);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem indexing at " + i, e);
            }
        }
    }

    public void cacheInstance(T i) throws Exception {
        this.internalCacheInstance(i);
        if (!this.allObjects.contains(i)) {
            ArrayList<T> newAll = new ArrayList<T>(this.allObjects);
            newAll.add(i);
            this.allObjects = Collections.unmodifiableCollection(newAll);
        }
    }

    private void internalCacheInstance(T i) throws Exception {
        CacheKeyFinder ckf = CacheKeyFinder.getInstance();
        Map<CacheKey, CacheKeyFinder.Accessor> m = ckf.getCacheKeys(i.getClass());
        for (Map.Entry<CacheKey, CacheKeyFinder.Accessor> me : m.entrySet()) {
            this.storeEntry(me.getKey(), me.getValue().get(i), i);
        }
    }

    public Collection<T> getAllObjects() {
        return this.allObjects;
    }

    public T getObject(String cacheName, Object key) {
        T rv = null;
        Map<Object, T> ccache = this.singleCache.get(cacheName);
        if (ccache != null) {
            rv = ccache.get(key);
        }
        return rv;
    }

    public Collection<T> getObjects(String cacheName, Object key) {
        Collection<Object> rv = null;
        Map<Object, List<T>> m = this.multiCache.get(cacheName);
        if (m != null) {
            rv = m.get(key);
        }
        if (rv == null) {
            rv = Collections.emptyList();
        }
        return rv;
    }
}

