/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import java.util.ArrayList;
import java.util.Iterator;
import net.spy.SpyObject;
import net.spy.pool.GarbageCollector;
import net.spy.pool.PoolAble;
import net.spy.pool.PoolException;
import net.spy.pool.PoolFiller;
import net.spy.pool.PooledObject;
import net.spy.util.SpyConfig;

public class PoolContainer
extends SpyObject {
    private static final int MAX_RETRIES = 6;
    private static final int AVAILABILITY_WAIT = 500;
    private static final int MIN_MAX_AGE = 5000;
    private static final int DEFAULT_MAX_OBJECTS = 5;
    private static final int DEFAULT_YELLOW_LINE = 75;
    private static final float PERCENT = 100.0f;
    private static final int PING_ON_CHECKOUT = 1;
    private static final int TOSTRING_LEN = 256;
    private ArrayList<PoolAble> pool = null;
    private SpyConfig conf = null;
    private String name = null;
    private PoolFiller filler = null;
    private int minObjects = -1;
    private int initObjects = -1;
    private int maxObjects = -1;
    private long maxAge = 0L;
    private int yellowLine = -1;
    private int pingConfig = 0;
    private static int objectId = 0;

    public PoolContainer(String nm, PoolFiller pf, SpyConfig cnf) throws PoolException {
        this.conf = cnf;
        this.name = nm;
        this.filler = pf;
        this.initialize();
    }

    public PoolContainer(String nm, PoolFiller pf) throws PoolException {
        this(nm, pf, pf.getConfig());
    }

    public String getName() {
        return this.name;
    }

    private boolean checkAlive(PoolAble p, int when) {
        boolean rv = true;
        if ((this.pingConfig & when) != 0) {
            rv = p.isAlive();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledObject getObject() throws PoolException {
        PooledObject rv = null;
        PoolAble poolable = null;
        int retries = 6;
        ArrayList<PoolAble> arrayList = this.pool;
        synchronized (arrayList) {
            for (int retry = 0; poolable == null && retry < retries; ++retry) {
                for (PoolAble p : this.pool) {
                    if (!p.isAvailable() || !this.checkAlive(p, 1)) continue;
                    poolable = p;
                    break;
                }
                if (poolable == null && this.totalObjects() < this.yellowLine) {
                    poolable = this.getNewObject();
                }
                if (poolable != null) continue;
                try {
                    this.getLogger().debug("No free entries in pool, sleeping");
                    if (retry == retries / 2) {
                        this.getLogger().debug("Trying to force cleanup!");
                        GarbageCollector gc = GarbageCollector.getGarbageCollector();
                        gc.collect();
                    }
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.getLogger().debug("Interrupted");
                }
            }
            if (poolable != null) {
                rv = new PooledObject(poolable);
            }
        }
        if (rv == null) {
            poolable = this.getNewObject();
            rv = new PooledObject(poolable);
        }
        arrayList = this.pool;
        synchronized (arrayList) {
            this.getLogger().debug("Moving %s", poolable);
            this.pool.remove(poolable);
            this.pool.add(poolable);
        }
        return rv;
    }

    private String debugName() {
        return this.name + " @" + Integer.toHexString(this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Pool ");
        sb.append(this.debugName());
        sb.append(" - total Objects:  ");
        sb.append(this.totalObjects());
        sb.append(", available objects:  ");
        sb.append(this.availableObjects());
        sb.append('\n');
        ArrayList<PoolAble> arrayList = this.pool;
        synchronized (arrayList) {
            for (PoolAble p : this.pool) {
                sb.append("    ");
                sb.append(p);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int availableObjects() {
        int ret = 0;
        ArrayList<PoolAble> arrayList = this.pool;
        synchronized (arrayList) {
            for (PoolAble p : this.pool) {
                if (!p.isAvailable()) continue;
                ++ret;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prune() throws PoolException {
        this.getLogger().debug("Beginning prune.");
        ArrayList<PoolAble> arrayList = this.pool;
        synchronized (arrayList) {
            Iterator<PoolAble> it = this.pool.iterator();
            while (it.hasNext()) {
                PoolAble p = it.next();
                if (p.pruneStatus() >= 2) {
                    this.getLogger().debug("Removing " + p);
                    p.discard();
                    it.remove();
                    continue;
                }
                if (p.isAlive()) continue;
                p.discard();
                it.remove();
            }
            if (this.totalObjects() < this.minObjects) {
                this.getMinObjects();
            }
        }
    }

    private void initialize() throws PoolException {
        this.pool = new ArrayList();
        this.minObjects = this.getPropertyInt("min", 0);
        this.initObjects = this.getPropertyInt("start", this.minObjects);
        this.maxObjects = this.getPropertyInt("max", 5);
        this.yellowLine = (int)((float)this.maxObjects * (float)this.getPropertyInt("yellow_line", 75) / 100.0f);
        this.maxAge = this.getPropertyInt("max_age", 0);
        this.filler.setPoolHash(this.hashCode());
        this.getLogger().debug("Pool %s wants a min %s, max %s and yellow-line %s", this.debugName(), this.minObjects, this.maxObjects, this.yellowLine);
        if (this.getPropertyBool("pingOnCheckout", true)) {
            this.pingConfig |= 1;
        }
        try {
            this.getStartObjects();
        }
        catch (PoolException e) {
            for (PoolAble p : this.pool) {
                p.discard();
            }
            throw e;
        }
    }

    private void getMinObjects() throws PoolException {
        this.getLogger().debug("Pool %s wants at least %s object", this.name, this.minObjects);
        for (int i = this.totalObjects(); i < this.minObjects; ++i) {
            this.getNewObject();
        }
    }

    private void getStartObjects() throws PoolException {
        this.getLogger().debug("Pool %s starting with %s objects", this.name, this.initObjects);
        for (int i = this.totalObjects(); i < this.initObjects; ++i) {
            this.getNewObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolAble getNewObject() throws PoolException {
        PoolAble po = null;
        if (this.totalObjects() >= this.maxObjects) {
            this.prune();
        }
        if (this.totalObjects() < this.maxObjects) {
            this.getLogger().debug("*** Getting a new object in the %s pool, have %s/%s", this.name, this.totalObjects(), this.maxObjects);
            po = this.filler.getObject();
            po.setObjectID(PoolContainer.nextId());
            po.setPoolName(this.name);
            po.setMaxAge(this.calculateMaxAge());
            po.activate();
            ArrayList<PoolAble> arrayList = this.pool;
            synchronized (arrayList) {
                this.pool.add(po);
            }
        } else {
            throw new PoolException("Cannot create another object in the pool");
        }
        this.getLogger().debug("Added the object to the pool, now have %s", this.totalObjects());
        return po;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateMaxAge() {
        long rv = this.maxAge;
        ArrayList<PoolAble> arrayList = this.pool;
        synchronized (arrayList) {
            float percentFull;
            float factor;
            int poolSize = this.totalObjects();
            if (poolSize > this.minObjects && (rv = (long)((double)rv * (double)(factor = 1.0f - (percentFull = (float)poolSize / (float)this.maxObjects)))) < 5000L) {
                rv = 5000L;
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalObjects() {
        int ret = -1;
        ArrayList<PoolAble> arrayList = this.pool;
        synchronized (arrayList) {
            ret = this.pool.size();
        }
        return ret;
    }

    private int getPropertyInt(String what, int def) {
        return this.conf.getInt(this.name + "." + what, def);
    }

    private boolean getPropertyBool(String what, boolean def) {
        String s = this.getProperty(what, String.valueOf(def));
        Boolean b = Boolean.valueOf(s);
        return b;
    }

    private String getProperty(String what, String def) {
        return this.conf.get(this.name + "." + what, def);
    }

    private static synchronized int nextId() {
        return ++objectId;
    }
}

